/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32pen.h"


static void w32ldr_pen_class_init (W32LdrPenClass *klass);
static void w32ldr_pen_init       (W32LdrPen      *w32pen);


static GObjectClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_pen_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      const static GTypeInfo info =
      {
        sizeof (W32LdrPenClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)w32ldr_pen_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (W32LdrPen),
        0,                  /* n_preallocs */
        (GInstanceInitFunc)w32ldr_pen_init,
      };

      type = g_type_register_static (G_TYPE_OBJECT, "W32LdrPen", &info, 0);
    }

  return type;
}


static void
w32ldr_pen_class_init (W32LdrPenClass *klass)
{
  parent_class = g_type_class_peek_parent (klass);
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
w32ldr_pen_init (W32LdrPen *w32pen)
{
  w32pen->color.pixel = 0;
  w32pen->color.red = 0;
  w32pen->color.green = 0;
  w32pen->color.blue = 0;
}


/******************************************************************************
*                                                                             *
* ja:ペン関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrPen *
w32ldr_pen_new (void)
{
  return W32LDR_PEN (g_object_new (W32LDR_TYPE_PEN, NULL));
}


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrPen *
w32ldr_pen_new_with_color (GdkColor *color)
{
  W32LdrPen *w32pen;

  w32pen = w32ldr_pen_new ();
  w32ldr_pen_set_color (w32pen, color);
  return w32pen;
}


/*  ja:ペンをコピーする
    w32pen,オブジェクト
       RET,オブジェクト                                                     */
W32LdrPen *
w32ldr_pen_copy (W32LdrPen *w32pen)
{
  return W32LDR_IS_PEN (w32pen)
                        ? w32ldr_pen_new_with_color (&w32pen->color) : NULL;
}


/*  ja:ペンの色を取得する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_get_color (W32LdrPen *w32pen,
                      GdkColor  *color)
{
  if (W32LDR_IS_PEN (w32pen) && color)
    *color = w32pen->color;
}


/*  ja:ペンの色を設定する
    w32pen,オブジェクト
     color,色                                                               */
void
w32ldr_pen_set_color (W32LdrPen *w32pen,
                      GdkColor  *color)
{
  if (W32LDR_IS_PEN (w32pen) && color)
    w32pen->color = *color;
}
