/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32font.h"


static void w32ldr_font_class_init (W32LdrFontClass *klass);
static void w32ldr_font_init       (W32LdrFont      *w32font);


static GObjectClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_font_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      const static GTypeInfo info =
      {
        sizeof (W32LdrFontClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)w32ldr_font_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (W32LdrFont),
        0,                  /* n_preallocs */
        (GInstanceInitFunc)w32ldr_font_init,
      };

      type = g_type_register_static (G_TYPE_OBJECT, "W32LdrFont", &info, 0);
    }

  return type;
}


static void
w32ldr_font_class_init (W32LdrFontClass *klass)
{
  parent_class = g_type_class_peek_parent (klass);
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
w32ldr_font_init (W32LdrFont *w32font)
{
  w32font->desc = NULL;
}


/******************************************************************************
*                                                                             *
* ja:フォント関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrFont *
w32ldr_font_new (void)
{
  return W32LDR_FONT (g_object_new (W32LDR_TYPE_FONT, NULL));
}


/*  ja:新規作成
    desc,フォント
     RET,オブジェクト                                                       */
W32LdrFont *
w32ldr_font_new_with_description (const PangoFontDescription *desc)
{
  W32LdrFont *w32font;

  w32font = w32ldr_font_new ();
  w32ldr_font_set_description (w32font, desc);
  return w32font;
}


/*  ja:フォントをコピーする
    w32font,オブジェクト
         RET,オブジェクト                                                   */
W32LdrFont *
w32ldr_font_copy (W32LdrFont *w32font)
{
  return W32LDR_IS_FONT (w32font)
                    ? w32ldr_font_new_with_description (w32font->desc) : NULL;
}


/*  ja:フォントを取得する
    w32font,オブジェクト
       RET,フォント                                                        */
const PangoFontDescription *
w32ldr_font_get_description (W32LdrFont *w32font)
{
  return W32LDR_IS_FONT (w32font) ? w32font->desc : NULL;
}


/*  ja:フォントを設定する
    w32font,オブジェクト
       desc,フォント                                                        */
void
w32ldr_font_set_description (W32LdrFont                 *w32font,
                             const PangoFontDescription *desc)
{
  if (W32LDR_IS_FONT (w32font))
    {
      if (w32font->desc)
        pango_font_description_free (w32font->desc);
      w32font->desc = desc ? pango_font_description_copy (desc) : NULL;
    }
}
