/*
    Video maid
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "vmaid.h"
#include <gdk/gdkrgb.h>
#include <locale.h>
#include "command.h"
#include "file.h"
#include "general.h"
#include "icons.h"
#include "sigfile.h"
#include "sigmain.h"
#include "thread.h"
#include "avicore/aviclip.h"
#include "misc/argument.h"
#include "misc/fileio.h"
#include "misc/gnugpl.h"
#include "misc/license.h"
#include "misc/profile.h"
#include "orz/orzaccel.h"
#include "orz/orzcomm.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#include "orz/orzwinmenu.h"


gboolean caret = FALSE;             /* ja:キャレットの形 */
gboolean addext = TRUE;             /* ja:TRUE:拡張子を追加する */
gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gboolean default_ratio = FALSE;     /* ja:TRUE:縦/横の比率を保持する */
gboolean default_selfrm = TRUE;     /* ja:TRUE:選択されたフレーム表示 */
gboolean file_merge = FALSE;        /* ja:TRUE:連番,FALSE:単独 */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint default_view = 6;              /* ja:ウインドウが作成時の初期値 */
guint default_rate = 15;            /* ja:ウインドウが作成時の初期値 */
guint timer_id = 0;                 /* ja:タイマID */
GObject *clipboard;                 /* ja:クリップボード */
GObject *history;                   /* ja:ファイルの履歴 */
GdkBitmap *bitmap0;                 /* ja:波背景 */
GdkBitmap *bitmap1;                 /* ja:網背景 */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
GtkWidget *tview;                   /* ja:リストボックス */
GtkWidget *status;                  /* ja:ステータスウインドウ */
PangoLayout *system_font_layout = NULL;
gint system_font_height = 1;        /* ja:フォントの高さ */
GdkColor system_color[4] = {{0, 0x0000, 0x0000, 0x0000},
                            {0, 0xffff, 0xffff, 0xffff},
                            {0, 0x8000, 0x8000, 0x8000},
                            {0, 0x0000, 0x0000, 0x8000}};
MiscCreateMenuEntry menu_entries[] = {
{"/",                   NULL,                  NULL,          NULL,             MISC_CREATE_MENU_BAR,                               NULL,             NULL, NULL},
{"/file",               N_("_File"),           NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL, NULL},
{"/file/",              NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/file/new",           GTK_STOCK_NEW,         NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_new,      NULL, NULL},
{"/file/open",          GTK_STOCK_OPEN,        NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_open,     NULL, NULL},
{"/file/close",         GTK_STOCK_CLOSE,       NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_close,    NULL, NULL},
{"/file/saveas",        GTK_STOCK_SAVE_AS,     "<control>S",  NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_save,     NULL, NULL},
{"/file/sep1",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/file/preview",       N_("Pre_view"),        "<control>P",  preview16_xpm,    MISC_CREATE_MENU_ITEM,                              command_preview,  NULL, NULL},
{"/file/properties",    GTK_STOCK_PROPERTIES,  "<alt>Return", NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_property, NULL, NULL},
{"/file/sep2",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/file/exit",          GTK_STOCK_QUIT,        NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_exit,     NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/edit",               GTK_STOCK_EDIT,        NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,             NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/edit",               N_("_Edit"),           NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/edit/",              NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/edit/undo",          GTK_STOCK_UNDO,        "<control>Z",  NULL,             MISC_CREATE_MENU_STOCK,                             command_undo,     NULL, NULL},
{"/edit/redo",          GTK_STOCK_REDO,        "F4",          NULL,             MISC_CREATE_MENU_STOCK,                             command_redo,     NULL, NULL},
{"/edit/sep1",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/edit/cut",           GTK_STOCK_CUT,         NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,      NULL, NULL},
{"/edit/copy",          GTK_STOCK_COPY,        NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,     NULL, NULL},
{"/edit/paste",         GTK_STOCK_PASTE,       NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,    NULL, NULL},
{"/edit/delete",        GTK_STOCK_DELETE,      NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,   NULL, NULL},
{"/edit/sep2",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/edit/merge",         N_("_Merge"),          "<control>M",  merge16_xpm,      MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_merge,    NULL, NULL},
{"/edit/change",        N_("C_hange Frames"),  NULL,          change16_xpm,     MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_change,   NULL, NULL},
{"/edit/reverse",       N_("R_everse"),        NULL,          reverse16_xpm,    MISC_CREATE_MENU_ITEM,                              command_reverse,  NULL, NULL},
{"/edit/sep3",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/edit/jump",          GTK_STOCK_JUMP_TO,     "<control>J",  NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_jump,     NULL, NULL},
{"/edit/sep4",          NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/edit/all",           GTK_STOCK_SELECT_ALL,  "<control>A",  NULL,             MISC_CREATE_MENU_STOCK,                             command_all,      NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/edit/all",           N_("_All"),            "<control>A",  select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,      NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{"/view",               N_("_View"),           NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL, NULL},
{"/view/",              NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/view/size",          N_("S_ize"),           NULL,          size16_xpm,       MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_size,     NULL, NULL},
{"/view/frame",         N_("Selected _Frame"), NULL,          NULL,             MISC_CREATE_MENU_CHECK,                             command_frame,    NULL, NULL},
{"/option",             N_("_Option"),         NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL, NULL},
{"/option/",            NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/option/preferences", GTK_STOCK_PREFERENCES, NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_pref,     NULL, NULL},
{"/option/codec",       N_("_Codec"),          NULL,          codec16_xpm,      MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_codec,    NULL, NULL},
{"/task",               N_("_Task"),           NULL,          NULL,             MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_DISABLE,   NULL,             NULL, NULL},
{"/task/",              NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/task/cancel",        GTK_STOCK_CANCEL,      NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cancel,   NULL, NULL},
{"/window",             N_("_Window"),         NULL,          NULL,             MISC_CREATE_MENU_ITEM,                              NULL,             NULL, NULL},
{"/window/",            NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/help",               GTK_STOCK_HELP,        NULL,          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,             NULL, NULL},
{"/help/",              NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/help/about",         GTK_STOCK_ABOUT,       NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_version,  NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/help/about",         N_("_About"),          NULL,          about16_xpm,      MISC_CREATE_MENU_ITEM,                              command_version,  NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{NULL,                  NULL,                  NULL,          NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,             NULL, NULL}};
MiscCreateMenuEntry popup_entries[] = {
{"/",                   NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/undo",               GTK_STOCK_UNDO,        "<control>Z",  NULL,             MISC_CREATE_MENU_STOCK,                             command_undo,     NULL, NULL},
{"/sep1",               NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
{"/cut",                GTK_STOCK_CUT,         NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,      NULL, NULL},
{"/copy",               GTK_STOCK_COPY,        NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,     NULL, NULL},
{"/paste",              GTK_STOCK_PASTE,       NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,    NULL, NULL},
{"/delete",             GTK_STOCK_DELETE,      NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,   NULL, NULL},
{"/sep2",               NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,             NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/all",                GTK_STOCK_SELECT_ALL,  "<control>A",  NULL,             MISC_CREATE_MENU_STOCK,                             command_all,      NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/all",                N_("_All"),            "<control>A",  select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,      NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{NULL,                  NULL,                  NULL,          NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,             NULL, NULL}};
MiscCreateMenuEntry tview_entries[] = {
{"/",                   NULL,                  NULL,          NULL,             MISC_CREATE_MENU_SHELL,                             NULL,             NULL, NULL},
{"/cancel",             GTK_STOCK_CANCEL,      NULL,          NULL,             MISC_CREATE_MENU_STOCK,                             command_cancel,   NULL, NULL},
{NULL,                  NULL,                  NULL,          NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,             NULL, NULL}};
MiscCreateToolbarEntry toolbar_entries[] = {
{"new",        GTK_STOCK_NEW,        NULL,           command_new,      NULL, NULL},
{"open",       GTK_STOCK_OPEN,       NULL,           command_open,     NULL, NULL},
{"saveas",     GTK_STOCK_SAVE_AS,    NULL,           command_save,     NULL, NULL},
{"sep1",       NULL,                 NULL,           NULL,             NULL, NULL},
{"properties", GTK_STOCK_PROPERTIES, NULL,           command_property, NULL, NULL},
{"sep2",       NULL,                 NULL,           NULL,             NULL, NULL},
{"preview",    N_("Preview"),        preview24_xpm,  command_preview,  NULL, NULL},
{"sep3",       NULL,                 NULL,           NULL,             NULL, NULL},
{"cut",        GTK_STOCK_CUT,        NULL,           command_cut,      NULL, NULL},
{"copy",       GTK_STOCK_COPY,       NULL,           command_copy,     NULL, NULL},
{"paste",      GTK_STOCK_PASTE,      NULL,           command_paste,    NULL, NULL},
{"delete",     GTK_STOCK_DELETE,     NULL,           command_delete,   NULL, NULL},
{"sep4",       NULL,                 NULL,           NULL,             NULL, NULL},
{"undo",       GTK_STOCK_UNDO,       NULL,           command_undo,     NULL, NULL},
{"redo",       GTK_STOCK_REDO,       NULL,           command_redo,     NULL, NULL},
{NULL,         NULL,                 NULL,           NULL,             NULL, NULL}};


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files, success[4];
  const gchar *user_config;
  gint i, count = 0, license = -1;
  GKeyFile *key_file;
  GList *glist;
  GObject *accel, *winmenu;
  GdkPixmap *pixmap;
  GtkAccelGroup *accel_group;
  GtkCellRenderer *renderer;
  GtkListStore *store;
  GtkStyle *style;
  GtkTreeSelection *select;
  GtkTreeViewColumn *column;
  GtkWidget *text, *handle, *scroll, *vbox;
  /* en:Drag and Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};
  static gchar *xpm0[] = {
"4 8 2 1",
"   c None",
".  c #000000",
".   ",
".   ",
"   .",
"   .",
"  . ",
"  . ",
" .  ",
" .  "};
  static gchar *xpm1[] = {
"2 2 2 1",
"   c None",
".  c #000000",
". ",
" ."};
  /* ja:コマンドライン */
  gint array[2], def[2];
  ArgumentBool arg_n, arg_p, arg_x;
  ArgumentValue arg_h;
  ArgumentArray arg_s;
  ArgumentExit arg_g, arg_v;
  ArgumentHelp arg_q;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),                    ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),                   ARGUMENT_TYPE_BOOL,  &arg_n},
{"profile", 'p',  "ON/OFF",       N_("Profile"),                    ARGUMENT_TYPE_BOOL,  &arg_p},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"),                ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"),                ARGUMENT_TYPE_BOOL,  &arg_x},
{"license", 'g',  NULL,           N_("GNU GENERAL PUBLIC LICENSE"), ARGUMENT_TYPE_EXIT,  &arg_g},
{"version", 'v',  NULL,           N_("About"),                      ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),                       ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,                             0,                   NULL}};

  /* ja:初期化 */
  setlocale (LC_ALL, "");
#ifdef USE_THREAD
  g_thread_init (NULL);
  gdk_threads_init ();
#endif /* USE_THREAD */
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  bindtextdomain (PACKAGE, misc_spec_locale (argv[0]));
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
  avi_init ();
  g_atexit ((GVoidFunc)avi_exit);

  def_width = gdk_screen_width () * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;

  /* ja:ファイルの履歴 */
  history = orz_history_new ();

  /* ja:キーファイルを求める */
  user_config = misc_spec_config ("maid.org", "vmaid", "main");

  /* ja:レジストリから読み出す */
  key_file = g_key_file_new ();
  if (g_key_file_load_from_file (key_file, user_config, G_KEY_FILE_NONE, NULL))
    {
      gchar *utf8str;

      license = g_key_file_get_integer (key_file, "license", "hash", NULL);
      orz_history_set_num (ORZ_HISTORY (history),
                g_key_file_get_integer (key_file, "pref", "history", NULL));
      newfile = g_key_file_get_boolean (key_file, "pref", "newfile", NULL);
      second = g_key_file_get_boolean (key_file, "pref", "second", NULL);
      def_width = g_key_file_get_integer (key_file, "pref", "width", NULL);
      def_height = g_key_file_get_integer (key_file, "pref", "height", NULL);
      n_pos = g_key_file_get_integer (key_file, "pref", "npos", NULL);
      addext = g_key_file_get_boolean (key_file, "vmaid", "addext", NULL);
      default_ratio = g_key_file_get_boolean (key_file, "vmaid", "ratio",
                                                                        NULL);
      file_merge = g_key_file_get_boolean (key_file, "vmaid", "merge", NULL);
      default_view = g_key_file_get_integer (key_file, "vmaid", "view", NULL);
      default_rate = g_key_file_get_integer (key_file, "vmaid", "rate", NULL);
      default_selfrm = g_key_file_get_boolean (key_file, "vmaid", "selfrm",
                                                                        NULL);
      utf8str = g_key_file_get_string (key_file, "vmaid", "openpath", NULL);
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = g_key_file_get_string (key_file, "vmaid", "savepath", NULL);
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = orz_history_get_num (ORZ_HISTORY (history)) - 1; i >= 0; i--)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_key_file_get_string (key_file, "history", key, NULL);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              orz_history_add_file (ORZ_HISTORY (history), file);
              g_free (file);
            }
        }
    }
  g_key_file_free (key_file);

  if (license_hash (gnugpl) != license)
    license = license_dialog (gnugpl);
  if (license < 0)
    return 0;

  /* ja:コマンドライン */
  /* ja:ファイルの履歴 */
  arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
  arg_h.def = ORZ_HISTORY_NUM_DEF;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:レジストリ */
  arg_p.flag = TRUE;
  arg_p.def = TRUE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width () * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:ライセンス */
  arg_g.str = gnugpl;
  /* ja:バージョン */
  arg_v.str =
VMAID_VERSION_NOTICE"\n"
VMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
  /* ja:ヘルプ */
  arg_q.str = VMAID_COPYRIGHT_NOTICE"\n\n";
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  /* ja:ファイルの履歴 */
  orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
  /* ja:新規ファイル */
  newfile = arg_n.flag;
  /* ja:レジストリ */
  if (!arg_p.flag)
    user_config = NULL;
  /* ja:ウインドウサイズ */
  def_width = array[0];
  def_height = array[1];
  /* ja:新規ウインドウ */
  second = arg_x.flag;

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Video maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  glist = g_list_append (NULL, gdk_pixbuf_new_from_xpm_data (vmaid16_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (vmaid24_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (vmaid32_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (vmaid48_xpm));
  gtk_window_set_default_icon_list (glist);
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 0)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 1)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 2)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 3)));
  g_list_free (glist);
  g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
#ifndef USE_THREAD
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
#endif /* not USE_THREAD */
  gtk_widget_realize (window);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  /* ja:クリップボード */
  clipboard = avi_clip_new (window);
  g_signal_connect (G_OBJECT (clipboard), "paste",
                                    G_CALLBACK (signal_selection_paste), NULL);
  /* en:MDI */
  mdi = orz_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  gtk_drag_dest_set (mdi, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (mdi), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  g_signal_connect (GTK_OBJECT (mdi), "destroy",
                                G_CALLBACK (signal_destroy_mdi), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (popup_entries, accel_group);
  misc_create_menu (tview_entries, accel_group);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (menu_entries, accel_group);
  /* ja:ファイルの履歴 */
  for (i = 0; menu_entries[i].path; i++)
#if GLIB_CHECK_VERSION(2,2,0)
    if (g_str_has_prefix (menu_entries[i].path, "/file/"))
#else /* not GLIB_CHECK_VERSION(2,2,0) */
    if (g_strncmp (menu_entries[i].path, "/file/", 6) == 0)
#endif /* not GLIB_CHECK_VERSION(2,2,0) */
      count++;
  orz_history_set_menu (ORZ_HISTORY (history),
                        misc_find_menu (menu_entries, "/file/"), count - 3);
  g_signal_connect (ORZ_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = orz_winmenu_new ();
  orz_winmenu_set_mdi (ORZ_WINMENU (winmenu), ORZ_MDI (mdi));
  orz_winmenu_set_menu (ORZ_WINMENU (winmenu),
                                misc_find_menu (menu_entries, "/window/"), 0);
  /* ja:アクセルグループ */
  accel = orz_accel_new ();
  orz_accel_set_window (ORZ_ACCEL (accel), GTK_WINDOW (window));
  orz_accel_add_accel_group (ORZ_ACCEL (accel), accel_group);
  /* ja:リストボックス */
#if GTK_CHECK_VERSION(2,8,0)
  store = gtk_list_store_new (9, GDK_TYPE_PIXBUF,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 GDK_TYPE_PIXBUF,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_INT,
                                 G_TYPE_POINTER);
#elif GTK_CHECK_VERSION(2,6,0)
  store = gtk_list_store_new (6, G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_INT,
                                 G_TYPE_POINTER);
#else /* not GTK_CHECK_VERSION(2,6,0) */
  store = gtk_list_store_new (5, G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_STRING,
                                 G_TYPE_POINTER);
#endif /* not GTK_CHECK_VERSION(2,6,0) */
  tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
  /* ja:リストボックス,モード */
  column = gtk_tree_view_column_new ();
  gtk_tree_view_column_set_title (column, _("Mode"));
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
#if GTK_CHECK_VERSION(2,8,0)
  renderer = gtk_cell_renderer_pixbuf_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);
  gtk_tree_view_column_set_attributes (column, renderer,
                                    "pixbuf", THREAD_TVIEW_MODE_PIXBUF,
                                    "stock-id", THREAD_TVIEW_MODE_STOCK, NULL);
#endif /* GTK_CHECK_VERSION(2,8,0) */
  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start (column, renderer, TRUE);
  gtk_tree_view_column_set_attributes (column, renderer,
                                    "text", THREAD_TVIEW_MODE_TEXT, NULL);
  /* ja:リストボックス,ファイル */
  column = gtk_tree_view_column_new ();
  gtk_tree_view_column_set_title (column, _("File"));
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
#if GTK_CHECK_VERSION(2,8,0)
  renderer = gtk_cell_renderer_pixbuf_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);
  gtk_tree_view_column_set_attributes (column, renderer,
                                    "pixbuf", THREAD_TVIEW_FILE_PIXBUF, NULL);
#endif /* GTK_CHECK_VERSION(2,8,0) */
  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start (column, renderer, TRUE);
  gtk_tree_view_column_set_attributes (column, renderer,
                                    "text", THREAD_TVIEW_FILE_TEXT, NULL);
  /* ja:リストボックス,時間 */
  column = gtk_tree_view_column_new_with_attributes (_("Time"),
            gtk_cell_renderer_text_new (), "text", THREAD_TVIEW_TIME, NULL);
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
  /* ja:リストボックス,状況 */
#if GTK_CHECK_VERSION(2,6,0)
  column = gtk_tree_view_column_new_with_attributes (_("Status"),
    gtk_cell_renderer_progress_new (), "text", THREAD_TVIEW_STATUS_TEXT,
                                    "value", THREAD_TVIEW_STATUS_PROG, NULL);
#else /* not GTK_CHECK_VERSION(2,6,0) */
  renderer = gtk_cell_renderer_text_new ();
  g_object_set (G_OBJECT (renderer), "xalign", (gfloat)1.0, NULL);
  column = gtk_tree_view_column_new_with_attributes (_("Status"),
                            renderer, "text", THREAD_TVIEW_STATUS_TEXT, NULL);
  gtk_tree_view_column_set_alignment (column, 1.0);
#endif /* not GTK_CHECK_VERSION(2,6,0) */
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
  /* ja:リストボックス,その他 */
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_MULTIPLE);
  g_signal_connect (G_OBJECT (select), "changed",
                                            G_CALLBACK (signal_changed), NULL);
  g_signal_connect (G_OBJECT (tview), "button-press-event",
                            G_CALLBACK (signal_button_press_tview), select);
  gtk_widget_add_events (tview, GDK_BUTTON_PRESS_MASK);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scroll), tview);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  /* ja:ステータスバー */
  status = gtk_statusbar_new ();
  /* ja:テキスト */
  text = gtk_label_new ("");
  g_signal_connect (G_OBJECT (text), "style-set",
                                        G_CALLBACK (signal_style_set), NULL);
  /* ja:垂直ボックス/ハンドルボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_find_menu (menu_entries, "/"));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_create_toolbar (toolbar_entries));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mdi, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), status, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), text, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  /* ja:タイマ */
  timer_id = g_timeout_add (500, signal_timeout, NULL);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = orz_comm_new (window, "Video maid InterProcess communication");
      if (!orz_comm_is_first (ORZ_COMM (comm)))
        {
          orz_comm_send_with_files (ORZ_COMM (comm), argc, argv, arg_files);
          return 0;
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);
  gtk_widget_hide (text);

  /* ja:ピクスマップ */
  pixmap = gdk_pixmap_create_from_xpm_d (window->window, &bitmap0, NULL, xpm0);
  g_object_unref (pixmap);
  pixmap = gdk_pixmap_create_from_xpm_d (window->window, &bitmap1, NULL, xpm1);
  g_object_unref (pixmap);

  /* ja:システム色 */
  style = gtk_widget_get_style (text);
  system_color[0] = style->text[0];
  system_color[1] = style->base[0];
  system_color[2] = style->dark[0];
  system_color[3] = style->bg[3];
  gdk_colormap_alloc_colors (gdk_colormap_get_system (),
                                        system_color, 4, FALSE, TRUE, success);
  /* ja:システムフォント */
  system_font_layout = gtk_widget_create_pango_layout (text, NULL);
  for (i = 0; i < 128; i++)
    if (g_unichar_isprint ((gunichar)i))
      {
        int w, h;

        pango_layout_set_text (system_font_layout, (const char *)&i, 1);
        pango_layout_get_pixel_size (system_font_layout, &w, &h);
        if (system_font_height < h)
          system_font_height = h;
      }

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      {
        FileOpen *file_open;

        file_open = g_malloc (sizeof (FileOpen));
        file_open->file = g_strdup (argv[i]);
        file_open->merge = file_merge;
#ifdef USE_THREAD
        g_thread_create ((GThreadFunc)file_open_edit, file_open, TRUE, NULL);
#else /* not USE_THREAD */
        file_open_edit (file_open);
#endif /* not USE_THREAD */
        count++;
      }
  g_free (arg_files);
  if (newfile && count <= 0)
#ifdef USE_THREAD
    g_thread_create ((GThreadFunc)file_open_edit, NULL, TRUE, NULL);
#else /* not USE_THREAD */
    file_open_edit (NULL);
#endif /* not USE_THREAD */

#ifdef USE_THREAD
  gdk_threads_enter ();
  g_signal_connect (G_OBJECT (window), "destroy",
                    G_CALLBACK (signal_destroy),
                    GUINT_TO_POINTER (g_timeout_add (500, thread_idle, NULL)));
#endif /* USE_THREAD */
  gtk_main ();
#ifdef USE_THREAD
  gdk_threads_leave ();
#endif /* USE_THREAD */

  g_object_unref (bitmap0);
  g_object_unref (bitmap1);

  /* ja:レジストリに書き込む */
  if (user_config)
    {
      gsize length;
      gchar *data;

      key_file = g_key_file_new ();
      g_key_file_load_from_file (key_file, user_config, G_KEY_FILE_NONE, NULL);
      g_key_file_set_integer (key_file, "license", "hash", license);
      g_key_file_set_integer (key_file, "pref", "history",
                                orz_history_get_num (ORZ_HISTORY (history)));
      g_key_file_set_boolean (key_file, "pref", "newfile", newfile);
      g_key_file_set_boolean (key_file, "pref", "second", second);
      g_key_file_set_integer (key_file, "pref", "width", def_width);
      g_key_file_set_integer (key_file, "pref", "height", def_height);
      g_key_file_set_integer (key_file, "pref", "npos", n_pos);
      g_key_file_set_boolean (key_file, "vmaid", "addext", addext);
      g_key_file_set_boolean (key_file, "vmaid", "ratio", default_ratio);
      g_key_file_set_boolean (key_file, "vmaid", "merge", file_merge);
      g_key_file_set_integer (key_file, "vmaid", "view", default_view);
      g_key_file_set_integer (key_file, "vmaid", "rate", default_rate);
      g_key_file_set_boolean (key_file, "vmaid", "selfrm", default_selfrm);
      if (open_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "vmaid", "openpath", utf8str);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "vmaid", "savepath", utf8str);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = orz_history_get_file (ORZ_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          gchar *key, *utf8str;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "history", key, utf8str);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= ORZ_HISTORY_NUM_MAX)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i++);
          g_key_file_remove_key (key_file, "history", key, NULL);
          g_free (key);
        }
      data = g_key_file_to_data (key_file, &length, NULL);
      g_key_file_free (key_file);
      if (data)
        {
          fileio_save (user_config, data, length);
          g_free (data);
        }
    }

  g_object_unref (system_font_layout);
  g_free (open_path);
  g_free (save_path);
  return 0;
}
