/*
    Video maid
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __THREAD_H__
#define __THREAD_H__


#include "vmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define THREAD_MODE_EXIT 0
#define THREAD_MODE_OPEN 1
#define THREAD_MODE_SAVE 2
#define THREAD_MODE_CHANGE 3
#define THREAD_MODE_REVERSE 4
#if GTK_CHECK_VERSION(2,8,0)
# define THREAD_TVIEW_MODE_PIXBUF 0
# define THREAD_TVIEW_MODE_STOCK 1
# define THREAD_TVIEW_MODE_TEXT 2
# define THREAD_TVIEW_FILE_PIXBUF 3
# define THREAD_TVIEW_FILE_TEXT 4
# define THREAD_TVIEW_TIME 5
# define THREAD_TVIEW_STATUS_TEXT 6
# define THREAD_TVIEW_STATUS_PROG 7
# define THREAD_TVIEW_POINTER 8
#elif GTK_CHECK_VERSION(2,6,0)
# define THREAD_TVIEW_MODE_TEXT 0
# define THREAD_TVIEW_FILE_TEXT 1
# define THREAD_TVIEW_TIME 2
# define THREAD_TVIEW_STATUS_TEXT 3
# define THREAD_TVIEW_STATUS_PROG 4
# define THREAD_TVIEW_POINTER 5
#else /* not GTK_CHECK_VERSION(2,6,0) */
# define THREAD_TVIEW_MODE_TEXT 0
# define THREAD_TVIEW_FILE_TEXT 1
# define THREAD_TVIEW_TIME 2
# define THREAD_TVIEW_STATUS_TEXT 3
# define THREAD_TVIEW_POINTER 4
#endif /* not GTK_CHECK_VERSION(2,6,0) */
#ifndef USE_THREAD
# define THREAD_ID_STANDARD 0
# define THREAD_ID_CLOSE 1
#endif /* not USE_THREAD */


/******************************************************************************
*                                                                             *
* ja:スレッド描画関数群                                                       *
*                                                                             *
******************************************************************************/
#ifdef USE_THREAD
/*  ja:スレッドのアイドル処理
    data,データ
     RET,TRUE:継続,FALSE:終了                                               */
gboolean
thread_idle (gpointer data);
#endif /* USE_THREAD */


/******************************************************************************
*                                                                             *
* ja:スレッド制御関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:ウインドウを開く
    vmaid,ウインドウ情報
     file,ファイル名
      RET,TRUE:正常終了,FALSE:エラー                                        */
gboolean
thread_window (VmaidWindow *vmaid,
               const gchar *file);


/*  ja:履歴に追加する
    file,ファイル名
     RET,TRUE:正常終了,FALSE:エラー                                         */
gboolean
thread_history (const gchar *file);


/*  ja:リストに加える
      id,スレッドID
    mode,モード(0:終了,1:開く,2:保存,3:フレーム数,4:反転)
    file,ファイル名
     RET,TRUE:正常終了,FALSE:エラー                                         */
#ifdef USE_THREAD
gboolean
thread_insert (GThread     *id,
               const gint   mode,
               const gchar *file);
#else /* not USE_THREAD */
gboolean
thread_insert (gint          id,
               const gint    mode,
               const gchar *file);
#endif /* not USE_THREAD */


/*  ja:リストから削除する
     id,スレッドID
    RET,TRUE:正常終了,FALSE:エラー                                          */
#ifdef USE_THREAD
gboolean
thread_delete (GThread *id);
#else /* not USE_THREAD */
gboolean
thread_delete (gint id);
#endif /* not USE_THREAD */


/*  ja:リストを更新する
         id,スレッドID
    percent,進行状況
        RET,TRUE:継続,FALSE:中断                                            */
#ifdef USE_THREAD
gboolean
thread_idling (GThread    *id,
               const gint  percent);
#else /* not USE_THREAD */
gboolean
thread_idling (gint       id,
               const gint percent);
#endif /* not USE_THREAD */


/*  ja:スレッドを停止させる
    all,TRUE:すべてのスレッド,FALSE:選択されたスレッドのみ
    RET,TRUE:正常終了,FALSE:エラー                                          */
gboolean
thread_break (const gboolean all);


/*  ja:プログラムを終了させる
    RET,TRUE:正常終了,FALSE:エラー                                          */
gboolean
thread_exit (void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __THREAD_H__ */
