/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32LDR_H__
#define __W32LDR_H__


#include "windef.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define W32LDR_DIR_WINDOWS 0
#define W32LDR_DIR_SYSTEM  1
#define W32LDR_DIR_TEMP    2
#define W32LDR_DIR_DATA    3
#define W32LDR_DIR_HOME    4


typedef BOOL CALLBACK (*DllEntryProc)(HMODULE, DWORD, LPVOID);
typedef struct _W32LdrModule
{
  gchar *file, *name;
  gint counter;
  GHashTable *exports, *resource;
  GList *module;
  DllEntryProc DllMain;
} W32LdrModule;
typedef struct _W32LdrExport
{
  guint16 ordinal;
  gchar *name;
  gpointer func;
} W32LdrExport;


/******************************************************************************
*                                                                             *
* ja:モジュール関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:既にロードされているモジュールを取得する
    file,モジュール名
     RET,モジュール,NULL:ロードされていない                                 */
W32LdrModule *
w32ldr_get_module (const gchar *file);


/*  ja:モジュールをロードする
    file,モジュール名
    exec,TRUE:DllMainを実行する,FALSE:ロードのみ
     RET,モジュール,NULL:エラー                                             */
W32LdrModule *
w32ldr_load_module (const gchar    *file,
                    const gboolean  exec);


/*  ja:モジュールを解放する
    module,モジュール
       RET,TRUE:正常終了,NULL:エラー                                        */
gboolean
w32ldr_free_module (W32LdrModule *module);


/*  ja:モジュールからAPIを取得する
    module,モジュール
      name,API名
       RET,アドレス,NULL:エラー                                             */
gpointer
w32ldr_get_func (W32LdrModule *module,
                 const gchar  *name);


/*  ja:モジュールからリソースを取得する
    module,モジュール
       key,リソース
       RET,データ,NULL:エラー                                               */
gpointer
w32ldr_get_resource (W32LdrModule *module,
                     const gchar  *key);


/******************************************************************************
*                                                                             *
* ja:ディレクトリ関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:ディレクトリを取得する
    dir,ディレクトリの種類
    RET,ディレクトリ                                                        */
const gchar *
w32ldr_dir_get_path (const guint dir);


/*  ja:読み込みに適切なファイル名を取得する
    file,元のファイル名
     RET,適切なファイル名                                                   */
gchar *
w32ldr_dir_get_filename_for_read (const gchar *file);


/*  ja:書き込みに適切なファイル名を取得する
    file,元のファイル名
     RET,適切なファイル名                                                   */
gchar *
w32ldr_dir_get_filename_for_write (const gchar *file);


/******************************************************************************
*                                                                             *
* ja:文字列関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:UTF-8←MultiByte
     mb,MultiByte
    RET,UTF-8,NULL:エラー                                                   */
gchar *
w32ldr_utf8_from_mb (const gchar *mb);


/*  ja:UTF-8→MultiByte
    utf8str,UTF-8
        RET,MultiByte,NULL:エラー                                           */
gchar *
w32ldr_utf8_to_mb (const gchar *utf8str);


/*  ja:ファイル名←MultiByte
     mb,MultiByte
    RET,ファイル名,NULL:エラー                                              */
gchar *
w32ldr_filename_from_mb (const gchar *mb);


/*  ja:ファイル名→MultiByte
    file,ファイル名
     RET,MultiByte,NULL:エラー                                              */
gchar *
w32ldr_filename_to_mb (const gchar *file);


/*  ja:ファイル名←WideChar
     wc,WideChar
    RET,ファイル名,NULL:エラー                                              */
gchar *
w32ldr_filename_from_wc (const gunichar2 *wc);


/*  ja:ファイル名→WideChar
    file,ファイル名
     RET,WideChar,NULL:エラー                                               */
gunichar2 *
w32ldr_filename_to_wc (const gchar *file);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __W32LDR_H__ */
