/*
    Video maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "preview.h"
#include "avicore/aviplay.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* ja:プレビュー関数群                                                         *
*                                                                             *
******************************************************************************/
/* ja:ESCが押された */
static gboolean
preview_key_press (GtkWidget     *widget,
                   GdkEventKey   *event,
                   gpointer       user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return TRUE;
}


/*  ja:プレビュー
    vmaid,ウインドウ情報                                                    */
void
preview (VmaidWindow *vmaid)
{
  gint i = 0;
  GtkWidget *dialog, *play;
  AviEdit *avi_edit[3];

  /* ja:ウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Preview"));
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                        G_CALLBACK (preview_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                        G_CALLBACK (gtk_main_quit), NULL);
  /* en:AviPlay */
  play = avi_play_new ();
  avi_play_show_panel (AVI_PLAY (play));
  if (vmaid->avi_edit[0])
      avi_edit[i++] = vmaid->avi_edit[0];
  if (vmaid->avi_edit[1])
    avi_edit[i++] = vmaid->avi_edit[1];
  avi_edit[i] = NULL;
  avi_play_set_handle (AVI_PLAY (play), avi_edit);
  if (vmaid->avi_edit[0])
    avi_play_set_position (AVI_PLAY (play), vmaid->cursor.frame);
  else if (vmaid->avi_edit[1])
    avi_play_set_position (AVI_PLAY (play),
                    avi_time_to_sample (vmaid->avi_edit[1],
                    (gint)((glonglong)vmaid->cursor.frame * vmaid->scale * 1000
                                                            / vmaid->rate)));

  /* ja:フレームとボックス */
  gtk_container_add (GTK_CONTAINER (dialog), play);

  /* ja:表示 */
  gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (window));
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_skip_taskbar_hint (GTK_WINDOW (dialog), TRUE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  avi_play_set_shrink (AVI_PLAY (play), TRUE);
  gtk_main ();
}
