/*
    Video maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __CHANGE_H__
#define __CHANGE_H__


#include "vmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _ChangeFrames
{
  gint frames;
  AviEdit *avi_edit;
} ChangeFrames;
typedef struct _ChangeConfig
{
  gint frames, times;
  guint32 rate, scale;
} ChangeConfig;


/******************************************************************************
*                                                                             *
* ja:フレーム数変更関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:フレームを変更する(独立スレッド)
    chgfrm,フレーム数変更構造体
       RET,TRUE:正常終了,FALSE:エラー                                       */
gboolean
change_frames (ChangeFrames *chgfrm);


/******************************************************************************
*                                                                             *
* ja:フレーム数変更ダイアログ関数群                                           *
*                                                                             *
******************************************************************************/
/*  ja:フレーム数変更ダイアログ表示
    chgcfg,フレーム数変更構造体
       RET.TRUE:OK,FALSE:Cancel                                             */
gboolean
change_dialog (ChangeConfig *chgcfg);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CHANGE_H__ */
