/*
    Video maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __COMMAND_H__
#define __COMMAND_H__


#include "vmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:メニュー関数群                                                           *
*                                                                             *
******************************************************************************/
void
command_new (GtkWidget *widget,
             gpointer   user_data);


void
command_open (GtkWidget *widget,
              gpointer   user_data);


void
command_close (GtkWidget *widget,
               gpointer   user_data);


void
command_save (GtkWidget *widget,
              gpointer   user_data);


void
command_property (GtkWidget *widget,
                  gpointer   user_data);


void
command_exit (GtkWidget *widget,
              gpointer   user_data);


void
command_undo (GtkWidget *widget,
              gpointer   user_data);


void
command_redo (GtkWidget *widget,
              gpointer   user_data);


void
command_cut (GtkWidget *widget,
             gpointer   user_data);


void
command_copy (GtkWidget *widget,
              gpointer   user_data);


void
command_paste (GtkWidget *widget,
               gpointer   user_data);


void
command_delete (GtkWidget *widget,
                gpointer   user_data);


void
command_jump (GtkWidget *widget,
              gpointer   user_data);


void
command_all (GtkWidget *widget,
             gpointer   user_data);


void
command_size (GtkWidget *widget,
              gpointer   user_data);


void
command_conf (GtkWidget *widget,
              gpointer   user_data);


void
command_version (GtkWidget *widget,
                 gpointer   user_data);


void
command_cancel (GtkWidget *widget,
                gpointer   user_data);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __COMMAND_H__ */
