/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "ole32.h"


/******************************************************************************
*                                                                             *
* OLE32                                                                       *
*                                                                             *
******************************************************************************/
#include "pshpack1.h"
typedef struct _GUID
{
	unsigned long  Data1;
	unsigned short Data2;
	unsigned short Data3;
	unsigned char  Data4[8];
} GUID;
#include "poppack.h"
typedef GUID *LPGUID;
typedef GUID CLSID,*LPCLSID;
typedef GUID IID,*LPIID;
typedef GUID FMTID,*LPFMTID;
typedef LONG HRESULT;
typedef VOID *LPUNKNOWN;
typedef LPWSTR LPOLESTR;


#if defined(__cplusplus) && !defined(CINTERFACE)
#define REFGUID				const GUID &
#define REFCLSID			const CLSID &
#define REFIID				const IID &
#define REFFMTID			const FMTID &
#else /* !defined(__cplusplus) && !defined(CINTERFACE) */
#define REFGUID				const GUID* const
#define REFCLSID			const CLSID* const
#define REFIID				const IID* const
#define REFFMTID			const FMTID* const
#endif /* !defined(__cplusplus) && !defined(CINTERFACE) */
#define CLASS_E_NOAGGREGATION 0x80040110L
#define S_FALSE ((HRESULT)1L)


static HRESULT WINAPI CoCreateInstance(REFCLSID rclsid,LPUNKNOWN pUnkOuter,
									DWORD dwClsContext,REFIID iid,LPVOID *ppv)
{
	g_debug("CoCreateInstance");
	return CLASS_E_NOAGGREGATION;
}


static void WINAPI CoFreeUnusedLibraries(void)
{
	g_debug("CoFreeUnusedLibraries");
}


static HRESULT WINAPI CoInitialize(LPVOID lpReserved)
{
	g_debug("CoInitialize");
	return S_FALSE;
}


static LPVOID WINAPI CoTaskMemAlloc(ULONG size)
{
	g_debug("CoTaskMemAlloc");
	return NULL;
}


static void WINAPI CoTaskMemFree(LPVOID ptr)
{
	g_debug("CoTaskMemFree");
}


static void WINAPI CoUninitialize(void)
{
	g_debug("CoUninitialize");
}


static INT WINAPI StringFromGUID2(REFGUID id,LPOLESTR str,INT cmax)
{
	g_debug("StringFromGUID2");
	return 0;
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in ole32 called");
}


static SymbolInfo symbol_infos[]={
	{"CoCreateInstance",CoCreateInstance},
	{"CoFreeUnusedLibraries",CoFreeUnusedLibraries},
	{"CoInitialize",CoInitialize},
	{"CoTaskMemAlloc",CoTaskMemAlloc},
	{"CoTaskMemFree",CoTaskMemFree},
	{"CoUninitialize",CoUninitialize},
	{"StringFromGUID2",StringFromGUID2},
	{NULL,UnknownSymbol}
};


SymbolInfo *ole32_get_export_symbols(void)
{
	return symbol_infos;
}
