/*
    avicore
    copyright (c) 2000-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avifilesel.h"


static void avi_file_selection_class_init (AviFileSelectionClass *klass);
static void avi_file_selection_init       (AviFileSelection      *filesel);


static GtkWindowClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GtkType
avi_file_selection_get_type (void)
{
  static GType file_selection_type = 0;

  if (!file_selection_type)
    {
      static const GTypeInfo filesel_info =
      {
        sizeof (AviFileSelectionClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)avi_file_selection_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (AviFileSelection),
        0,              /* n_preallocs */
        (GInstanceInitFunc)avi_file_selection_init,
      };

      file_selection_type =
        g_type_register_static (GTK_TYPE_FILE_SELECTION, "AviFileSelection",
                                                            &filesel_info, 0);
    }

  return file_selection_type;
}


static void
avi_file_selection_class_init (AviFileSelectionClass *class)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  gobject_class = (GObjectClass*) class;
  object_class = (GtkObjectClass*) class;
  widget_class = (GtkWidgetClass*) class;

  parent_class = g_type_class_peek_parent (class);
}


static void
avi_file_selection_init (AviFileSelection *filesel)
{
  GtkWidget *hbox, *vbox;

  filesel->continual = FALSE;
  filesel->check = NULL;
  filesel->extra = NULL;

  /* ja:フレームとボックス */
  hbox = gtk_widget_get_parent (GTK_FILE_SELECTION (filesel)->ok_button);
  gtk_widget_ref (hbox);
  gtk_container_remove
            (GTK_CONTAINER (GTK_FILE_SELECTION (filesel)->main_vbox), hbox);
  gtk_widget_ref (GTK_FILE_SELECTION (filesel)->main_vbox);
  gtk_container_remove (GTK_CONTAINER (filesel),
                                    GTK_FILE_SELECTION (filesel)->main_vbox);

  filesel->hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (filesel->hbox),
                        GTK_FILE_SELECTION(filesel)->main_vbox, TRUE, TRUE, 0);
  gtk_widget_show (filesel->hbox);

  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), filesel->hbox, TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (filesel), vbox);
  gtk_widget_show (vbox);
}


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    title,タイトル
      RET,ウィジェット                                                      */
GtkWidget*
avi_file_selection_new (const gchar *title)
{
  AviFileSelection *filesel;

  filesel = g_object_new (AVI_TYPE_FILE_SELECTION, NULL);
  if (title)
    gtk_window_set_title (GTK_WINDOW (filesel), title);
  gtk_dialog_set_has_separator (GTK_DIALOG (filesel), FALSE);

  return GTK_WIDGET (filesel);
}


/*  ja:連続して読み込むチェックボタンを非表示にする
    filesel,ウィジェット                                                    */
void
avi_file_selection_hide_continual (AviFileSelection *filesel)
{
  if (filesel && filesel->check)
    {
      gtk_container_remove
                    (GTK_CONTAINER (GTK_FILE_SELECTION (filesel)->main_vbox),
                    filesel->check);
      filesel->check = NULL;
    }
}


/* 連続して読み込むチェックボタンが押されたとき */
static void
avi_file_selection_toggled (GtkWidget        *widget,
                            AviFileSelection *filesel)
{
  filesel->continual
                = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
}


/*  ja:連続して読み込むチェックボタンを表示にする
    filesel,ウィジェット                                                    */
void
avi_file_selection_show_continual (AviFileSelection *filesel)
{
  if (filesel && !filesel->check)
    {
      filesel->check = gtk_check_button_new_with_label (_("Continual"));
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (filesel->check),
                                    filesel->continual);
      g_signal_connect (G_OBJECT (filesel->check), "toggled",
                        G_CALLBACK (avi_file_selection_toggled), filesel);
      gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (filesel)->main_vbox),
                                            filesel->check, FALSE, FALSE, 0);
      gtk_widget_show (filesel->check);
    }
}


/*  ja:連続して読み込むチェックボタンを取得する
    filesel,ウィジェット
        RET,TRUE:連続して読み込む,FALSE:単独で読み込む                      */
/*gboolean
avi_file_selection_get_continual (AviFileSelection *filesel)
{
  return filesel ? filesel->continual : FALSE;
}*/


/*  ja:連続して読み込むチェックボタンを設定する
      filesel,ウィジェット
    continual,TRUE:連続して読み込む,FALSE:単独で読み込む                    */
void
avi_file_selection_set_continual (AviFileSelection *filesel,
                                  gboolean          continual)
{
  if (filesel)
    {
      filesel->continual = continual;
      if (filesel->check)
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (filesel->check),
                                                                    continual);
    }
}


/*  ja:AVI編集ハンドルを取得する
    filesel,ウィジェット
        RET,AVI編集ハンドル,NULL:設定なし                                   */
/*AviEdit**
avi_file_selection_get_handle (AviFileSelection *filesel)
{
  return filesel ? avi_file_extra_get_handle (filesel->extra) : NULL;
}*/


/******************************************************************************
*                                                                             *
*                                                                             *
*                                                                             *
******************************************************************************/
/*  ja:AVI編集ハンドルを設定する
     filesel,ウィジェット
    avi_edit,AVI編集ハンドル,NULL:設定なし                                  */
void
avi_file_selection_set_handle (AviFileSelection *filesel,
                               AviEdit          **avi_edit)
{
  if (filesel)
    {
      if (filesel->extra)
        {
          gtk_container_remove (GTK_CONTAINER (filesel->hbox), filesel->extra);
          filesel->extra = NULL;
        }
      if (avi_edit)
        {
          filesel->extra = avi_file_extra_new ();
          avi_file_extra_set_handle (AVI_FILE_EXTRA (filesel->extra),
                                                                    avi_edit);
          gtk_widget_show (filesel->extra);
          gtk_box_pack_start (GTK_BOX (filesel->hbox),
                                            filesel->extra, FALSE, FALSE, 0);
        }
    }
}


/*  ja:保存用のオプションを取得する
    filesel,ウィジェット
        RET,オプション,NULL:エラー                                          */
/*AviSave*
avi_file_selection_get_option (AviFileSelection *filesel)
{
  return filesel ? avi_file_extra_get_option (AVI_FILE_EXTRA (filesel->extra))
                 : NULL;
}*/
