/*
    conf
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "misc_conf.h"
#include <gdk/gdkkeysyms.h>


static void misc_conf_class_init (MiscConfClass *klass);
static void misc_conf_init       (MiscConf      *dialog);
static void misc_conf_close      (MiscConf      *dialog);


static GtkWindowClass *parent_class = NULL;


enum
{
  CLOSE_SIGNAL,
  LAST_SIGNAL
};


static gint misc_conf_signals[LAST_SIGNAL] = {0};


/******************************************************************************
*                                                                             *
******************************************************************************/
GtkType
misc_conf_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo info =
      {
        sizeof (MiscConfClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)misc_conf_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (MiscConf),
        0,              /* n_preallocs */
        (GInstanceInitFunc)misc_conf_init,
      };

      type = g_type_register_static (GTK_TYPE_WINDOW, "MiscConf", &info, 0);
    }

  return type;
}


static void
misc_conf_class_init (MiscConfClass *klass)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkBindingSet *binding_set;

  gobject_class = (GObjectClass*) klass;
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;

  parent_class = g_type_class_peek_parent (klass);

  klass->close = misc_conf_close;

  misc_conf_signals[CLOSE_SIGNAL]
                = g_signal_new ("close",
                                G_TYPE_FROM_CLASS (klass),
                                G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION,
                                G_STRUCT_OFFSET (MiscConfClass, close),
                                NULL, NULL,
                                g_cclosure_marshal_VOID__VOID,
                                G_TYPE_NONE, 0);

  binding_set = gtk_binding_set_by_class (klass);
  gtk_binding_entry_add_signal (binding_set, GDK_Escape, 0, "close", 0);
}


/* ja:OKボタンを表示 */
#define misc_conf_toggled misc_conf_changed
static void
misc_conf_changed (GtkWidget *widget,
                     MiscConf  *conf)
{
  gtk_widget_set_sensitive (conf->ok_button, TRUE);
}


/* ja:スピンボタンでリターンが押された */
static void
misc_conf_activate (GtkWidget *widget,
                    MiscConf  *conf)
{
  if (GTK_WIDGET_VISIBLE (conf->ok_button)
                                    && GTK_WIDGET_SENSITIVE (conf->ok_button))
    g_signal_emit_by_name (G_OBJECT (conf->ok_button), "clicked");
}


static void
misc_conf_close (MiscConf *conf)
{
  if (GTK_WIDGET_VISIBLE (conf->cancel_button)
                                && GTK_WIDGET_SENSITIVE (conf->cancel_button))
    g_signal_emit_by_name (G_OBJECT (conf->cancel_button), "clicked");
}


/* ja:閉じるボタンが押された */
static gboolean
misc_conf_delete (GtkWidget *widget,
                  GdkEvent  *event,
                  gpointer   user_data)
{
  if (GTK_WIDGET_VISIBLE (MISC_CONF (widget)->cancel_button)
                && GTK_WIDGET_SENSITIVE (MISC_CONF (widget)->cancel_button))
    g_signal_emit_by_name
                    (G_OBJECT (MISC_CONF (widget)->cancel_button), "clicked");
  return TRUE;
}


static void
misc_conf_init (MiscConf *conf)
{
  gint width, height;
  GtkWidget *label0, *label1, *label2;
  GtkWidget *frame0, *frame1, *hbox0, *hbox1, *vbox;

  width = gdk_screen_width ();
  height = gdk_screen_height ();

  /* ja:メインウインドウ */
  gtk_window_set_title (GTK_WINDOW (conf), _("Configuration"));
  g_signal_connect (G_OBJECT (conf), "delete-event",
                                        G_CALLBACK (misc_conf_delete), NULL);
  /* ja:ボタン */
  conf->ok_button     = gtk_button_new_with_label (_("OK"));
  conf->cancel_button = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (conf->ok_button,     GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (conf->cancel_button, GTK_CAN_DEFAULT);
  /* ja:チェックボタン */
  conf->newfile_check = gtk_check_button_new_with_mnemonic (_("_New File"));
  conf->second_check  = gtk_check_button_new_with_mnemonic (_("_Open Window"));
  g_signal_connect (G_OBJECT (conf->newfile_check), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  g_signal_connect (G_OBJECT (conf->second_check), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  /* ja:スピンボタン */
  conf->history_spin = gtk_spin_button_new (GTK_ADJUSTMENT
            (gtk_adjustment_new (4, 0, 10, 1, 5, 0)), 0, 0);
  conf->width_spin = gtk_spin_button_new (GTK_ADJUSTMENT
            (gtk_adjustment_new (width * 2 / 3, 0, width, 1, 5, 0)), 0, 0);
  conf->height_spin = gtk_spin_button_new (GTK_ADJUSTMENT
            (gtk_adjustment_new (height * 2 / 3, 0, height, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (conf->history_spin), TRUE);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (conf->width_spin), TRUE);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (conf->height_spin), TRUE);
  g_signal_connect (G_OBJECT (conf->history_spin), "activate",
                                        G_CALLBACK (misc_conf_activate), conf);
  g_signal_connect (G_OBJECT (conf->width_spin), "activate",
                                        G_CALLBACK (misc_conf_activate), conf);
  g_signal_connect (G_OBJECT (conf->height_spin), "activate",
                                        G_CALLBACK (misc_conf_activate), conf);
  g_signal_connect (G_OBJECT (conf->history_spin), "changed",
                                        G_CALLBACK (misc_conf_changed), conf);
  g_signal_connect (G_OBJECT (conf->width_spin), "changed",
                                        G_CALLBACK (misc_conf_changed), conf);
  g_signal_connect (G_OBJECT (conf->height_spin), "changed",
                                        G_CALLBACK (misc_conf_changed), conf);
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic (_("H_istory"));
  label1 = gtk_label_new_with_mnemonic (_("_Width"));
  label2 = gtk_label_new_with_mnemonic (_("_Height"));
  gtk_label_set_mnemonic_widget (GTK_LABEL(label0), conf->history_spin);
  gtk_label_set_mnemonic_widget (GTK_LABEL(label1), conf->width_spin);
  gtk_label_set_mnemonic_widget (GTK_LABEL(label2), conf->height_spin);
  /* ja:ラジオボタン */
  conf->top_radio = gtk_radio_button_new_with_mnemonic (NULL, _("_Top"));
  conf->left_radio = gtk_radio_button_new_with_mnemonic_from_widget
                        (GTK_RADIO_BUTTON (conf->top_radio), _("_Left"));
  conf->right_radio = gtk_radio_button_new_with_mnemonic_from_widget
                        (GTK_RADIO_BUTTON (conf->left_radio), _("_Right"));
  conf->bottom_radio = gtk_radio_button_new_with_mnemonic_from_widget
                        (GTK_RADIO_BUTTON (conf->right_radio), _("_Bottom"));
  g_signal_connect (G_OBJECT (conf->top_radio), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  g_signal_connect (G_OBJECT (conf->left_radio), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  g_signal_connect (G_OBJECT (conf->right_radio), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  g_signal_connect (G_OBJECT (conf->bottom_radio), "toggled",
                                        G_CALLBACK (misc_conf_toggled), conf);
  /* ja:フレームとボックス */
  frame0 = gtk_frame_new (_("Window Size"));
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (hbox0), SPACING);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), conf->width_spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), hbox1, TRUE, TRUE, 0);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), label2, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), conf->height_spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), hbox1, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (frame0), hbox0);

  frame1 = gtk_frame_new (_("Tab Position"));
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox0), conf->top_radio, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox0), conf->left_radio, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox0), conf->right_radio, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  hbox0 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), conf->bottom_radio, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), vbox);

  vbox = gtk_vbox_new (FALSE, SPACING);
  hbox0 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), label0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), conf->history_spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), conf->newfile_check, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), conf->second_check, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), frame0, FALSE, FALSE, 0);

  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox0), vbox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), frame1, TRUE, TRUE, 0);

  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, TRUE, TRUE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox0), conf->cancel_button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox0), conf->ok_button, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (conf), vbox);

  /* ja:表示 */
  gtk_window_set_policy (GTK_WINDOW (conf), FALSE, TRUE, FALSE);
  gtk_widget_show_all (vbox);
  gtk_widget_set_sensitive (conf->ok_button, FALSE);
  gtk_widget_grab_focus (conf->cancel_button);
}


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget*
misc_conf_new (void)
{
  return GTK_WIDGET (g_object_new (MISC_TYPE_CONF, NULL));
}


/*  ja:履歴を設定する
    conf,ウィジェット
     RET,履歴                                                               */
gint
misc_conf_get_history (MiscConf *conf)
{
  return gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (conf->history_spin));
}


/*  ja:新規ファイルを設定する
    conf,ウィジェット
     RET,新規ファイル                                                       */
gboolean
misc_conf_get_newfile (MiscConf *conf)
{
  return gtk_toggle_button_get_active
                                    (GTK_TOGGLE_BUTTON (conf->newfile_check));
}


/*  ja:新規ウインドウを設定する
    conf,ウィジェット
     RET,新規ウインドウ                                                     */
gboolean
misc_conf_get_second (MiscConf *conf)
{
  return gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (conf->second_check));
}


/*  ja:ウインドウサイズを設定する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
misc_conf_get_size (MiscConf *conf,
                    gint     *width,
                    gint     *height)
{
  if (width)
    *width = gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (conf->width_spin));
  if (height)
    *height = gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (conf->height_spin));
}


/*  ja:ノートブックの位置を設定する
    conf,ウィジェット
     RET,ノートブックの位置                                                 */
GtkPositionType
misc_conf_get_tab (MiscConf *conf)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (conf->left_radio)))
    return GTK_POS_LEFT;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (conf->right_radio)))
    return GTK_POS_RIGHT;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (conf->bottom_radio)))
    return GTK_POS_BOTTOM;
  return GTK_POS_TOP;
}


/*  ja:履歴を設定する
       conf,ウィジェット
    history,履歴                                                            */
void
misc_conf_set_history (MiscConf   *conf,
                       const gint  history)
{
  gboolean sensitive;

  sensitive = GTK_WIDGET_SENSITIVE (conf->ok_button);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (conf->history_spin), history);
  gtk_widget_set_sensitive (conf->ok_button, sensitive);
}


/*  ja:新規ファイルを設定する
       conf,ウィジェット
    newfile,新規ファイル                                                    */
void
misc_conf_set_newfile (MiscConf       *conf,
                       const gboolean  newfile)
{
  gboolean sensitive;

  sensitive = GTK_WIDGET_SENSITIVE (conf->ok_button);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (conf->newfile_check),
                                                                    newfile);
  gtk_widget_set_sensitive (conf->ok_button, sensitive);
}


/*  ja:新規ウインドウを設定する
      conf,ウィジェット
    second,新規ウインドウ                                                   */
void
misc_conf_set_second (MiscConf       *conf,
                      const gboolean  second)
{
  gboolean sensitive;

  sensitive = GTK_WIDGET_SENSITIVE (conf->ok_button);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (conf->second_check),
                                                                    second);
  gtk_widget_set_sensitive (conf->ok_button, sensitive);
}


/*  ja:ウインドウサイズを設定する
      conf,ウィジェット
     width,幅
    height,高さ                                                             */
void
misc_conf_set_size (MiscConf   *conf,
                    const gint  width,
                    const gint  height)
{
  gboolean sensitive;

  sensitive = GTK_WIDGET_SENSITIVE (conf->ok_button);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (conf->width_spin), width);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (conf->height_spin), height);
  gtk_widget_set_sensitive (conf->ok_button, sensitive);
}


/*  ja:ノートブックの位置を設定する
     conf,ウィジェット
    n_pos,ノートブックの位置                                                */
void
misc_conf_set_tab (MiscConf              *conf,
                   const GtkPositionType  n_pos)
{
  gboolean sensitive;

  sensitive = GTK_WIDGET_SENSITIVE (conf->ok_button);
  switch (n_pos)
    {
      case GTK_POS_TOP:
        gtk_toggle_button_set_active
                                (GTK_TOGGLE_BUTTON (conf->top_radio), TRUE);
        break;
      case GTK_POS_LEFT:
        gtk_toggle_button_set_active
                                (GTK_TOGGLE_BUTTON (conf->left_radio), TRUE);
        break;
      case GTK_POS_RIGHT:
        gtk_toggle_button_set_active
                                (GTK_TOGGLE_BUTTON (conf->right_radio), TRUE);
        break;
      case GTK_POS_BOTTOM:
        gtk_toggle_button_set_active
                                (GTK_TOGGLE_BUTTON (conf->bottom_radio), TRUE);
    }
  gtk_widget_set_sensitive (conf->ok_button, sensitive);
}
