/*
    avicore
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __AVI_FILESEL_H__
#define __AVI_FILESEL_H__


#include "avibase.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define AVI_TYPE_FILE_SELECTION            (avi_file_selection_get_type ())
#define AVI_FILE_SELECTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), AVI_TYPE_FILE_SELECTION, AviFileSelection))
#define AVI_FILE_SELECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), AVI_TYPE_FILE_SELECTION, AviFileSelectionClass))
#define AVI_IS_FILE_SELECTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AVI_TYPE_FILE_SELECTION))
#define AVI_IS_FILE_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AVI_TYPE_FILE_SELECTION))
#define AVI_FILE_SELECTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), AVI_TYPE_FILE_SELECTION, AviFileSelectionClass))


typedef struct _AviFileSelection      AviFileSelection;
typedef struct _AviFileSelectionClass AviFileSelectionClass;

struct _AviFileSelection
{
  /*< private >*/
  GtkFileSelection parent_instance;

  /*< public >*/
  gboolean continual;
  AviEdit **avi_edit;   /* ja:AVI編集構造体 */

  /*< private >*/
  gint video, audio;    /* ja:ビデオ/オーディオストリームの数 */
  AviSave *avi_save;    /* ja:保存の設定 */
  GtkWidget *hbox;      /* ja:最深部 */
  GtkWidget *vbox;      /* ja:基底部 */
  GtkWidget *check;     /* ja:連続して読み込むチェックボタン */
  GtkWidget *frame;     /* ja:ビットマップの範囲 */
  GtkWidget *notebook;  /* ja:ストリーム */
  GtkWidget *spin0;     /* ja:ビットマップの開始位置 */
  GtkWidget *spin1;     /* ja:ビットマップの終了位置 */
  GtkWidget *radio0;    /* en:AVI */
  GtkWidget *radio1;    /* ja:ビットマップ */
  GtkWidget *radio2;    /* en:WAVE */
  GtkWidget *radio3;    /* ja:シナリオオブジェクト */
};

struct _AviFileSelectionClass
{
  GtkFileSelectionClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
avi_file_selection_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数(りんご)                                                   *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    title,タイトル
      RET,ウィジェット                                                      */
GtkWidget*
avi_file_selection_new (const gchar *title);


/*  ja:連続して読み込むチェックボタンを非表示にする
    filesel,ウィジェット                                                    */
void
avi_file_selection_hide_continual (AviFileSelection *filesel);


/*  ja:連続して読み込むチェックボタンを表示にする
    filesel,ウィジェット                                                    */
void
avi_file_selection_show_continual (AviFileSelection *filesel);


/*  ja:連続して読み込むチェックボタンを取得する
    filesel,ウィジェット
        RET,TRUE:連続して読み込む,FALSE:単独で読み込む                      */
#define avi_file_selection_get_continual(filesel)                           \
(AVI_FILE_SELECTION(filesel)->continual)


/*  ja:連続して読み込むチェックボタンを設定する
      filesel,ウィジェット
    continual,TRUE:連続して読み込む,FALSE:単独で読み込む                    */
void
avi_file_selection_set_continual (AviFileSelection *filesel,
                                  gboolean          continual);


/*  ja:AVI編集ハンドルを取得する
    filesel,ウィジェット
        RET,AVI編集ハンドル,NULL:設定なし                                   */
#define avi_file_selection_get_handle(filesel)                              \
(AVI_FILE_SELECTION(filesel)->avi_edit)


/*  ja:AVI編集ハンドルを設定する
     filesel,ウィジェット
    avi_edit,AVI編集ハンドル,NULL:設定なし                                  */
void
avi_file_selection_set_handle (AviFileSelection *filesel,
                               AviEdit          **avi_edit);


/*  ja:保存用のオプションを取得する
    filesel,ウィジェット
        RET,オプション,NULL:エラー                                          */
AviSave*
avi_file_selection_get_option (AviFileSelection *filesel);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AVI_FILESEL_H__ */
