/* 
 *	Copyright (C) Aaron Holtzman - May 1999
 *
 *  This file is part of ac3dec, a free Dolby AC-3 stream decoder.
 *	
 *  ac3dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  ac3dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifdef __cplusplus
extern "C"
{
#endif



#ifndef DVD2AVI_INC_AC3_H
#define DVD2AVI_INC_AC3_H

#include "Ac3lib.h"
#include <windows.h>

//extern unsigned char * AC3Dec_Buffer;		// 48KB/frame for 64~448 Kbps

#if 1

/* Exponent strategy constants */
#define EXP_REUSE	(0)
#define EXP_D15		(1)
#define EXP_D25		(2)
#define EXP_D45		(3)

/* Delta bit allocation constants */
#define DELTA_BIT_REUSE		(0)
#define DELTA_BIT_NEW		(1)
#define DELTA_BIT_NONE		(2)
#define DELTA_BIT_RESERVED	(3)




/* coeff */
void mantissa_init(void);
void coeff_unpack(bsi_t *bsi, audblk_t *audblk, stream_samples_t samples);

/* crc */
int crc_process_frame(uint_8 *data,uint_32 num_bytes);

/* downmix */
void drc_init(int p_DRC_Flag);
void downmix(audblk_t *audblk, bsi_t* bsi, stream_samples_t stream_samples, sint_16 *s16_samples,ac3_context * p_Context);

/* exponent */
#define UNPACK_FBW  1
#define UNPACK_CPL  2
#define UNPACK_LFE  4

void exponent_init(void);
void exponent_unpack( bsi_t *bsi, audblk_t *audblk);

/* imdct */
void imdct(bsi_t *bsi,audblk_t *audblk, stream_samples_t samples);
void imdct_init(void);

/* parse */
void parse_syncinfo(syncinfo_t *syncinfo,uint_8 *data);
void parse_audblk(bsi_t *bsi,audblk_t *audblk);
void parse_bsi(bsi_t *bsi);

/* rematrix */
void rematrix(audblk_t *audblk, stream_samples_t samples);

/* sanity check */
void sanity_check(bsi_t *bsi, audblk_t *audblk);


//extern uint_32 error_flag;

#endif // 0

#endif

#ifdef __cplusplus
}
#endif
