/***********************************************************************
 * Common Tools -- Common classes used in various projects
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 * InputStream.h
 *
 *
 */

#ifndef __INPUTSTREAM_H__
#define __INPUTSTREAM_H__

#include "OGMCommonDefs.h"

class InputStream {
private:
	virtual void _initialize(void);
protected:
	char *name;
	s64   size;
public:
	InputStream(void);
	InputStream(char *name, s64 size);
	virtual ~InputStream(void);
	virtual char *get_name(void) { return name; };
	virtual s64   get_size(void) { return size; };
	virtual s64   get_pos(void) = 0;
	virtual s64   Seek(s64 offset, int pos) = 0;
	virtual long  Read(void *dest, long n_bytes) = 0;
	virtual bool  _EOF(void) = 0;
	virtual void  Close(void) = 0;
	virtual bool  SynchOn(unsigned short synch, unsigned short synch_bits, long max_search, long *search_length=NULL);
};

#endif /* __INPUTSTREAM_H__ */