/***********************************************************************
 * VirtualDub Modification for OGM
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 *
 *
 *
 */

#ifndef __OGMDUB_H__
#define __OGMDUB_H__

#include "OGMReadHandler.h"
#include "OGMAudioSource.h"
#include "../AudioSource.h"
#include "../Audio.h"
#include "../Dub.h"

struct ogm_stream {
	bool use;
	bool to_demux;
	OGMAudioSource *audio;
	int serial;
	int type;
	AudioStream *audioStream;
	DubAudioStreamInfo aInfo;
	long offset;
	long lStartOffsetMS;
	comment_list *comments;
	ogm_stream *next;

	void *operator new(unsigned int nAlloc) {
		ogm_stream *stream = (ogm_stream *)malloc(nAlloc);
		if(stream) {
			stream->use = true;
			stream->to_demux = false;
			stream->audio = NULL;
			stream->serial = 1;
			stream->type = AUDIO_TYPE_INPUTFILE;
			stream->audioStream = NULL;
			stream->comments = NULL;
			stream->next = NULL;
			memset(&stream->aInfo, 0, sizeof(stream->aInfo));
			stream->offset = 0;
			stream->lStartOffsetMS = 0;
		}
		return stream;
	}

	void operator delete(void *old_stream) {
		ogm_stream *stream = (ogm_stream *)old_stream;
		if(stream->audio)
			delete stream->audio;
		if(stream->audioStream)
			delete stream->audioStream;
		comment_list *comment = stream->comments;
		while(stream->comments) {
			comment = stream->comments->next;
			delete stream->comments;
			stream->comments = comment;
		}
		free(old_stream);
	}
};

IDubber *CreateOGMDubber(DubOptions *xopt, ogm_stream *ogm_streams);
//void InitOGMStreamValuesStatic(DubVideoStreamInfo& vInfo, DubAudioStreamInfo& aInfo, VideoSource *video, AudioSource *audio, DubOptions *opt, FrameSubset *pfs=NULL, long *plStartOffsetMS=NULL);
void InitOGMStreamValuesStatic(DubVideoStreamInfo& vInfo, DubAudioStreamInfo& aInfo, DubAudioStreamInfo& a2Info, VideoSource *video, AudioSource *audio, AudioSource *audio2, DubOptions *opt, FrameSubset *pfs=NULL, long *plStartOffsetMS=NULL, long *plStartOffset2MS=NULL);

#endif /* __OGMDUB_H__ */