/***********************************************************************
 * Common Definitions -- Common definitions used in various projects
 *
 * Copyright (C) 2002 Cyrius
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or visit http://www.gnu.org/copyleft/gpl.html
 *
 ***********************************************************************
 * CommonDefs.h
 *
 *
 */

#ifndef __COMMONDEFS_H__
#define __COMMONDEFS_H__

#include <windows.h>
#include <crtdbg.h>

// Definition of possible states
#define STATE_OK             0
#define STATE_EOS           -1
#define E_INVALID       -3

#define SWAP_SHORT_ENDIAN(a) ((((a)&0xFF)<<8)|(((a)>>8)&0xFF))

enum {AUDIO_TYPE_INPUTFILE=-1
, AUDIO_TYPE_OGM=0
, AUDIO_TYPE_AC3=1
, AUDIO_TYPE_MP3=2
, TEXT_TYPE_SRT=3};

/*
 * Typedefs found in the Azid dll development kit :
 *  Azid.h v1.8 build 825 (2002-02-19)
 *  Copyright (C) 1997-2002 Midas <midas@egon.gyaloglo.hu>
 */
typedef char             s8;  // Signed 8-bit type
typedef unsigned char    u8;  // Unsigned 8-bit type
typedef short            s16; // Signed 16-bit type
typedef unsigned short   u16; // Unsigned 16-bit type
typedef long             s32; // Signed 32-bit type
typedef unsigned long    u32; // Unsigned 32-bit type
typedef __int64          s64; // Signed 64-bit type
typedef unsigned __int64 u64; // Unsigned 64-bit type
//typedef u8               u1;  // Boolean type
// It seems preferable to use a real boolean type
typedef float            f32; // (32-bit) float
typedef double           d64; // (64-bit) double

// Also from Azid dll development kit
#ifndef false
#define false (0)
#endif
#ifndef true
#define true (1)
#endif


/*
 * Various function "mapping"
 * Map LSEEKI64 and TELLI64 to _lseeki64 and _telli64
 * Thos function uses 64 bits values, thus allowing (in theory)
 * breaking the 2GB filesize limit
 *
 * Other mappings are just here to stay coherent
 * This should also allow to compile this program under non
 * Win32 Environments (to do so, just map the function to the
 * one correponding to the aimed environment)
 */
#include <io.h>
#define LSEEKI64 _lseeki64
#define TELLI64 _telli64
#define OPEN _open
#define CLOSE _close
#define READ _read
#define WRITE _write
#define TRUNCATE _chsize
#define UNLINK _unlink
#define E_O_F _eof


#endif /* __COMMONDEFS_H__ */