//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_AVIOUTPUT_IMAGES_H
#define f_AVIOUTPUT_IMAGES_H

#include <windows.h>
#include <vfw.h>

class VideoSource;

//	pulco 04/11/2002 : merging with 1.4.11's targa support
class AVIOutputImages : public AVIOutput {
public:
	typedef enum {BITMAP,PNG,TARGA} ImageType;//	pulco 04/11/2002
private:
	//char szFormat[MAX_PATH];
	char mszFilePrefix[MAX_PATH];//	pulco 04/11/2002
	char mszFileSuffix[MAX_PATH];
	int iDigits;
//==============================//
//=====  MODIFICATION PNG  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
	ImageType mType;//	pulco 04/11/2002
//END ==========================//

public:
//==============================//
//=====  MODIFICATION PNG  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
	//AVIOutputImages(char *szFormat, int iDigits);
	AVIOutputImages(const char *pszPrefix, const char *pszSuffix, int iDigits, ImageType iType = BITMAP);//	pulco 04/11/2002
//END ==========================//
	~AVIOutputImages();

	BOOL initOutputStreams();
	BOOL init(const char *szFile, LONG xSize, LONG ySize, BOOL videoIn, BOOL audioIn, BOOL audioIn2, LONG bufferSize, BOOL is_interleaved);
	BOOL finalize();
	BOOL isPreview();

	void writeIndexedChunk(FOURCC ckid, LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer);
};

//==============================//
//=====  MODIFICATION PNG  =====//
//=====    -= Cyrius =-    =====//
//BEGIN ========================//
// AVIVideoImageOutputStream moved from AVIOutputImages.cpp to here
//	pulco 04/11/2002 : merging with 1.4.11's targa support
class AVIVideoImageOutputStream : public AVIVideoOutputStream {
//private:
	// Changed to protected for AVIVideoImagePNGOutputStream
protected:
	DWORD dwFrame;
	//char *szFormat;//	pulco 04/11/2002
	const char *mpszPrefix;
	const char *mpszSuffix;
	int iDigits;

	bool mbSaveAsTARGA;
	char *mpPackBuffer;

public:
	AVIVideoImageOutputStream(AVIOutput *out, const char *pszPrefix, const char *pszSuffix, int iDigits, bool bSaveAsTARGA);
	~AVIVideoImageOutputStream();



	// Added virtual
	virtual BOOL write(LONG dwIndexFlags, LPVOID lpBuffer, LONG cbBuffer, LONG lSamples);
	BOOL finalize();
};
//END ==========================//

#endif
