require 'wiki/wikistyle'

module Wiki
	class YukiWikiStyle < WikiStyle
		#*******************************************************************
		# Format Rule
		#*******************************************************************
		#-------------------------------------------------------------------
		# Block
		#-------------------------------------------------------------------
		# <h1> to <h6>
		FM_H1            = nil
		FM_H2            = '*%s'
		FM_H3            = '**%s'
		FM_H4            = nil
		FM_H5            = nil
		FM_H6            = nil
		RE_H1            = nil
		RE_H2            = /^\*{1}([^\*].*)$/
		RE_H3            = /^\*{2}([^\*].*)$/
		RE_H4            = nil
		RE_H5            = nil
		RE_H6            = nil

		# <hr />

		# <ul>
		TX_UL            = '-'
		RE_UL            = /^(\-{1,3})(.*)$/

		# <dl>
		TX_DT            = ':'
		TX_DD            = ':'
		RE_DL            = /^(\:)([^\:]+)\:(.*)$/

		# <blockquote>
		TX_BLOCKQUOTE    = '>'
		RE_BLOCKQUOTE    = /^(>{1,3})(.*)$/

		# <pre>

		# <table>

		#-------------------------------------------------------------------
		# Inline
		#-------------------------------------------------------------------
		# <strong>

		# <em>

		# URL

		#-------------------------------------------------------------------
		# Plugin
		#-------------------------------------------------------------------

		#*******************************************************************
		# Definitions
		#*******************************************************************
		BLOCK_PARSING_ORDER = [
			'pre','blockquote','table',
			'h3','h2',
			'hr','ul','dl',
		]
		INLINE_PARSING_ORDER = [
			'wikiname','uri','em','strong',
			'a','aliasname','bracketname',
		]
		ELEMENT_GENERATING_TAGS = [
			'wikiname', 'strong','table',
			'em', 'a',
			'pre', 'h2', 'h3', 'hr',
			'li', 'dl', 'blockquote','p',
		]
		INDENT_STYLE = false
		ALIAS_FORWARD = true

		#*******************************************************************
		# Block Parser
		#*******************************************************************
		def blockquote_onparse(root, match, line, indent, lines)
			text = match[1]+"\n"
			while @my::RE_BLOCKQUOTE === lines.first do
				text << $1+"\n"
				lines.shift
			end
			nbq = appendChild_block(root, 'blockquote', nil, text, 0, APPEND_CHILD)
			return nbq
		end

		#*******************************************************************
		# Inline Parser
		#*******************************************************************
		def a_onparse(root, match)
			appendChild_inline(root, 'a', {'href'=>match[2]}, match[1])
		end

		#*******************************************************************
		# Wiki Text Block Generator
		#*******************************************************************
		def blockquote_ontext(node, outobj='')
			generateChild(node).each do |line|
				outobj << TX_BLOCKQUOTE + line
			end
			return outobj
		end
		#*******************************************************************
		# Wiki Text Inline Generator
		#*******************************************************************

		#*******************************************************************
		# Wiki Text Plugin Generator
		#*******************************************************************

	end
end
