require 'wiki/wikistyle'

module Wiki
	class HikiStyle < WikiStyle
		#*******************************************************************
		# Format Rule
		#*******************************************************************
		#-------------------------------------------------------------------
		# Block
		#-------------------------------------------------------------------
		# <h1> to <h6>

		# <hr />

		# <ul>
		TX_UL            = '*'
		RE_UL            = /^(\*{1,3})(.*)$/

		# <ol>
		TX_OL            = '#'
		RE_OL            = /^(\#{1,3})(.*)$/

		# <dl>
		TX_DT            = ':'
		TX_DD            = ':'
		RE_DL            = /^(\:)([^\:]+)\:(.*)$/

		# <blockquote>
		TX_BLOCKQUOTE    = '""'
		RE_BLOCKQUOTE    = /^\"\"(.*)$/

		# <pre>

		#-------------------------------------------------------------------
		# Inline
		#-------------------------------------------------------------------
		# <strong>

		# <em>

		# <del>

		# <a>
		FM_A             = '[[%s|%s]]'
		RE_A             = /^\[\[([^|]+)\|(#{TX_URL})\]\]/

		# AliasName
		FM_ALIASNAME     = '[[%s|%s]]'
		RE_ALIASNAME     = /^\[\[(#{TX_WRIX})\|(#{TX_NOPARE_L})\]\]/

		# URL

		#-------------------------------------------------------------------
		# Plugin
		#-------------------------------------------------------------------

		# plugin
		FM_PLUGIN        = '{{%s%s%s}}'
		RE_PLUGIN        = /^\{\{(#{TX_IDENT})(?:\#(\S+))?(?:\((.+)\))?\}\}$/

		# plugin (inline)
		FM_INPLUGIN      = '{{%s%s%s}}'
		RE_INPLUGIN      = /^\{\{(#{TX_IDENT})(?:\#(\S+))?(?:\((.+)\))?\}\}/

		# Plugin Parameters
		RE_PLUGIN_SEP    = /^\s*,\s*/

		#*******************************************************************
		# Definitions
		#*******************************************************************
		BLOCK_PARSING_ORDER = [
			'plugin','pre','blockquote',
			'h6','h5','h4','h3','h2',
			'hr','ul','ol','dl',
		]
		INLINE_PARSING_ORDER = [
			'wikiname','uri','em','strong','del',
			'inplugin', 'a','aliasname','bracketname',
		]
		ELEMENT_GENERATING_TAGS = [
			'wikiname', 'plugin', 'del', 'strong',
			'em', 'a',
			'pre', 'h2', 'h3', 'h4', 'h5', 'h6', 'hr',
			'li', 'dl', 'blockquote','p',
		]
		INDENT_STYLE = false
		ALIAS_FORWARD = true

		#*******************************************************************
		# Block Parser
		#*******************************************************************
		def blockquote_onparse(root, match, line, indent, lines)
			text = match[1]+"\n"
			while @my::RE_BLOCKQUOTE === lines.first do
				text << $1+"\n"
				lines.shift
			end
			nbq = appendChild_block(root, 'blockquote', nil, text, 0, APPEND_CHILD)
			return nbq
		end

		#*******************************************************************
		# Inline Parser
		#*******************************************************************
		def a_onparse(root, match)
			appendChild_inline(root, 'a', {'href'=>match[2]}, match[1])
		end

		#*******************************************************************
		# Wiki Text Block Generator
		#*******************************************************************
		def hn_ontext(node, outobj='', level=1)
			outobj << '!' * (level - @conf['HNTOP'] + 1)
			outobj << generateChild(node)
			outobj << "\n"
			return outobj
		end
		def blockquote_ontext(node, outobj='')
			generateChild(node).each do |line|
				outobj << TX_BLOCKQUOTE + line
			end
			return outobj
		end
		#*******************************************************************
		# Wiki Text Inline Generator
		#*******************************************************************

		#*******************************************************************
		# Wiki Text Plugin Generator
		#*******************************************************************

	end
end
