module VikiWiki
	class Rss
		def initialize(sys)
			@sys = sys
		end
		def update
			items = Array::new
			@sys.pages.each do |page|
				ltime = File::mtime(page.path)
				if items.size >= @sys['RSSNUM'] then
					next if items[@sys['RSSNUM']-1][0] > ltime
					items.pop
				end
				date = ltime.xmlschema
				if @sys['STATICWIKI'] then
					uri = page.static.uri
				else
					uri = @sys.script_name + '?p='+page.name
				end
				item = Hash::new
				item['title'] = CGI::escapeHTML(page.alias)
				item['link'] = CGI::escapeHTML(@sys.fulluri(uri))
				item['description'] = CGI::escapeHTML(date)
				if @sys['RSSDESC'] then
					@sys['RSSDESC'].each do |name, value|
						value = 128 unless value
						case name
						when 'head' then
							item['description'] << "\n"
							item['description'] << CGI::escapeHTML(chomp(page.load, value))
						when 'diff' then
							item['description'] << "\n"
							item['description'] << CGI::escapeHTML(chomp(page.diff, value))
						end
					end
				end
				items << [ltime, item]
				items = items.sort{|a,b| -(a[0]<=>b[0])}
			end
			items.map!{|ltime, item| item}
			rss = @sys.rhtml('rss', binding)
			File::fwrite([@sys.basedir, @sys['RSSFILE']].path, rss)
		end
		def chomp(text, size)
			text = $& + '...' if /\A.{#{size}}/m === text
			return text.to_s
		end
	end
end
