require 'extension/cgi'
require 'extension/string'
require 'extension/time'
require 'cgiform'
require 'transtext'
require 'ftools'
require 'vikiwikisys'
require 'vikiwikiparser'

module VikiWiki
	PLUGINNAM = 'plugin'
	module Plugins
		module BaseModule
			include CGIForm
			include TransText
			def initialize(sys, name, id=nil, prms=[], plain='', inline=false)
				@sys, @name, @id, @prms, @plain, @inline = \
				 sys,  name,  id,  prms,  plain,  inline
				@called = Hash::new
			end
			def update(id, prms, plain, inline)
				@id, @prms, @plain, @inline = \
				 id,  prms,  plain,  inline
			end
			def oncall(func)
				@called[func] = true
				return self.method(func.intern).call
			end
			def called?(func); @called.key?(func); end
			def onview; end
			def onpost; end
			def ondesc; <<DSC; end
The plugin doesn't have the document.
DSC
			def safe; 5 ; end
		private
			def multipart_plugin_form(hiddens={}, attr={}, tableview=true, &block)
				plugin_form(hiddens, attr, tableview, true, &block)
			end
			def plugin_form(hiddens={}, attr={}, tableview=true, multipart=false)
				attr = Hash::new unless attr
				attr['enctype'] = 'multipart/form-data' if multipart
				attr['method'] = 'post'
				attr['action'] = plugin_form_script
				return '' unless attr['action']
				form(syshiddens(hiddens), attr, tableview) do |recv|
					yield recv
				end
			end
			def plugin_form_script
				return nil if @inline
				return @sys.script_name unless @sys.static?
				return @sys['PLUGIN_HOOK_SCRIPT'] if
					@sys['PLUGIN_HOOK_SCRIPT'] and
					@sys['PLUGIN_HOOK_NAMES'] and
					@sys['PLUGIN_HOOK_NAMES'].include?(@name)
				return @sys.script_name if @sys['STATICWIKI']
				return nil
			end
			def syshiddens(replaces)
				hiddens = {
					'c' => @sys.code,
					'h' => @sys.theme.name,
					'l' => @sys.lang,
					'f' => PluginsPage,
					'p' => @sys.page.name,
					'm' => @sys.cgi.params['m'][0],
					'pi_name' => @name,
					'pi_plain' => @plain.chomp,
					'pi_inline' => @inline.inspect,
				}
				hiddens.update(replaces) if replaces
				@prms.each_with_index do |prm, i|
					hiddens["pi_#{i}"] = prm if String === prm
				end if @prms
				return hiddens
			end
			def uri4get(attr={})
				attr['f'] = nil
				@sys.page.uri(syshiddens(attr))
			end
			def insert(pos_pat, target=nil)
				return if @sys.static?
				target = yield if iterator?
				return if target.nil? or target.empty?
				position, pattern = pos_pat.split(':')
				position, pattern = TransText::BACK, pos_pat unless TransText::POSITIONS.include?(position)
				pattern = @plain unless pattern
				res = TransText::insert(@sys.page.load, target, position, pattern)
				@sys.page.write(res)
			end
			def serialize(obj=nil, name=@name, datadir=@sys['DATADIR'])
				dir = [datadir, PLUGINNAM].path
				File::mkpath(dir)
				db = IStore::new([dir, "#{name}.txt"].path)
				obj ? db.write(obj) : db.read
			end
			def setcookie(keyword, value)
				name = "plugin_#{@name}_#{keyword}"
				c = CGI::Cookie::new(name, value)
				c.expires = Time::now+(30*24*60*60)
				@sys.header['cookie'] << c
				@sys.cgi.cookies[name] = Array::new unless @sys.cgi.cookies[name]
				@sys.cgi.cookies[name][0] = value
			end
			def getcookie(keyword)
				name = "plugin_#{@name}_#{keyword}"
				if @sys.static? then
					return ""
				else
					return @sys.cgi.cookies[name][0]
				end
			end
			def msg(text=nil, escaped=true)
				if text then
					return @msg = escaped ? text : CGI::escapeHTML(text)
				elsif @msg then
					return CGI::element('div', {'class'=>'msg'}){@msg}
				end
				return ''
			end
		end
		class BaseClass
			include BaseModule
		end
	end

	class Plugin
		def initialize(sys)
			@sys = sys
			@obj = Hash::new
			@viewing = Array::new
		end
		def onpost(name, id=nil, prms=[], plain='', inline=false)
			raise AccessDenied unless @sys.accessable?('plugin', name, 'w')
			oncall('onpost', name, id, prms, plain, inline)
		end
		def onview(name, id=nil, prms=[], plain='', inline=false)
			raise AccessDenied unless @sys.accessable?('plugin', name, 'r')
			return '' if @viewing.include?(name) and name != 'import'
			@viewing.push(name)
			begin
				res = oncall('onview', name, id, prms, plain, inline)
				case res
				when nil then
					res = ''
				when Array then
					res = res.join("\n")
				when Element then
					res = Parser::new(@sys).to_html(res)
				end
				return res
			rescue PluginError
				Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
				raise
			ensure
				@viewing.pop
			end
		end
		def ondesc(name)
			oncall('ondesc', name, nil, nil, nil, nil)
		end
		def oncall(func, name, id, prms, plain, inline)
			prms = @sys['DEFAULTPRMS'][name] if (prms.nil? or prms.empty?) and @sys['DEFAULTPRMS'] and @sys['DEFAULTPRMS'][name]
			unless @obj[name] then
				cls = plugin_load(name)
				raise Message::new(:FUNC_PLUGIN_NOT_FOUND, name, $!.to_s) unless cls
				plugin_load(name, @sys.lang)
				@obj[name] = cls.new(@sys, name, id, prms, plain, inline)
			else
				@obj[name].update(id, prms, plain, inline)
			end
			return nil if @obj[name].safe <= @sys['SAFE']
			return @obj[name].oncall(func)
		end
		def viewed?(name)
			@obj.key?(name) && @obj[name].called?('onview')
		end
		def posted?(name)
			@obj.key?(name) && @obj[name].called?('onpost')
		end
		def desced?(name)
			@obj.key?(name) && @obj[name].called?('ondesc')
		end
		def [](name)
			@obj[name]
		end
		def plugin_load(name, lang=nil)
			req = [PLUGINNAM, lang, [name, "rb"]].path
			path = nil
			$:.each do |dir|
				path = [dir, req].path
				break if File::exist?(path)
				path = nil
			end
			return nil unless path
			cap = name.capitalize
			if VikiWiki::Plugins::const_defined?(cap) then
				cls = VikiWiki::Plugins::const_get(cap)
			else
				cls = Class::new(VikiWiki::Plugins::BaseClass)
				VikiWiki::Plugins::const_set(cap, cls)
			end
			defs = File::readlines(path).join
			kcode = $KCODE
			begin
				$KCODE = USEconv::kcode(@sys.encoding) if @sys == 'ja'
				if /^\s+class\s+#{cap}\b/ === defs then
					eval(defs.untaint, TOPLEVEL_BINDING, path)
				else
					cls.class_eval(defs.untaint, path)
				end
			ensure
				$KCODE = kcode
			end
			return cls
		end
	end
end
