require 'ftools'
require 'extension/file'
require 'istore'
require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Farm
			include BaseModule
			def ondesc; <<DSC; end
The system plugin can manage the WikiFarm.
DSC
			ERR = Hash::new unless defined? ERR
			ERR['EXS_FDR'] = 'The folder name already exists.'
			ERR['INV_FDR'] = 'Invalid folder name specified. Use [A-Za-z0-9_] only.'
			ERR['MIS_PAS'] = 'Password is not specified or different from password for checking.'
			ERR['NON_ADM'] = 'Owner is not specified.'
			ERR['NON_ADR'] = 'E-Mail is not specified.'
			ERR['NON_PPS'] = 'Purpose is not specified.'
			ERR['NON_SIT'] = 'Site name is not specified.'
			ERR['NON_STY'] = 'Style is not specified.'
			ERR['NON_THM'] = 'Theme is not specified.'
			ERR['NON_TOP'] = 'TopPage is not specified.'
			ERR['NON_USR'] = 'OwnerAccount is not specified.'
			ERR['NOP_FAM'] = 'You can not manage WikiFarm.'
			LBL = Hash::new unless defined? LBL
			LBL['ADM_ACC'] = 'Owner'
			LBL['ADM_ADR'] = 'E-Mail'
			LBL['ADM_NAM'] = 'Owner Name'
			LBL['ADM_USR'] = 'OwnerAccount'
			LBL['PAS_CHK'] = 'Password(for checking)'
			LBL['PAS_NAM'] = 'Password'
			LBL['PPS_NAM'] = 'Purpose'
			LBL['REG_FAM'] = 'RegistFarm'
			LBL['FDR_NAM'] = 'FolderName'
			LBL['SIT_NAM'] = 'SiteName'
			LBL['STY_NAM'] = 'Style'
			LBL['THM_NAM'] = 'Theme'
			LBL['TOP_PAG'] = 'TopPage'
			LBL['EDT_SLF'] = 'EditByMyselfOnly'

			def safe; 3 ; end
			def onpost
				raise ERR['NOP_FAM'] unless @sys['WIKIFARM']
				account  = @sys.cgi.params['farm_account'][0].to_s
				unless auth_www? then
					passwd   = @sys.cgi.params['farm_password'][0].to_s
					passwd1  = @sys.cgi.params['farm_password'][1].to_s
					raise ERR['MIS_PAS'] if passwd.empty? or passwd != passwd1
				end
				name     = @sys.cgi.params['farm_name'][0].to_s
				author   = @sys.cgi.params['farm_author'][0].to_s
				address  = @sys.cgi.params['farm_address'][0].to_s
				purpose  = @sys.cgi.params['farm_purpose'][0].to_s
				toppage  = @sys.cgi.params['farm_toppage'][0].to_s
				site     = @sys.cgi.params['farm_site'][0].to_s
				style    = @sys.cgi.params['farm_style'][0].to_s
				theme    = @sys.cgi.params['farm_theme'][0].to_s
				raise ERR['NON_ACC'] if account.empty?
				raise ERR['INV_FDR'] unless /^[A-Za-z][A-Za-z0-9_]*$/ === name
				raise ERR['NON_ADM'] if author.empty?
				raise ERR['NON_ADR'] if address.empty?
				raise ERR['NON_TOP'] if toppage.empty?
				raise ERR['NON_PPS'] if purpose.empty?
				raise ERR['NON_SIT'] if site.empty?
				raise ERR['NON_THM'] if theme.empty?
				raise ERR['NON_STY'] if style.empty?

				newdir = [@sys['FARMDIR'], name].path
				newuri = [@sys['FARMURI'], name].path
				scfile = File::basename(@sys.script_name)
				fs = [newdir, scfile].path
				sc = [newuri, scfile].path
#				raise ERR['EXS_FDR'] if File::exist?(newdir)
				File::mkpath(newdir)

				begin
					conf = Hash::new
					CONF.keys.each do |key|
						conf[key] = @sys[key]
					end
					conf['ADMIN'] = account
					conf['AUTHOR'] = author
					conf['ADDRESS'] = address
					conf['TOPPAGE'] = toppage
					conf['SITENAME'] = site
					conf['THEMECSS'] = theme
					conf['WIKISTYLES'] = [style]
					conf['WIKIPARENT'] = @sys.script_name
					conf['SCRIPT_NAME'] = sc
					conf['BASEDIR'] = [@sys['BASEDIR'], FARMNAM, name].path if @sys['BASEDIR']
					conf['BASEURI'] = [@sys['BASEURI'], FARMNAM, name].path if @sys['BASEURI']
					conf['STATICDIR'] = [@sys['STATICDIR'], FARMNAM, name].path if @sys['STATICDIR']
					conf['STATICURI'] = [@sys['STATICURI'], FARMNAM, name].path if @sys['STATICURI']
					conf.delete("LAYOUT")
					sys = Sys::new(fs, conf)
					sys.setup
					sys.config(conf)

					File::mkpath(sys['DATADIR'])
					File::mkpath(sys['TEXTDIR'])
					File::mkpath(sys['IMGDIR'].first)
					File::mkpath(sys['THEMEDIR'].first)
					if conf['STATICDIR'] then
						File::mkpath(File::dirname(sys['STATICDIR']))
						File::mkpath(sys['STATICDIR'])
					end

					wpages = Array::new
					wc = [MASTERDIR, TEXTNAM, sys['LANG'], '*'].path
					Dir::glob(wc) do |f|
						n = File::basename(f).split('.').first.untaint
						next unless n
						next if /^Farm[A-Z]/ === n
						next unless @sys.pages[n].exist?
						wpage = @sys.pages[n]
						wpage = @sys.pages['Farm'+n] if @sys.pages['Farm'+n].exist?
						wpages << wpage
					end
					wpages.each do |wpage|
						wpage.links.each do |wlink|
							begin
								wlinkpage = @sys.pages[wlink]
								wlinkpage = @sys.pages['Farm'+wlink] if @sys.pages['Farm'+wlink].exist?
							rescue Exception
								next
							end
							next if wpages.include?(wlinkpage)
							wpages << wlinkpage
						end
					end
					wpages.each do |wpage|
						from = wpage.path
						to = from.sub(@sys['TEXTDIR'], sys['TEXTDIR']).sub('/Farm', '/')
						File::copyp(from, to) if File::exist?(from)
					end
					sys.links.generate(sys.pages.to_a)

					from = [@sys['THEMEDIR'].first, theme].path
					to = [sys['THEMEDIR'].first, theme].path
					Dir::copy(from, to, false) if File::exist?(from)

					from = @sys['IMGDIR'].first
					to = sys['IMGDIR'].first
					Dir::copy(from, to, true) if File::exist?(from)

					from = @sys.aliases.file
					to = sys.aliases.file
					File::copyp(from, to) if File::exist?(from)

					from = @sys.interwikis.file
					to = sys.interwikis.file
					File::copyp(from, to) if File::exist?(from)

					sys.sec.update(account, nil, passwd) unless auth_www?

					newac = AccessControl::new
					case @sys.cgi.params['farm_usefor'][0]
					when 'myself' then
						newac.type = 'page'
						newac.users = nil
						newac.target = /./
						newac.r = true
						newac.w = false
						newac.x = false
						newac.reid
						sys.acl << newac
					end
					sys.acl.update

					@sys.farms[name] = VikiWiki::Farm::new(
						address,
						author,
						purpose,
						name,
						toppage,
						site
					)
					@sys.farms.update
				rescue
					Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
					File::rm_rf(newdir)
					raise
				end
				raise VikiWiki::Location, sc
			end
			def onview
				raise ERR['NOP_FAM'] unless @sys['WIKIFARM']
				themes = Array::new
				@sys.themes.each{|theme|
					themes << theme.name
				}
				plugin_form {|res|
					res << [LBL['ADM_ACC'], text('farm_account', '')]
					res << [LBL['PAS_NAM'], password('farm_password')] unless auth_www?
					res << [LBL['PAS_CHK'], password('farm_password')] unless auth_www?
					res << [LBL['FDR_NAM'], text('farm_name', '', 20)]
					res << [LBL['SIT_NAM'], text('farm_site', '', 20)]
					res << [LBL['ADM_NAM'], text('farm_author', '', 20)]
					res << [LBL['ADM_ADR'], text('farm_address', '', 20)]
					res << [LBL['PPS_NAM'], textarea('farm_purpose', '', 40, 5)]
					res << [LBL['TOP_PAG'], text('farm_toppage', '', 20)]
					res << [LBL['STY_NAM'], select('farm_style', '', @sys['WIKISTYLES'])]
					res << [LBL['THM_NAM'], select('farm_theme', '', themes)]
					res << [checkbox('farm_usefor', 'myself', false, LBL['EDT_SLF']), nil]
					res << [submit('exec', LBL['REG_FAM']), nil]
				}
			end
			def auth_www?; @sys['AUTHTYPE'] == 'www'; end
		end
	end
end
