require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Comment
			include BaseModule
			def ondesc; <<DSC; end
The plugin can insert a comment.
For example, if you input {{#comment back "*%1 - %2 %m/%d" name,20 comment,40}},
it inserts '''* name - comment m/d'''.

{{{
#comment pos format labels ...
}}}
||pos||Specify top(top of page),bottom(bottom of page),front(front of plugin) or back(back of plugin).
||format||Use %1,%2,... in case of parameters. Use %Y,%m,%d(the same as strftime) in case of datetime.
||labels||Specify label,cols,rows,default separated by comma.
Specification of labels is as follows. It is also omissible.
||''form type'' ||''format''
||text          ||name,width,,default
||textarea      ||name,width,height,default,indent
||select        ||name,select(n),val;val;...,default
||checkbox      ||name,checkbox,on;off,default
||radio         ||name,radio,val;val;...,default
Description of format is the following.
:name:label name of field
:width:width of field
:height:height of field
:default:default value
  If you specify cookie, the value stored in cookie is the default vale.
:indent:number of indent to indent context
:select(n):list box with height n
:val;val;...:selectable value list
:on;off:value of on and value of off
DSC
			LBL = Hash::new unless defined? LBL
			LBL['ADD_CMT'] = 'WriteComment'
			LBL['LBL_CMT'] = 'Comment'

			def safe; 4 ; end
			def onpost
				pos, format, labels = comment_check
				comment = Array::new
				@sys.cgi.params.each{|k, v|
					comment[$1.to_i] = v[0] if /^comment_(\d+)/ === k
				}
				labels.each_with_index{|label, i|
					if label.default == 'cookie' then
						if comment[i].nil? or comment[i].empty? then
							comment[i] = getcookie(label.name)
						else
							setcookie(label.name, comment[i])
						end
					end
					comment[i] = label.apply(comment[i])
				}
				comment << Time::now
				insert(pos){
					format.emb(*comment).sub(/\n+\z/,'')+"\n"
				}
				raise VikiWiki::Location if @sys['STATICWIKI']
			end
			def onview
				pos, format, labels = comment_check
				fields = Array::new
				cookie_labels = Array::new
				labels.each{|label|
					dflt = label.default
					if dflt == 'cookie' then
						dflt = getcookie(label.name)
						cookie_labels << label.name
					end
					fields << label.field(dflt)
				}
				fields << [submit("exec", LBL['ADD_CMT']), nil]
				if cookie_labels.empty? then
					plugin_form {fields}
				else
					prms = '['+cookie_labels.map{|x| x.inspect}.join(",")+']'
					@sys.add_onload_script("comment_cookie_onload(#{prms})")
					@sys.add_script('comment')
					attr = {'onsubmit' => "comment_cookie_onsubmit(this, #{prms})"}
					plugin_form({}, attr) {fields}
				end
			end
		private
			def comment_check
				pos, format, *labels = @prms
				pos = TransText::BACK if pos.nil? or pos.empty?
				labels = [LBL['LBL_CMT']] if labels.nil? or labels.empty?
				labels.each_with_index{|label, i|
					labels[i] = CommentLabel::new(label, i)
					labels[i].default = 'cookie' \
						if labels[i].default.nil? and \
						@sys['COMMENT_COOKIE_LABELS'] and \
						@sys['COMMENT_COOKIE_LABELS'].include?(labels[i].name)
				}
				format = "* %1" if format.nil? or format.empty?
				return pos, format, labels
			end
		end
		class CommentLabel
			include CGIForm
			attr_reader :name, :width, :height, :vals, :type, :indent, :num
			attr_accessor :default
			def initialize(str, num)
				elms = str.to_s.split(',', -1)
				@num = num
				@name = elms[0] || 'comment'
				case elms[1]
				when /^select(\(\d+\))?$/ then
					@type = 'select'
					@height = $1.to_i
					@height = 1 if @height < 1
					@vals = elms[2].split(';')
					@default = elms[3]
				when 'checkbox' then
					@type = 'checkbox'
					@vals = elms[2].split(';')
					@default = elms[3]
				when 'radio' then
					@type = 'radio'
					@vals = elms[2].split(';')
					@default = elms[3]
				else
					@type = 'text'
					@width = elms[1].to_i
					@width = 20 if @width < 1
					@height = elms[2].to_i
					@height = nil if @height < 1
					@type = 'textarea' if @height
					@default = elms[3]
					@indent = elms[4].to_i if @type == 'textarea'
				end
			end
			def field(dflt)
				enam = "comment_#{@num}_#{@name}"
				case @type
				when 'select' then
					[@name, select(enam, dflt, @vals, @height, false)]
				when 'checkbox' then
					[checkbox(enam, @vals[0], dflt, @name), nil]
				when 'radio' then
					[@name, radio(enam, dflt, @vals).join("\n")]
				when 'textarea' then
				 	[@name, textarea(enam, dflt, @width, @height)]
				else
				 	[@name, text(enam, dflt, @width)]
				end
			end
			def apply(comment)
				case @type
				when 'select' then
					comment
				when 'checkbox' then
					@vals[0] == comment ? @vals[0] : @vals[1]
				when 'radio' then
					comment
				when 'textarea' then
				 	comment.to_a.map{|line|
				 		' ' * @indent + line
				 	}.join
				else
				 	comment
				end
			end
		end
	end
end
