require 'ftools'
require 'extension/file'
require 'vikiwikiplugin'

module VikiWiki
	module Plugins
		class Admin
			include BaseModule
			def ondesc; <<DSC; end
The system plugin is for administartors.
DSC
			ERR = Hash::new
			ERR['EXS_SEC'] = 'The access control already exist.'
			ERR['NON_ACC'] = "Account is not specified."
			ERR['NON_SIT'] = "Site name is not specified."
			ERR['GEN_STA'] = "Fail to generate static HTMLs %1."
			HED = Hash::new
			HED['ALT_CFG'] = 'Configure CGI options.'
			HED['DEL_FAM'] = 'Delete WikiFarm site.'
			HED['ECH_STA'] = 'Select each static HTML.'
			HED['EDT_CGI'] = 'Edit CGI file.'
			HED['EDT_PRM'] = 'Edit parameters.'
			HED['GEN_LNK'] = 'Generate links.'
			HED['GEN_STA'] = 'Generate and delete static HTML.'
			HED['DEL_PAG'] = 'Delete pages.'
			HED['REG_ADM'] = 'Regist and delete administrators.'
			HED['SET_SEC'] = 'Set up security fir each page and plugin.'
			HED['ADM_MNU'] = 'AdministrationMenu'
			LBL = Hash::new
			LBL['ACC_NAM'] = 'Account'
			LBL['ADM_NAM'] = 'Administrator'
			LBL['ADR_NAM'] = 'E-Mail'
			LBL['ATH_TYP'] = 'AuthenticateType'
			LBL['ATO_LNK'] = 'AutoLink'
			LBL['BAK_ALL'] = 'all'
			LBL['BAK_ANY'] = 'any'
			LBL['BAK_NON'] = 'no'
			LBL['CHK_UPD'] = 'ModifiedCheck'
			LBL['CPY_IMG'] = 'CopyImages'
			LBL['CPY_MAS'] = 'CopyFromMaster'
			LBL['CPY_THM'] = 'CopyThemes'
			LBL['DEL_ACC'] = 'DeleteAccount'
			LBL['DEL_PAG'] = "DeletePage"
			LBL['DEL_SEC'] = 'DeleteSecure'
			LBL['DEL_STA'] = 'DeleteStatic'
			LBL['DFT_STY'] = 'DefaultStyle'
			LBL['DIF_CMD'] = 'DiffCommand'
			LBL['DST_KND'] = 'DestinationKind'
			LBL['DST_NAM'] = 'DestinationName'
			LBL['ECH_STA'] = 'GenerateEachStaticHTML'
			LBL['EDT_CGI'] = 'EditCGI'
			LBL['EDT_PRM'] = 'EditParameters'
			LBL['EDT_THM'] = 'EditTheme'
			LBL['GEN_STA'] = 'GenerateStaticHTML'
			LBL['GEN_LNK'] = 'GenerateLinks.'
			LBL['GRE_CMD'] = 'GrepCommand'
			LBL['MNG_FAM'] = 'ManageWikiFarm'
			LBL['MOV_SEC'] = 'MoveaSecurity'
			LBL['MOV_UND'] = 'Move %1 to the under of %2'
			LBL['PAG_LBL'] = 'PageName'
			LBL['PLG_LBL'] = 'PlugIn'
			LBL['REG_ACC'] = 'RegistAccount'
			LBL['REG_CFG'] = 'RegistConfiguration'
			LBL['REG_SEC'] = 'RegistSecure'
			LBL['RST_PAG'] = "RestorePage"
			LBL['SAV_HIS'] = 'SaveHistories'
			LBL['SEC_RED'] = 'Readable'
			LBL['SEC_WRT'] = 'Writable'
			LBL['SEL_SEC'] = 'Select'
			LBL['SES_TMO'] = 'SessionTimeout'
			LBL['STA_DIR'] = 'StaticHTMLDirectory'
			LBL['STA_TIT'] = 'StaticHTMLTitle'
			LBL['STA_URI'] = 'StaticHTMLURI'
			LBL['THM_NAM'] = 'Theme'
			LBL['TIT_NAM'] = 'Title'
			LBL['TOP_PAG'] = 'TopPage'
			LBL['USE_STY'] = 'UsableStyles'
			LBL['USR_NAM'] = 'UserName'
			LBL['SEL_STA'] = 'select'
			LBL['PAG_NAM'] = 'page name'
			LBL['PAG_EXT'] = 'page exists?'
			LBL['STA_EXT'] = 'static exists?'
			LBL['FIL_TIM'] = 'updated time'
			LBL['MAK_UNI'] = 'unit making'
			LBL['MAK_STA'] = 'make'
			LBL['STA_ALL'] = "All pages are generated."
			LBL['STA_LNK'] = "The pages linked from the top page are generated."
			LBL['STA_SEL'] = "The pages selected in the following list are generated."
			LBL['UPD_PAG'] = "If the page is updated, the static HTML coresponding the page is generated."
			LBL['EXS_STA'] = "The static HTML is generated only if the static HTML exists."
			LBL['CPY_THM'] = "The theme directory is copied."
			LBL['CPY_IMG'] = "The img directory is copied."
			LBL['GEN_IDX'] = "The index.html is generated."
			LBL['DEL_ALL'] = "All static HTMLs are deleted before they are generated."
			LBL['STA_CMD'] = "Generate static HTMLs on background by 'static.rb' command."
			LBL['SEC_HIG'] = "High Priority"
			LBL['SEC_LOW'] = "Low Priority"
			MSG = Hash::new
			MSG['ADD_ACC'] = "Account %1 is registed."
			MSG['DEL_ACC'] = "Account %1 is deleted."
			MSG['DEL_HTM'] = "All HTML files have been deleted."
			MSG['DEL_PAG'] = "Pages have been deleted."
			MSG['EDT_CGI'] = 'Caution: The function rewrites the CGI script. If you mistake, "the CGI script cannot be execeted!"'
			MSG['GEN_LNK'] = "Links have been generated."
			MSG['GEN_STA'] = "Static HTMLs have been generated."
			MSG['GNG_STA'] = "Static HTMLs are being generated. Confirm the log %1."
			MSG['RST_PAG'] = "Pages have been restored."
			MSG['GEN_STA'] = "Pages have been generated."
			MSG['GEN_IDX'] = "index.html have been generated."
			MSG['CPY_IMG'] = "Image files have been copied."
			MSG['CPY_THM'] = "Themes have been copied."
			MSG['INV_PRM'] = "Invalid parameters are specified."
			MSG['NON_ADM'] = "You are not administrator."

			FUNCS = [
				['admin'  , 'REG_ADM'],
				['config' , 'ALT_CFG'],
				['secure' , 'SET_SEC'],
				['links'  , 'GEN_LNK'],
				['static' , 'GEN_STA'],
				['delpage', 'DEL_PAG'],
				['farm'   , 'DEL_FAM'],
				['param'  , 'EDT_PRM'],
				['edit'   , 'EDT_CGI'],
			]
			def FUNCS.[](key)
				if key.class == String then
					return nil unless val = FUNCS.assoc(key)
					val[1]
				else
					FUNCS.at(key)
				end
			end

			def safe; 3 ; end
			#==============================================
			# common
			#==============================================
			def onpost
				raise AccessDenied unless @sys.admins.include?(@sys.user)
				sel = @sys.cgi.params['admin_sel'][0]
				mode = @sys.cgi.params['admin_mode'][0]
				self.method("onpost_#{sel}").call(mode)
			end
			def onview
				raise AccessDenied unless @sys.admins.include?(@sys.user)
				sel = @sys.cgi.params['admin_sel'][0]
				res = Array::new
				res << CGI::element('div', {'class'=>'msg'}){msg}
				if sel then
					res << CGI::element('h2', nil, HED[FUNCS[sel]])
					res << self.method("onview_#{sel}").call
				end
				res << CGI::element('h2', nil, HED['ADM_MNU'])
				res << CGI::element('ul'){|recv|
					FUNCS.each{|func, head|
						next if func == sel
						uri = uri4get({'admin_sel'=>func, 'h'=>nil})
						ahref = CGI::element('a', {'href'=>uri}, HED[head])
						recv << CGI::element('li'){ahref}
					}
				}
				return res
			end
			#==============================================
			# Admin
			#==============================================
			def onpost_admin(mode)
				name = @sys.cgi.params['admin_name'][0]
				raise ERR['NON_ACC'] if name.nil? or name.blank?
				case mode
				when 'add'
					@sys.admins << name
					@sys.admins.update
					msg(MSG['ADD_ACC'].emb(name))
				when 'del'
					@sys.admins.delete(name)
					@sys.admins.update
					msg(MSG['DEL_ACC'].emb(name))
				else
					msg(MSG['INV_PRM'])
				end
			end
			def onview_admin
				res = Array::new
				res << plugin_form({'admin_sel'=>'admin', 'admin_mode'=>'add'}) {|recv|
					recv << [
						LBL['ACC_NAM'],
						text('admin_name'),
						submit('exec', LBL['REG_ACC'])
					]
				}
				unless @sys.admins.datas.empty? then
					res << plugin_form({'admin_sel'=>'admin', 'admin_mode'=>'del'}) {|recv|
						@sys.admins.each{|name|
							recv << radio('admin_name', name, false, name)
						}
						recv << submit('exec', LBL['DEL_ACC'])
					}
				end
				return res
			end
			#==============================================
			# Config
			#==============================================
			def onpost_config(mode)
				set = Hash::new
 				set['AUTHOR'] = @sys.cgi.params['admin_author'][0]
				set['ADDRESS'] = @sys.cgi.params['admin_address'][0]
				set['TOPPAGE'] = @sys.cgi.params['admin_toppage'][0]
				set['THEMECSS'] = @sys.cgi.params['admin_themecss'][0]
				set['EDITTHEME'] = boolvalue(@sys.cgi.params['admin_edittheme'][0])
				set['AUTOLINK'] = boolvalue(@sys.cgi.params['admin_autolink'][0])
				set['TITLE'] = @sys.cgi.params['admin_title'][0]
				set['WIKISTYLES'] = @sys.cgi.params['admin_dflt_style']
				unless @sys['WIKIPARENT'] then
					dflt_style = set['WIKISTYLES'][0]
					set['WIKISTYLES'] = @sys.cgi.params['admin_wikistyles']
					set['WIKISTYLES'].delete(dflt_style)
					set['WIKISTYLES'].unshift(dflt_style)
					set['AUTHTYPE'] = @sys.cgi.params['admin_authtype'][0]
					set['TIMEOUT'] = @sys.cgi.params['admin_timeout'][0].to_i
					set['BACKUP'] = @sys.cgi.params['admin_backup'][1].to_i
					set['BACKUP'] = boolvalue(@sys.cgi.params['admin_backup'][0]) if set['BACKUP'] == 0
					set['MODIFYCHECK'] = boolvalue(@sys.cgi.params['admin_modifycheck'][0])
					set['STATICTITLE'] = @sys.cgi.params['admin_statictitle'][0]
					set['STATICDIR'] = @sys.cgi.params['admin_staticdir'][0]
					set['STATICDIR'] = nil if set['STATICDIR'].to_s.empty?
					set['STATICURI'] = @sys.cgi.params['admin_staticuri'][0] if set['STATICDIR']
					set['WIKIFARM'] = boolvalue(@sys.cgi.params['admin_wikifarm'][0])
				end
				@sys.config(set)
				raise VikiWiki::Location, uri4get({'admin_sel'=>'config', 'h'=>nil})
			end
			def onview_config
				wikistyles = @sys['WIKISTYLES'].dup
				dflt_style = wikistyles.shift
				backup_flags = [
					['true',  LBL['BAK_ALL']],
					['false', LBL['BAK_NON']],
					['',      LBL['BAK_ANY']]
				]
				case @sys['BACKUP']
				when true then
					backup_flag, backup_num = 'true', ''
				when false then
					backup_flag, backup_num = 'false', ''
				else
					backup_flag, backup_num = '', @sys['BACKUP']
				end
				plugin_form({'admin_sel'=>'config','admin_mode'=>'upd'}) {|recv|
					recv << [LBL['ADM_NAM'], text('admin_author', @sys['AUTHOR'])]
					recv << [LBL['ADR_NAM'], text('admin_address', @sys['ADDRESS'])]
					recv << [LBL['TOP_PAG'], text('admin_toppage', @sys['TOPPAGE'])]
					recv << [LBL['TIT_NAM'], text('admin_title', @sys['TITLE'], 20)]
					recv << [LBL['THM_NAM'], text('admin_themecss', @sys['THEMECSS'], 40)]
					recv << [LBL['EDT_THM'], select('admin_edittheme', @sys['EDITTHEME'])]
					recv << [LBL['ATO_LNK'], select('admin_autolink', @sys['AUTOLINK'])]
					recv << [LBL['DFT_STY'], select('admin_dflt_style', dflt_style, @sys['WIKISTYLES'])]
					unless @sys['WIKIPARENT'] then
						recv << [LBL['USE_STY'], select('admin_wikistyles', wikistyles, ALLSTYLES, 5, true)]
						recv << [LBL['ATH_TYP'], select('admin_authtype', @sys['AUTHTYPE'], ['none','form','www','vikiwiki'])]
						recv << [LBL['SES_TMO'], text('admin_timeout', @sys['TIMEOUT'], 10)]
						recv << [LBL['SAV_HIS'], select('admin_backup', backup_flag, backup_flags)+text('admin_backup', backup_num, 5)]
						recv << [LBL['CHK_UPD'], select('admin_modifycheck', @sys['MODIFYCHECK'])]
						recv << [LBL['STA_TIT'], text('admin_statictitle', @sys['STATICTITLE'], 20)]
						recv << [LBL['STA_DIR'], text('admin_staticdir', @sys['STATICDIR'], 40)]
						recv << [LBL['STA_URI'], text('admin_staticuri', @sys['STATICURI'], 40)]
						recv << [LBL['MNG_FAM'], select('admin_wikifarm', @sys['WIKIFARM'])]
					end
					recv << [submit('exec', LBL['REG_CFG']), nil]
				}
			end
			#==============================================
			# Secure
			#==============================================
			def onpost_secure(mode)
				case mode
				when 'add' then
					newac = AccessControl::new
					newac.type = @sys.cgi.params['secure_kind'][0]
					newac.users = @sys.cgi.params['secure_user'][0].to_any
					newac.target = @sys.cgi.params['secure_dest'][0].to_any
					raise MSG['INV_PRM'] unless newac.target
					newac.r = @sys.cgi.params['secure_read'][0] == 'on'
					newac.w = @sys.cgi.params['secure_write'][0] == 'on'
					newac.x = @sys.cgi.params['secure_exec'][0] == 'on'
					newac.reid
					@sys.acl.each{|ac|
						raise ERR['EXS_SEC'] if ac == newac
					}
					@sys.acl << newac
				when 'del' then
					wid = @sys.cgi.params['secure_id'][0]
					@sys.acl.delete(wid)
				when 'alt' then
					fid = @sys.cgi.params['secure_fid'][0]
					tid = @sys.cgi.params['secure_tid'][0]
					@sys.acl.swap(fid, tid)
				end
				@sys.acl.update
			end
			def onview_secure
				res = Array::new
				types = [
					['page',LBL['PAG_LBL']],
					['plugin',LBL['PLG_LBL']]
				]
				res << plugin_form({'admin_sel'=>'secure','admin_mode'=>'add'}) {|recv|
					recv << [LBL['DST_KND'], select('secure_kind', LBL['PAG_LBL'], types)]
					recv << [LBL['USR_NAM'], text('secure_user')]
					recv << [LBL['DST_NAM'], text('secure_dest')]
					recv << [checkbox('secure_read')+LBL['SEC_RED'], nil]
					recv << [checkbox('secure_write')+LBL['SEC_WRT'], nil]
					recv << [submit('exec', LBL['REG_SEC']), nil]
				}
				secs = Array::new
				res << plugin_form({'admin_sel'=>'secure','admin_mode'=>'del'}) {|recv|
					recv << [
						LBL['SEL_SEC'],
						LBL['DST_KND'],
						LBL['USR_NAM'],
						LBL['DST_NAM'],
						LBL['SEC_RED'],
						LBL['SEC_WRT']
					]
					recv << [LBL['SEC_HIG'],nil,nil,nil,nil,nil]
					@sys.acl.each{|ac|
						next unless ac
						recv << [
							radio('secure_id', ac.id),
							ac.type,
							ac.users.inspect,
							ac.target.inspect,
							ac.r.inspect,
							ac.w.inspect
						]
						secs << ac.id
					}
					recv << [LBL['SEC_LOW'],nil,nil,nil,nil,nil]
					recv << [
						submit('exec', LBL['DEL_SEC']),
						nil, nil, nil, nil, nil
					]
				}
				res << plugin_form({'admin_sel'=>'secure','admin_mode'=>'alt'}) {|recv|
					recv << LBL['MOV_UND'].emb(
						select('secure_fid', nil, secs),
						select('secure_tid', nil, secs))
					recv << submit('exec', LBL['MOV_SEC'])
				}
			end
			#==============================================
			# Links
			#==============================================
			def onpost_links(sel)
				all_pages = @sys.pages.to_a
				@sys.links.generate(all_pages)
				msg(MSG['GEN_LNK'])
			end
			def onview_links
				plugin_form({'admin_sel'=>'links','admin_mode'=>'gen'}) {
					submit('exec', LBL['GEN_LNK'])
				}
			end
			#==============================================
			# Static
			#==============================================
			def onpost_static(sel)
				if @sys.cgi.params['admin_sta_cmd'][0] == 'on' then
					opt = 'q'
					case @sys.cgi.params['admin_upd_mod'][0]
					when 'update' then opt << 'u'
					when 'exist' then opt << 'e'
					when 'delete' then opt << 'd'
					end
					opt << 'x' if @sys.cgi.params['admin_gen_idx'][0] == 'on'
					opt << 'i' if @sys.cgi.params['admin_cpy_img'][0] == 'on'
					opt << 't' if @sys.cgi.params['admin_cpy_thm'][0] == 'on'
					pages = ''
					case @sys.cgi.params['admin_gen_mod'][0]
					when 'link' then
						opt << 'l'
					when 'sel' then
						pages = getpages
					end
					logfile = "#{$VIKIWIKITMP}/static#{$$}.log"
					cmd = [
						$VIKIWIKIRUBY,
						"-K#{$KCODE}",
						"#{$VIKIWIKIDIR}/../tool/static.rb",
						"-#{opt}",
						"-o #{$VIKIWIKITMP}/static#{$$}.log",
						@sys.local_file,
						@sys.script_name,
						pages
					]
					if /win/i === RUBY_PLATFORM then
						cmd[0] = "cmd /c start " + cmd[0].gsub(/\//, "\\")
					else
						cmd << '&'
					end
					system(cmd.join(' ').untaint)
					msg(MSG['GNG_STA'].emb([logfile]))
				else
					res = ''
					res << MSG['GEN_STA']
					res << "\n"
					flags = Hash::new
					case @sys.cgi.params['admin_upd_mod'][0]
					when 'update' then
						flags['update'] = true
					when 'exist' then
						flags['exist'] = true
					when 'delete' then
						@sys.statics.delete_all
						@sys.statics.generate_location_all
						res << MSG['DEL_HTM']
						res << "\n"
					end
					if @sys.cgi.params['admin_gen_idx'][0] == 'on' then
						@sys.statics.generate_index_html
						res << MSG['GEN_IDX']
						res << "\n"
					end
					if @sys.cgi.params['admin_cpy_img'][0] == 'on' then
						@sys.statics.copy_image
						res << MSG['CPY_IMG']
						res << "\n"
					end
					if @sys.cgi.params['admin_cpy_thm'][0] == 'on' then
						@sys.statics.copy_theme
						res << MSG['CPY_THM']
						res << "\n"
					end
					case @sys.cgi.params['admin_gen_mod'][0]
					when 'link' then
						flags['link'] = true
						@sys.statics.generate(@sys['TOPPAGE'], flags, res.method(:<<))
					when 'sel' then
						getpages.each{|page|
							@sys.statics.generate(page, flags, res.method(:<<))
						}
					else
						@sys.pages.each{|page|
							@sys.statics.generate(page, flags, res.method(:<<))
						}
					end
					msg(CGI::element('pre', {}, res))
				end
			end
			def onview_static
				return unless @sys.staticable?
				pages = Hash::new
				statics = Hash::new
				names = Array::new
				@sys.pages.each{|page|
					pages[page.name] = page
					names << page.name
				}
				@sys.statics.each{|static|
					statics[static.name] = static
					names << static.name
				}
				res = Array::new
				names = names.uniq.sort
				res << plugin_form({'admin_sel'=>'static','admin_mode'=>'alt'}) {|recv|
					recv << radio('admin_gen_mod', 'all', true, LBL['STA_ALL'])
					recv << radio('admin_gen_mod', 'link', false, LBL['STA_LNK'])
					recv << radio('admin_gen_mod', 'sel', false, LBL['STA_SEL'])
					recv << CGI::element('hr')
					recv << radio('admin_upd_mod', 'update', true, LBL['UPD_PAG'])
					recv << radio('admin_upd_mod', 'exist', false, LBL['EXS_STA'])
					recv << radio('admin_upd_mod', 'delete', false, LBL['DEL_ALL'])
					recv << CGI::element('hr')
					recv << checkbox('admin_gen_idx', 'on', @sys.statics.index?)+LBL['GEN_IDX']
					recv << checkbox('admin_cpy_img', 'on', @sys.statics.image?)+LBL['CPY_IMG']
					recv << checkbox('admin_cpy_thm', 'on', @sys.statics.theme?)+LBL['CPY_THM']
					recv << CGI::element('hr')
					recv << checkbox('admin_sta_cmd', 'on', false)+LBL['STA_CMD']
					recv << submit('exec', LBL['GEN_STA'])
					recv << CGI::element('hr')
					tbl = [[
						LBL['SEL_STA'],
						LBL['PAG_NAM'],
						LBL['MAK_UNI'],
						LBL['PAG_EXT'],
						LBL['STA_EXT'],
						LBL['FIL_TIM']
					]]
					names.each{|name|
						tbl << arr = Array::new
						ename = CGI::escapePATH(name)
						ftms = File::mtime(statics[name].path).tms if statics[name] and File::exist?(statics[name].path)
						arr << checkbox("admin_page_#{ename}", 'on', statics.key?(name))
						arr << @sys.wri_onview(name)
						uri = @sys.pages[name].uri({'o'=>'on'})
						arr << CGI::element('a', {'href'=>uri}, LBL['MAK_STA'])
						arr << (pages[name] ? 'yes' : 'no')
						arr << (statics[name] ? 'yes' : 'no')
						arr << ftms
					}
					recv << [tbl]
					recv << submit('exec', LBL['GEN_STA'])
				}
			end
			#==============================================
			# Delete Page
			#==============================================
			def onpost_delpage(sel)
				getpages.each{|page|
					@sys.cvs.removeFile(@sys.pages[page].path)
				}
				msg(MSG['DEL_PAG'])
			end
			def onview_delpage
				plugin_form({'admin_sel'=>'delpage','admin_mode'=>'del'}) {|recv|
					@sys.pages.names.each{|name|
						fldname = CGI::escapeURI("admin_page_#{name}",'')
						recv << checkbox(fldname, 'on', false, "#{@sys.wri_onview(name)}(#{CGI::escapeHTML(name)})", true)
					}
					recv << [submit('exec', LBL['DEL_PAG'])]
				}
			end
			#==============================================
			# Farm
			#==============================================
			def onpost_farm(sel)
				name = @sys.cgi.params['admin_farm'][0]
				raise ERR['NON_SIT'] if name.nil?
				begin
					File::rm_rf(@sys.farms.path(name))
				rescue
					Log.rescue(__FILE__, __LINE__, $!.to_s, $@.to_a.join("\n")) if @sys['DEBUG']
				end
				@sys.farms.delete(name)
				@sys.farms.datas.keys.each{|key|
					@sys.farms.delete(key) unless File::exist?(@sys.farms.path(key))
				}
				@sys.farms.update
			end
			def onview_farm
				plugin_form({'admin_sel'=>'farm','admin_mode'=>'del'}) {|recv|
					@sys.farms.each_path{|path|
						next unless File::directory?(path)
						name = File::basename(path)
						recv << radio('admin_farm', name, false, name)
					}
					recv << submit('exec', HED['DEL_FAM'])
				}
			end
			#==============================================
			# Edit Parameter
			#==============================================
			def onpost_param(mode)
				desc, data = edit_read_desc
				set = Hash::new
				@sys.cgi.params.each do |name, value|
					if /^[A-Z_]+$/ === name then
						set[name] = edit_restore_value(data[name][0], data[name][1], value)
					end
				end
				@sys.config(set)
				raise VikiWiki::Location, uri4get({'admin_sel'=>'param', 'h'=>nil})
			end
			def onview_param
				desc, data = edit_read_desc
				plugin_form({'admin_sel'=>'param', 'h'=>nil}) {|recv|
					recv << MSG['EDT_CGI']
					recv << Parser::trans_html(@sys, desc, 'VikiWikiStyle')
					recv << submit('exec', LBL['EDT_PRM'])
				}
			end
			#==============================================
			# Edit CGI
			#==============================================
			def onpost_edit(mode)
				File::fwrite(@sys.local_file, @sys.cgi.params['admin_edit_cgi'][0])
				raise VikiWiki::Location, uri4get({'admin_sel'=>'edit', 'h'=>nil})
			end
			def onview_edit
				text = File::readlines(@sys.local_file).join
				plugin_form({'admin_sel'=>'edit', 'h'=>nil}) {|recv|
					recv << MSG['EDT_CGI']
					recv << textarea('admin_edit_cgi', text, 80, 40)
					recv << submit('exec', LBL['EDT_CGI'])
				}
			end
		private
			def getpages
				pages = Array::new
				@sys.cgi.params.each{|k, v|
					next unless /^admin_page_/ === k
					n = CGI::unescapeURI($')
					pages << n if v[0] == 'on'
				}
				return pages
			end
			def generate_static(pages=nil)
				unless pages then
					pages = Array::new
					pages << 'index'
					@sys.each_page_file{|file, page| pages << page}
				end
				errs = Array::new
				@sys.push
				begin
					@sys.static = true
					File::mkpath(@sys['STATICDIR'])
					pages.each{|page|
						if page == 'index' then
							uri = CGI::escapeURI(CGI::escapeURI(@sys['TOPPAGE'])) + ".html"
							fnam = "#{@sys['STATICDIR']}/index.html".untaint
							File::open(fnam, "w"){|f|
								f.print @sys.location(uri, false)
							}
						else
							@sys.page = page
							begin
								@sys.write_static(page)
							rescue StandardError, ScriptError
								errs << page
							end
						end
					}
				ensure
					@sys.pop
				end
				raise ERR['GEN_STA'].emb(errs.join(',')) unless errs.empty?
			end
			def delete_static(pages)
				pages.each{|page|
					File::unlink("#{@sys['STATICDIR']}/#{CGI::escapePATH(page)}.html".untaint)
				}
			end
			def edit_restore_value(form, type, value)
				value.map! do |val|
					case val
					when 'nil','',/^\s+$/ then nil
					when 'true' then true
					when 'false' then false
					else
						case type
						when '(number)' then
							val.to_i
						else
							val
						end
					end
				end
				case form
				when 'text' then
				when 'checkbox' then
					return value if value.size > 1
				when 'radio' then
				when 'select' then
					return value[0].to_i if /^\-?\d+$/ === value[0]
				when 'textarea' then
				when 'multi' then
					return (value[0] || "").split(/\n/)
				end
				return value[0]
			end
			def edit_split_type(type)
				type.split(',').map do |str|
					val = str = str.strip
					case str
					when 'true'  then val = true
					when 'false' then val = false
					when 'nil'   then val = nil
					end
					yield str, val
				end
			end
			def edit_field(name, form, type)
				res = ['<div>']
				case form
				when 'text' then
					res << %Q[<input name="#{name}" type="text" size="40" value="#{@sys[name]}" />]
				when 'checkbox' then
					edit_split_type(type) do |str, val|
						check = 'checked="checked"' if @sys[name].include?(val)
						res << %Q[<input name="#{name}" type="checkbox" value="#{val}" #{check} />#{str}]
					end
				when 'radio' then
					edit_split_type(type) do |str, val|
						case str
						when '(number)' then
							val = Numeric === @sys[name] ? @sys[name] : nil
							label = %Q[<input name="#{name}" type="text" size="40" value="#{val}" />]
						when '(any)','(uri)','(path)' then
							val = String === @sys[name] ? @sys[name] : nil
							label = %Q[<input name="#{name}" type="text" size="40" value="#{val}" />]
						else
							label = nil
						end
						check = @sys[name] == val ? 'checked="checked"' : nil
						res << %Q[<input name="#{name}" type="radio" value="#{str}" #{check} />#{str}#{label}]
					end
				when 'select' then
					res << %Q[<select name="#{name}">]
					edit_split_type(type) do |str, val|
						select = @sys[name].to_s == val.to_s ? 'selected="selected"' : ''
						res << %Q[<option value="#{str}" #{select} />#{str}</option>]
					end
					res << %Q[</select>]
				when 'textarea' then
					res << %Q[<textarea name="#{name}" cols="40" rows="5">]
					res << @sys[name]
					res << %Q[</textarea>]
				when 'multi' then
					res << %Q[<textarea name="#{name}" cols="40" rows="5">]
					res << @sys[name].join("\n") if @sys[name]
					res << %Q[</textarea>]
				end
				res << '<hr /></div>'
				return res.join("\n")
			end
			def edit_read_desc
				desc = ''
				data = Hash::new
				name = nil
				form = nil
				type = nil
				flag = false
				File::foreach("#{$VIKIWIKIDIR}/../parameter.txt") do |line|
					if line.include?('//==Settings') then
						break if flag
						flag = true
						next
					end
					next unless flag
					if /^(\s+)\|\|\'\'(\S+)\'\'\s+\|\|(.+)$/ === line then
						case $2
						when 'name' then name = $3
						when 'form' then form = $3
						when 'type' then type = $3
							desc << "#{$1}#html "
							desc << edit_field(name, form, type).dump
							desc << "\n"
							data[name] = [form, type]
						end
						next
					end
					desc << line
				end
				return desc, data
			end
		end
	end
end
