=begin

USE (= Utf-8, Shift_JIS, Euc-JP) Conversion Module
Just calling Uconv module and NKF module.

=end

module USEconv
	KCODE2ENCODE = {
		'u'=>'utf-8',
		's'=>'Shift_JIS',
		'e'=>'euc-jp'
	}
	KCODE2ENCODE.default = 'utf-8'
	# kcode => encoding
	def USEconv::encoding(kcode); KCODE2ENCODE[USEconv::kcode(kcode)]; end
	# encoding => kcode
	def USEconv::kcode(encoding); (encoding || $KCODE)[0].chr.downcase; end
	# encoding => kcode
	def USEconv::eql?(c,d)
		USEconv::kcode(c) == USEconv::kcode(d) ? true : false
	end
	# conversion method
	def USEconv::cnvmethod(from, to)
		return nil if from.nil? or to.nil?
		from = USEconv::kcode(from)
		to = USEconv::kcode(to)
		method_name = "#{from}2#{to}"
		return nil unless self.respond_to?(method_name)
		return self.method(method_name.intern)
	end
	begin
		require 'nkf'
		def USEconv::s2e(str); NKF::nkf('-Se', str); end
		def USEconv::e2s(str); NKF::nkf('-Es', str); end
	rescue ScriptError
	end
	begin
		require 'uconv'
		def USEconv::s2u(str); Uconv::sjistou8(str); end
		def USEconv::e2u(str); Uconv::euctou8(str) ; end
		def USEconv::u2s(str); Uconv::u8tosjis(str); end
		def USEconv::u2e(str); Uconv::u8toeuc(str) ; end
=begin
		UNKNOWN_CHAR = '_'[0]
		def Uconv.unknown_unicode_handler(c); UNKNOWN_CHAR; end
		def Uconv.unknown_euc_handler(c); UNKNOWN_CHAR; end
		def Uconv.unknown_sjis_handler(c); UNKNOWN_CHAR; end
		Uconv::replace_invalid = UNKNOWN_CHAR
=end
	rescue ScriptError
	end

	def USEconv::exec(argv)
		begin
			from = nil
			to = nil
			files = Array::new
			ARGV.each{|v|
				if /^\-/ === v then
					$'.scan(/./){|x|
						if /[A-Z]/ === x then
							from = x.downcase
						else
							to = x
						end
					}
				elsif /[\*\?]/ === v then
					files += Dir::glob(v)
				else
					files << v
				end
			}
			raise "Parameters not specified." if from.nil? or to.nil?
			cnv = USEconv::cnvmethod(from, to)
			raise "It is the combination which is not convertible. #{from} => #{to}" if cnv.nil?
			raise "Any file does not exist." if files.empty?
			files.each{|file|
				next if FileTest::directory?(file)
				puts file
				begin
					str = cnv.call(File::readlines(file).join)
					tms = File::mtime(file)
					File::rename(file, file+".bak")
					begin
						File::open(file, "w"){|f|
							f.write(str)
						}
					rescue
						File::rename(file+".bak", file)
					end
					File::utime(tms, tms, file)
					File::unlink(file+".bak")
				rescue
					puts $!
					puts $@
				end
			}
		rescue
			prms = USEconv::public_methods.map{|name|
			    next unless /^([a-z])2([a-z])$/ === name
			    "-#{$1.upcase}#{$2.downcase}"
			}.compact.sort
			puts $!
			puts "Usage: ruby #{$0} {#{prms.join('|')}} files ..."
		end
	end
end

USEconv::exec(ARGV) if __FILE__ == $0
