module Grep
	def Grep::grep(keyword, dir, files, cmd)
		if cmd then
			Grep::grepcmd(keyword, dir, files, cmd){|file, num, line|
				yield file, num, line
			}
		else
			keyword = /^\/(.+)\?$/ === keyword ? Regexp::new($1) : keyword.split
			Grep::grepmod(keyword, dir, files){|file, num, line|
				yield file, num, line
			}
		end
	end
	def Grep::grepcmd(keyword, dir, files, cmd)
		cmd = cmd % [keyword, "#{dir}/**/#{files}"]
		cmd.gsub!(/\//,'\\') if /^[A-Za-z]:\\/ === ENV['WINDIR']
		grl = `#{cmd.untaint}`
		grl.each{|line|
			next unless /^([^:]+):(\d+):/ === line
			yield $1.untaint, $2.to_i, $'.chomp
		}
		return res
	end
	def Grep::grepmod(keyword, dir, files)
		res = Array::new
		Dir::glob("#{dir}/**/#{files}"){|path|
			next if path.include?("/.")
			i = 1
			File::open(path.untaint) do |f|
				f.each_with_index do |l, i|
					yield path, i+1, l.chomp if Grep::match(l, keyword)
				end
			end
		}
		return res
	end
	def Grep::match(str, keywords)
		keywords.each{|k|
			return false unless str.include?(k)
		}
		return true
	end
end
