require 'tdiary'
module TDiary
	class TDiaryBase
		def eval_rhtml_body( prefix = '' )
			begin
				r = do_eval_rhtml_body( prefix )
			rescue PluginError, SyntaxError, ArgumentError
				r = ERbLight::new( File::open( "#{PATH}/skel/plugin_error.rhtml" ) {|f| f.read }.untaint ).result( binding )
			rescue Exception
				raise
			end
			return r
		end
	protected
		def do_eval_rhtml_body( prefix )
			# load plugin files
			@plugin = load_plugins

			# load and apply rhtmls
			path = "#{PATH}/skel/#{prefix}#{@rhtml}"
			begin
				if @conf.lang then
					rhtml = File::open( "#{path}.#{@conf.lang}" ) {|f| f.read }
				else
					rhtml = File::open( path ) {|f| f.read }
				end
			rescue
				rhtml = File::open( path ) {|f| f.read }
			end
			r = ERbLight::new( rhtml.untaint ).result( binding )
			r = ERbLight::new( r ).src

			# apply plugins
			r = @plugin.eval_src( r.untaint, @conf.secure ) if @plugin
			@cookies += @plugin.cookies
			r
		end
	end
	class TDiaryUnit < TDiaryView
		def initialize( cgi, rhtm, confl )
			super
			t = Time::now
			year = t.year
			month = t.month
			1.upto(3) do
				@date = Time::local(year, month)
				@io.transaction( @date ) do |diaries|
					@diaries = diaries
					@diary = @diaries[@diaries.keys.sort.reverse[0]]
					return if @diary
				end
				month -= 1
				year, month = year-1, 12 if month < 1
			end
			@date = nil
			@diaries = nil
			@diary = nil
			DIRTY_NONE
		end
	end
end
