require 'cgi'
require 'uniquefile'

class CGI
	# Convert multi-part data into String
	def easy!
		params.each{|k,v|
			v.to_a.map!{|a|
				next unless a
				if String === a then
					CGI::load_session(a) || a.gsub(/\r\n/, "\n")
				elsif a.respond_to?(:content_type) then
					if a.content_type.empty? then
						a.read.gsub(/\r\n/, "\n")
					else
						a
					end
				else
					a.to_s
				end
			}
		}
	end
	def convert!(cnv)
		return unless cnv
		params.each{|k, v|
			v.map!{|a|
				a = cnv.call(a) if String === a
				a
			}
		}
	end
	def CGI::save_session(value)
		local_path = UniqueFie::tmpnam('CGI')
		File::open(local_path, "wb") do |f|
			f.write(value.read)
		end
		"__SESSION__%08x,%s,%s,%s" % [$$, local_path, value.original_filename, value.content_type, value.content_type]
	end
	def CGI::load_session(value)
		return nil unless /^__SESSION__[0-9a-fA-F]{8},/ === value
		local_path, original_filename, content_type = $'.split(',')
		require 'tempfile'
		body = Tempfile.new("CGI")
		body.binmode
		File::open(local_path, "rb") do |f|
			body.write f.read
		end
		UniqueFie::clean('CGI', 900)
		eval("def body.local_path; #{body.path.dump}; end")
		eval("def body.original_filename; #{original_filename.dump}; end")
		eval("def body.content_type; #{content_type.dump}; end")
		body.rewind
		return body
	end

	EMP_TAG = ['base','br','col','hr','img','input','link','meta','param']
	PRE_TAG = ['pre', 'textarea']
	def CGI::bgntag(type, attr={}, mode=:HTML)
		return '' unless type
		out = ''
		out << "<#{type}"
		attr.each{|k,v|
			next if k[0].chr == '*'
			next unless v
			out << " #{k}=\"#{CGI::escapeHTML(v.to_s)}\""
		} if attr
		if mode == :XML then
			out << '>'
		elsif mode == :EMPTY then
			out << ' />'
		else
			out << (EMP_TAG.include?(type) ? " />" : ">")
		end
		return out
	end
	def CGI::endtag(type, mode=:HTML)
		return '' unless type
		return "</#{type}>" if mode == :XML
		return EMP_TAG.include?(type) ? "" : "</#{type}>"
	end
	def CGI::element(type, attr={}, text=nil, escaped=false, mode=:HTML)
		return CGI::bgntag(type, attr, :EMPTY) if mode == :XML and text.nil?
		type = nil if type and type.empty?
		attr = {} unless attr
		text = nil if text and text.empty?
		text = CGI::escapeHTML(text) if text and not escaped
		recv = Array::new
		block = yield recv if iterator?
		block = recv unless recv.empty?
		block = nil if block and block.empty?
		text = [text, block].flatten.compact.join("\n")
		text = text.sub(/\n+\z/,'').chomp unless PRE_TAG.include?(type)
		res = ''
		res = CGI::bgntag(type, attr, mode)
		if text and not text.empty? then
			res << "\n" if /\A</ === text or PRE_TAG.include?(type)
			res << text
			res << "\n" if />\z/ === text or PRE_TAG.include?(type)
		end
		res << CGI::endtag(type, mode)
		return res
	end
	URI_EXCEPT  = " \"%'()*-.<>[\\]^`{|}"
	URI_RESERVE = "$&+,/.:;=-?@#"
	def CGI::escapeURI(uri, nochange=URI_RESERVE)
		uri.gsub(/./){
			word = $&
			if nochange.include?(word) then
				word
			elsif
				URI_RESERVE.include?(word) or
				URI_EXCEPT.include?(word) or
				word[0] < 0x20 or
				word[0] > 0x7f
			then
				'%' + word.unpack('H2' * word.size).join('%').upcase
			else
				word
			end
		}
	end
	def CGI::unescapeURI(uri)
		CGI::unescape(uri)
	end
	def CGI::escapePATH(uri)
		CGI::escapeURI(uri, '/.\\-:')
	end
	def CGI::unescapePATH(uri)
		CGI::unescape(uri)
	end
end
