=begin
	Minimum ERB class
	<%...%>  : any process
	<%#...%> : comment
	<%=...%> : string
=end

unless defined?(ERB) then

class ERB
	attr_accessor :filename, :src
	def initialize(str, safe_level=nil, trim_mode=nil, eoutvar='_erbout')
		@filename = nil
		@src = eoutvar + " = ''\n"
		while /<%([=#]?)(.+?)%>([ \t]*\n?)/m === str do
			pre, mark, exp, lf, str = $`, $1, $2, $3, $'
			if pre then
				pre.each do |preline|
					@src << "#{eoutvar} << #{preline.dump}\n"
				end
			end
			case mark
			when '=' then
				@src << "#{eoutvar}_tmp = #{exp.strip}\n"
				@src << "if #{eoutvar}_tmp then\n"
				@src << "#{eoutvar} << #{eoutvar}_tmp\n"
				@src << "#{eoutvar} << #{lf.dump}\n" if lf == "\n"
				@src << "end\n"
			when '#' then
			else
				@src << exp+';'
			end
		end
		if str then
			str.each do |strline|
				@src << "#{eoutvar} << #{strline.dump}\n"
			end
		end
		@src << "\n"
		@src << eoutvar
		@src << "\n"
		@src.untaint
	end
	def result(bind=TOPLEVEL_BINDING)
		return eval(@src, bind, @filename || '(erb-mini)')
	end
end

end
