=begin

	sample for Wiki parser

	If you execute the following command,
	Three files 'xxx.wiki', 'xxx.xml' and 'xxx.html' are generated.

	% ruby -Ku tool/wiki-dom.rb file

=end

$: << '../vikiwiki'
$: << '../vikiwiki/lib'
require 'dom-mini'
require 'wiki/vikiwikistyle'
require 'generator/xml'
require 'generator/html'

base = File::basename(ARGV[0], ".*")

# Create DOM object
doc = Document::new(DOMImplementation::instance)
root = doc.createElement('wiki')	# The root node is 'wiki'
doc.appendChild(root)

# Parser and Generator
style = Wiki::VikiWikiStyle::new
xmlgen = Generator::Xml::new
htmlgen = Generator::Html::new

# Read Wiki text
wiki = File::readlines(ARGV[0]).join

# Parse Wiki text to DOM object
style.parse(root, wiki)

# Output Wiki document
File::open(base+'.wiki', "w") do |f|
	style.generate(doc, f)
end

# Output XML document
File::open(base+'.xml', "w") do |f|
	xmlgen.generate(doc, f)
	f.puts
end

# Output HTML document
File::open(base+'.html', "w") do |f|
	f.puts <<HEADER
<html>
<head><title>Wiki Test</title></head>
<body>
HEADER

	htmlgen.generate(root.childNodes, f)
	f.puts

	f.puts <<FOOTER
</body>
</html>
FOOTER
end
