=begin

ruby -Ku chgdiffcvs.rb <dir> <ext>
<dir> : directory
<ext> : extension

=end

dir = ARGV[0] || '.'
ext = ARGV[1] || 'txt'
Dir::glob(dir+'/**/*') do |file|
	next if File::directory?(file)
	reg = /\.([A-Za-z]+Style)\.(\w+)\.#{ext}/
	alt = /\/\.(cvs|dst)\// === file ? ".\\1.#{ext}.\\2" : ".\\1.#{ext}"
	to_file = file.sub(reg, alt)
	next if file == to_file
	File::rename(file, to_file)
	printf "Change %s => %s\n", file, to_file
end
