#!/usr/bin/env ruby
$KCODE_bak = $KCODE

eval(DATA.read.untaint)

require 'getopts'
getopts(nil, "lang:ja")

@labels = LABELS[$OPT_lang]

DEFAULT_CONF = Hash::new
DEFAULT_CONF['$VIKIWIKIRUBY'] = /^\#\!(.*\bruby\b.*)$/i.match(File::readlines(__FILE__).join)[1]
DEFAULT_CONF['TOPPAGE'] = 'FrontPage'

module WizardCGI

	def init_conf
		require 'cgi'
		@cgi = CGI::new
		@cgi.params.each do |name, val|
			if /^__(.+)__$/ === name then
				@conf[$1] = val[0] unless @cgi.params.key?($1)
			else
				@conf[name] = val[0]
			end
		end
	end

	def escapeHTML(str)
		CGI::escapeHTML(str).gsub(
			/(http:\/\/\S+)/,
			"<a href=\"\\1\">\\1</a>"
		)
	end

	def html_print(str)
		print str+"\n"
	end

	def html_puts(str)
		str.each do |line|
			html_print(line.chomp+"<br />")
		end
	end

	def input_text(name, size, dft=nil)
		dft = @conf[name] unless dft
		str = @labels[name] || name
		html_print "<p>"
		html_puts escapeHTML(str)
		html_print %Q[：<input type="text" name="#{name}" size="#{size}" value="#{dft}" />]
		html_print "</p>"
	end

	def input_password(name, size=40)
		str = @labels[name] || name
		html_print "<p>"
		html_puts escapeHTML(str)
		html_print %Q[：<input type="password" name="#{name}" size="#{size}" />]
		html_print "</p>"
	end

	def input_select(name)
		dft = @conf[name]
		str = @labels[name] || name
		html_print "<p>"
		html_puts escapeHTML(str)
		html_print %Q[<select name="#{name}">]
		@labels["#{name} OPTION"].each do |val, disp|
			selected = val == dft ? 'selected="selected"' : ''
			html_print %Q[<option value="#{val}"#{selected}>#{disp}</option>]
		end
		html_print "</select>"
		html_print "</p>"
	end

	def print_header
		charset = case $KCODE
		when /^s/i then 'Shift_JIS'
		when /^e/i then 'euc-jp'
		else 'utf-8'
		end
		print <<EOS
Content-Type: text/html;

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=#{charset}" />
<title>#{@labels['TITLE']}</title>
</head>
<body>
<h1>#{@labels['TITLE']}</h1>
EOS
	end

	def print_body
		if @conf['action'] == @labels['WIZARD_BACK'] then
			@conf['func'] = step_func(@conf['func'], -1)
		else
			@conf['func'] = step_func(@conf['func'], +1)
		end
		if @conf['func'] == 'setup' then
			begin
				conf_bak = @conf.dup
				setup_vikiwiki
				html_print %Q[<p><a href="#{@conf['SCRIPT_NAME']}">#{@conf['SITENAME']}</a></p>]
				return
			rescue Exception
				error_puts($!)
				@conf = conf_bak
			end
		end
		print_form
	end

	def print_footer
		print <<EOS
</body>
</html>
EOS
	end

	def print_form
		html_print %[<div class="form">]
		html_print %[<form method="post" action="#{@cgi.script_name}">]
		func = @conf['func']
		prev_func = step_func(func, -1)
		next_func = step_func(func, +1)
		label = @labels["DESC_#{func.upcase}"]
		print_p(label) if label
		method("print_wiki_#{func}").call if respond_to?("print_wiki_#{func}", true)
		@conf.each do |name, val|
			next if ['passwd1','passwd2'].include?(name)
			html_print %[<input type="hidden" name="__#{name}__" value="#{val}" />]
		end
		html_print %[<input type="submit" name="action" value="#{@labels['WIZARD_FINISH']}" />] if next_func == 'setup'
		html_print %[<input type="submit" name="action" value="#{@labels['WIZARD_NEXT']}" />] if next_func and next_func != 'setup'
		html_print %[<input type="submit" name="action" value="#{@labels['WIZARD_BACK']}" />] if prev_func
		html_print %[</form>]
		html_print %[</div>]
	end

	def print_p(str)
		html_print %[<p>#{escapeHTML(str)}</p>]
	end

	def print_data(prm)
		val = @conf[prm]
		label = @labels[prm].to_a.first.chomp
		html_print "<p>"
		if @labels[prm+' OPTION'] then
			opt = @labels[prm+' OPTION'].assoc(val)
			html_print escapeHTML("#{label}：#{opt[0]}(#{opt[1]})")
		else
			html_print escapeHTML("#{label} ： #{val}")
		end
		html_print "</p>\n"
	end

	def conv_print(str)
		html_print escapeHTML(str)
	end

	def conv_puts(str='')
		return unless str
		str.each do |line|
			html_puts escapeHTML(line.chomp)
		end
	end

	def error_puts(err)
		html_print "<p> #{err.to_s} </p>"
		html_print "<!-- "+err.backtrace.join("\n")+" -->"
	end

end

module WizardCommand
	def init_conf
		if ENV['windir'] and ENV['windir'].include?("\\") then
			$KCODE = 's'
		elsif ENV['LANG'] then
			case ENV['LANG']
			when /SJIS|PCK/i then
				$KCODE = 's'
			when /UTF/i then
				$KCODE = 'u'
			else
				$KCODE = 'e'
			end
		end
		if $OPT_lang == 'ja' and not /^u/i === $KCODE then
			begin
				require 'uconv'
				if /^s/i === $KCODE then
					@conv_in  = Uconv::method(:sjistou8)
					@conv_out = Uconv::method(:u8tosjis)
				else
					@conv_in  = Uconv::method(:euctou8)
					@conv_out = Uconv::method(:u8toeuc)
				end
			rescue LoadError
				raise "Get the uconv module. #{$!}"
			end
		end
	end

	def conv_input(input=$stdin)
		str = input.gets.chomp
		@conv_in ? @conv_in.call(str) : str
	end

	def conv_print(str, output=$stdout)
		output.print @conv_out ? @conv_out.call(str) : str
	end

	def conv_puts(str='')
		conv_print(str+"\n") if str
	end

	def print_label(name)
		str = @labels[name] || name
		desc = str.to_a
		label = desc.shift.chomp
		conv_puts "\n【#{label}】"
		conv_print desc.join unless desc.empty?
		conv_print "\n" if str.include?("\n")
	end

	def input_text(name, size, dft=nil)
		dft = @conf[name] unless dft
		print_label(name)
		conv_print " (now %s) > " % (dft || '""')
		res = conv_input
		@conf[name] = res unless res.empty?
	end

	def input_password(name, size=40)
		input_text(name, size)
	end

	def input_select(name)
		dft = @conf[name]
		print_label(name)
		now = 1
		@labels["#{name} OPTION"].each_with_index do |opt, cnt|
			now = cnt+1 if opt[0] == dft
			conv_puts "%2d. %s = %s" % [cnt+1, opt[0], opt[1]]
		end
		conv_print " (now %s) > " % (now || '""')
		res = conv_input
		if /^\d+$/ === res then
			@conf[name] = @labels["#{name} OPTION"][res.to_i-1][0]
		elsif res.empty? then
			@conf[name] = @labels["#{name} OPTION"][now-1][0]
		else
			@conf[name] = res
		end
	end

	def print_header
		conv_puts @labels['TITLE']
	end

	def print_body
		loop do
			while (func = step_func(func, +1)) != 'setup' do
				method("print_wiki_#{func}").call
			end
			sure = 'n'
			conv_print "#{@labels['MSG_SURE']} (y/n)"
			sure = conv_input
			break if sure[0].chr == 'y'
		end
		setup_vikiwiki
	end

	def print_footer
	end

	def print_p(str)
		conv_puts str
	end

	def print_data(prm, label=false)
		print_label(prm)
		val = @conf[prm]
		val = @labels[prm+' OPTION'][val] if label
		conv_puts "*** => #{val}"
	end

	def error_puts(err)
		conv_puts err.to_s
		conv_puts err.backtrace.join("\n")
	end

end

def print_wiki_env
	begin
		require 'uconv'
		raise LoadError unless defined?(:Uconv)
	rescue LoadError
		conv_puts @labels['MSG_UCONV']
	end
	@conf['cgi_dir'] = Dir::pwd unless @conf['cgi_dir']
	@conf['cgi_uri'] = File::dirname(@cgi.script_name) if @cgi and not @conf['cgi_uri']
	if @conf['cgi_uri'] then
		while File::basename(@conf['cgi_dir']) == File::basename(@conf['cgi_uri']) do
			break if @conf['cgi_dir'].split('/').size < 3
			@conf['cgi_dir'] = File::dirname(@conf['cgi_dir'])
			@conf['cgi_uri'] = File::dirname(@conf['cgi_uri'])
		end
	end
	input_text('AUTHOR', 40)
	input_text('ADMIN', 40)
	input_text('ADDRESS', 40)
	input_text('cgi_dir', 40)
	input_text('cgi_uri', 40)
	input_text('SITENAME', 40)
	input_text('folder', 40)
end

def print_wiki_common
	unless @conf['$VIKIWIKIBASE'] then
		dir = ENV['HOME'] unless /mswin32/ === RUBY_PLATFORM
		dir = File::dirname(Dir::pwd) unless dir
		base = Dir::glob("#{dir}/vikiwiki*").first
		base = Dir::glob("vikiwiki*.zip").first || Dir::glob("vikiwiki*.tar.gz").first unless base
		raise "#{@labels['ERR_VIKIWIKI_NOT_FOUND']}" unless base
		base = File::basename(base, ".*")
		@conf['$VIKIWIKIBASE'] = "#{dir}/#{base}"
	end
	ext = /\.([^\.]+)$/ === __FILE__ ? $1 : 'cgi'
	@conf['$VIKIWIKITMP'] = @conf['$VIKIWIKIBASE'] + '/tmp' unless @conf['$VIKIWIKITMP']
	@conf['local_file'] = "#{@conf['cgi_dir']}/#{@conf['folder']}/vikiwiki.#{ext}" unless @conf['local_file']
	cgi_uri = @conf['cgi_uri'] == "/" ? "" : @conf['cgi_uri']
	@conf['SCRIPT_NAME'] = "#{cgi_uri}/#{@conf['folder']}/vikiwiki.#{ext}" unless @conf['SCRIPT_NAME']
	@conf['THEMECSS'] = File::basename(Dir::glob("*.tar.gz").first || 'vikiway', ".tar.gz") unless @conf['THEMECSS']
	input_text('SCRIPT_NAME', 80)
	input_text('local_file', 80)
	input_text('TOPPAGE', 40)
	input_text('$VIKIWIKIRUBY', 80)
	input_text('$VIKIWIKIBASE', 80)
	input_text('$VIKIWIKITMP', 80)
	input_select('use_for')
	input_select("AUTHTYPE")
	input_text('THEMECSS', 40)
	input_select("THEMEBASE")
end

def print_wiki_static
	@conf['STATICDIR'] = File::dirname(@conf['local_file']) + '/static' unless @conf['STATICDIR']
	@conf['STATICURI'] = File::dirname(@conf['SCRIPT_NAME']) + '/static' unless @conf['STATICURI']
	input_text('STATICDIR', 40)
	input_text('STATICURI', 40)
end

def print_wiki_directedit
	input_text('remote_file_path', 80)
	input_text('FILEEXT', 40)
end

def print_wiki_check
	print_data('$VIKIWIKIRUBY')
	print_data('$VIKIWIKIBASE')
	print_data('$VIKIWIKITMP')
	print_data('AUTHOR')
	print_data('ADMIN')
	print_data('ADDRESS')
	print_data('use_for')
	print_data('AUTHTYPE')
	print_data('local_file')
	print_data('SCRIPT_NAME')
	print_data('TOPPAGE')
	print_data('THEMECSS')
	print_data('THEMEBASE')
	if @conf['use_for'] != 'Normal' then
		print_data('STATICDIR')
		print_data('STATICURI')
	end
	if @conf['use_for'] == 'DirectEdit' then
		print_data('REMOTEPATH')
		print_data('FILEEXT')
	end
	if @conf['AUTHTYPE'] != 'www' then
		input_password('passwd1', 40)
		input_password('passwd2', 40)
	end
end

FUNCS = <<EOS.split
env
common
static
directedit
check
setup
EOS

def step_func(cur=nil, step=+1)
	return FUNCS.first unless cur
	idx = FUNCS.index(cur)
	raise "#{@labels['ERR_INVALID_FUNCTION']} #{cur}" unless idx
	loop do
		idx += step
		return nil if idx < 0 or idx >= FUNCS.size
		case FUNCS[idx]
		when 'static' then
			next if @conf['use_for'] == 'Normal'
		when 'directedit' then
			next if @conf['use_for'] != 'DirectEdit'
		end
		break
	end
	return FUNCS[idx]
end

def setup_system(cmd)
	rubycmd = "#{$VIKIWIKIRUBY} -K#{$KCODE[0].chr.downcase} "
	rubycmd << "-d " if $DEBUG
	rubycmd << cmd.strip
	conv_puts rubycmd
	conv_puts `#{rubycmd}`
end

def setup_vikiwiki
	$KCODE = $KCODE_bak
	raise "#{@labels['ERR_MISMATCH_PASSWORD']}" if @conf['AUTHTYPE'] != 'www' and (@conf['passwd1'].to_s.empty? or @conf['passwd1'] != @conf['passwd2'])
	conf = Hash::new
	@conf.each do |key, val|
		next if val.to_s.empty?
		case key
		when /^\$/ then
			instance_eval("#{key}=#{val.inspect}")
		when /^\#/, /\s/, /^[a-z0-9_]+$/ then
			# NOP
		else
			conf[key] = val
		end
	end
	res = uncompress($VIKIWIKIBASE)
	conv_puts res if res
	local_file = @conf['local_file']
	renames = {
		'CmsLayoutPage' => nil,
		'CmsStaticLayout' => nil,
		'StaticWikiLayoutPage' => nil,
	}
	renames['FrontPage'] = conf['TOPPAGE'] if conf['TOPPAGE'] != 'FrontPage'

	conf['TITLE'] = "#{conf['SITENAME']} - page"

	case @conf['use_for']
	when 'CMS' then
		conf['STATICIMG']   = "sync"
		conf['STATICTHEME'] = "sync"
		conf['STATICTITLE'] = "alias"
		conf['STATICWIKI']  = nil
		renames['CmsLayoutPage'] = 'LayoutPage'
		renames['CmsStaticLayout'] = 'StaticLayout'
	when 'StaticWiki' then
		conf['STATICIMG']   = 'share'
		conf['STATICTHEME'] = 'share'
		conf['STATICTITLE'] = 'alias'
		conf['STATICWIKI']  = true
		renames['StaticWikiLayoutPage'] = 'LayoutPage'
	when 'DirectEdit' then
		conf['STATICIMG']   = 'share'
		conf['STATICTHEME'] = 'share'
		conf['STATICTITLE'] = 'alias'
		conf['STATICWIKI']  = true
		renames['StaticWikiLayoutPage'] = 'LayoutPage'
		local = File::dirname(local_file)
		remote = File::dirname(remote_file_path)
		reg = Regexp::new('^'+Regexp::escape(local), Regexp::IGNORECASE)
		conf['EDITFILE']    = {reg => remote}
		conf['FILEMODE']    = '660'
	end

	conf.delete_if{|k,v| v.to_s.empty?}

	raise "#{@labels['ERR_ALREADY_EXIST']} #{local_file}" if File::exist?(local_file)

	$VIKIWIKIDIR = $VIKIWIKIBASE + '/vikiwiki'
	$:.unshift($VIKIWIKIDIR)
	$:.unshift($VIKIWIKIDIR+'/lib')
	raise "#{@labels['ERR_VIKIWIKI_NOT_FOUND']} #{$VIKIWIKIBASE}" unless File::exist?($VIKIWIKIDIR)
	require 'vikiwikisys'
	ENV['REQUEST_METHOD'] = 'GET'
	sys = VikiWiki::Sys::new(local_file, conf)

	begin
		dir = File::dirname(local_file)
		dir_exist = File::exist?(dir)
		conv_puts "#{@labels['MSG_MAKING_FOLDER']} #{dir} ... "
		Dir::copy("#{$VIKIWIKIBASE}/master", dir)
		textdir = [dir, VikiWiki::TEXTNAM].path
		langdir = [textdir, sys['LANG']].path
		Dir::foreach(langdir){|sfile|
			next if /^\.+$/ === sfile
			tfile = sfile
			felms = sfile.split(/\./)
			if renames.value?(felms[0]) then
				File::unlink("#{langdir}/#{sfile}".untaint)
				next
			end
			if renames.key?(felms[0]) then
				if renames[felms[0]].nil? then
					File::unlink("#{langdir}/#{sfile}".untaint)
					next
				end
				felms[0] = renames[felms[0]]
			end
			felms.last.replace(sys['FILEEXT'])
			tfile = felms.join('.').untaint
			conv_puts '=> ' + tfile
			File::rename("#{langdir}/#{sfile}".untaint, "#{textdir}/#{tfile}".untaint)
		}
		Dir::unlink(langdir)
		unless conf['THEMECSS'].include?('/') then
			conv_puts uncompress([dir, VikiWiki::THEMENAM, conf['THEMECSS']].path)
		end
		conv_puts @labels['MSG_FINISH']

		if stadir = sys['STATICDIR'] then
			conv_print "#{@labels['MSG_MAKING_STATIC']} #{stadir} ... "
			File::mkpath(sys['STATICDIR'])
			dyn = [dir, VikiWiki::IMGNAM].path
			sta = [stadir, VikiWiki::IMGNAM].path
			Dir::copy(dyn, sta) if /^copy|sync$/ === sys['STATICIMG']
			dyn = [dir, VikiWiki::THEMENAM].path
			sta = [stadir, VikiWiki::THEMENAM].path
			Dir::copy(dyn, sta) if /^copy|sync$/ === sys['STATICTHEME']
			conv_puts @labels['MSG_FINISH']
		end

		conv_print "#{@labels['MSG_MAKING_SCRIPT']} #{local_file} ... "
		sys.config(conf)
		if @conf['passwd1'] then
			if defined?(CryptPassword) then
				sec = CryptPassword::new(sys['ETCDIR'])
			else
				sec = VikiWiki::Secure::new(sys['ETCDIR'])
			end
			sec.update(@conf['ADMIN'], nil, @conf['passwd1'])
		end
		conv_puts @labels['MSG_FINISH']

		unless File::exist?($VIKIWIKITMP) then
			conv_print "#{@labels['MSG_MAKING_TMPDIR']} #{$VIKIWIKITMP} ... "
			Dir::mkdir($VIKIWIKITMP)
			conv_puts @labels['MSG_FINISH']
		end

		case @conf['use_for']
		when 'StaticWiki', 'DirectEdit' then
			setup_system("#{$VIKIWIKIBASE}/tool/static.rb -qxd #{local_file} #{conf['SCRIPT_NAME']}")
		end

		# Change VikiWiki::CVS to DiffCVS.
		#setup_system("#{$VIKIWIKIBASE}/tool/chgdiffcvs.rb #{sys['TEXTDIR']} #{sys['FILEEXT']}")

		conv_puts "#{@labels['MSG_ALL_FINISH']} #{local_file}"

	rescue Exception
		error_puts($!)
		begin
			conv_print "#{@labels['MSG_UNDO_FOLDER']} #{dir} ..."
			raise "directory already exist" if dir_exist
			File::rm_rf(dir)
			conv_puts @labels['MSG_FINISH']
		rescue Exception
			conv_puts @labels['ERR_FAIL_UNDO']
			error_puts($!)
		end
		raise @labels['MSG_FAIL_SETUP']
	end
end

def uncompress(dir)
	res = Array::new
	return nil if File::exist?(dir)
	name = File::basename(dir)
	unless File::exist?(name) then
		{
			'zip' => 'unzip %s',
			'tar.gz' => 'bash -c "gzip -dc cross.tar.gz | tar xvf -"',
		}.each do |ext, cmd|
			file = "#{name}.#{ext}"
			next unless File::exist?(file)
			exec = cmd % file
			res << exec
			res << `#{exec}`
		end
	end
	File::rename(name, dir) if File::exist?(name)
	return res.join("\n")
end

if ENV['REQUEST_METHOD'] then
	include WizardCGI
else
	include WizardCommand
end

@conf = DEFAULT_CONF.dup

init_conf

print_header
begin
	print_body
rescue Exception
	error_puts($!)
end
print_footer

__END__
LABELS = {
'en' => {
	"TITLE" => "VikiWiki Setup",
	"WIZARD_FINISH" => "Finish",
	"WIZARD_NEXT" => "Next",
	"WIZARD_BACK" => "Back",
	# Messages
	"MSG_FINISH_SETUP" => "Setup is finished.",
	"MSG_FAIL_SETUP" => "Setup is faild.",
	"MSG_FINISH" => "Finished.",
	"MSG_UNDO_FOLDER" => "Making the folder is canceled.",
	"MSG_ALL_FINISH" => <<EOS,

All process of setup is finished.
Edit the CGI script if you want to alter settings.
EOS
	"MSG_MAKING_FOLDER" => "Making the folder",
	"MSG_MAKING_STATIC" => "Making the directory for the static HTML",
	"MSG_MAKING_SCRIPT" => "Making the CGI script",
	"MSG_MAKING_TMPDIR" => "Making the work directory",
	"MSG_SURE" => "Are you sure?",
	"MSG_UCONV" => <<EOS,
Uconv module not found.
Uconv module is necessary if you need the code conversion.
Refer the URL http://www.yoshidam.net/Ruby_ja.html#uconv about Uconv module.
EOS
	# Error
	"ERR_ALREADY_EXIST" => "Making the file is faild because the file exists.",
	"ERR_FAIL_UNDO" => "Canceling is faild.\nRemove the folder before you try to setup again.",
	"ERR_INVALID_FUNCTION" => "The invalid function is specified.",
	"ERR_VIKIWIKI_NOT_FOUND" => "VikiWiki directory is not found. Check the directory specification or the binary file.",
	"ERR_MISMATCH_PASSWORD" => "Passwords are not matched.",
	# Configration Items
	"DESC_ENV" => "Input the information of the administrator and the server.",
	"AUTHOR" => "Administrator's name\nex) Hoge Hoge",
	"ADMIN" => "Administrator's login account\nex) hoge",
	"ADDRESS" => "Administrator's mail address\nKeep empty if you don't need to print your mail address on your web site.",
	"cgi_dir" => "Path for publishing your web site\nInput the CGI directory specified by your provider.\nex) /home/hoge/www, /home/hoge/public_html, /export/home2/hoge/html",
	"cgi_uri" => "URI corresponding the path for publishing\n多くの場合、/~名前 が割り当てられています。ドメイン取得した方は / となります。\n例）/~hoge, /",
	"SITENAME" => "サイトの名前\nWikiサイトの呼び名とも言うべきサイトの名前を入力します。\n例）ほげっちのお部屋",
	"folder" => "フォルダの名前\nCGIスクリプトのディレクトリ名に使用します。アルファベットと数字で入力してください。サイト全体を動的なWikiサイトにする方は何も入力しません。\n例）room, wiki, 何も入力しない",
	"DESC_COMMON" => "Wikiの共通設定です。",
	"SCRIPT_NAME" => "CGIスクリプトのURI",
	"local_file" => "CGIスクリプトの実際のパス",
	"TOPPAGE" => "トップページの名前\n他のWikiとのリンクを考えるとトップページにはWikiNameを使用した方がいいでしょう。\n例）FrontPage、TopPage、MyRoom、HogeHoge",
	"$VIKIWIKIRUBY" => "rubyのパス",
	"$VIKIWIKIBASE" => <<EOS,
VikiWikiプログラムの設置ディレクトリ
あらかじめVikiWikiのサイトからダウンロードしたバイナリ(vikiwiki.zip、vikiwiki2.zip)を#{Dir::pwd}に格納しておくことで指定したディレクトリに自動的に解凍します。
なお、VikiWiki2の場合はディレクトリ名にvikiwiki2を指定してください。
VikiWikiの場合の例） /home/hoge/vikiwiki
VikiWiki2の場合の例) /home/hoge/vikiwiki2
EOS
	"$VIKIWIKITMP" => "作業ディレクトリ",
	"use_for" => "Wikiの運用モード",
	"use_for OPTION" => [
		["Normal", "通常の動的なWikiの運用"],
		["CMS", "Wikiの仕組みを利用した静的HTMLでのサイト構築(CMS)"],
		["StaticWiki", "参照を静的HTMLにすることで負荷軽減をするWikiの運用"],
		["DirectEdit", "WindowsやSambaでの共有ディレクトリを利用してエディタで直接編集可能なWiki"],
	],
	"AUTHTYPE" => "認証方法",
	"AUTHTYPE OPTION" => [
		["form", "form認証"],
		["none", "認証なし"],
		["www", "www認証"],
		["vikiwiki", "VikiWiki Basic認証"],
	],
	"THEMECSS" => <<EOS,
テーマ名またはテーマへのURI
tDiaryのテーマを使用したい方は、テーマのバイナリをダウンロードし、
ここのディレクトリ(#{Dir::pwd})に格納してください。
tDiaryのテーマは http://www.tdiary.net/theme から入手することができます。
テーマ名.tar.gzファイルをそのまま格納してください。
ここには格納したテーマのテーマ名(tar.gzをつけない)を指定します。
EOS
	"THEMEBASE" => "サイドバー\nサイドバーのありなしと配置を選択します。テーマに含まれる場合はなしを選択してください。",
	"THEMEBASE OPTION" => [
		["", "サイドバーなし"],
		["sidebar-left", "左サイドバー"],
		["sidebar-right", "右サイドバー"],
	],
	"passwd1" => "管理者のパスワード",
	"passwd2" => "管理者のパスワード(確認用)",
	"DESC_STATIC" => "静的HTMLの設定です。",
	"STATICDIR" => "静的HTMLのディレクトリ",
	"STATICURI" => "静的HTMLのURI",
	"DESC_DIRECTEDIT" => "DirectEditの設定です。",
	"remote_file_path" => "クライアントから参照可能なfile:////でのCGIスクリプトのパス",
	"FILEEXT" => "保存するテイストファイルの拡張子",
	"DESC_CHECK" => "設定を確認してください。",
},
'ja' => {
	"TITLE" => "VikiWikiのセットアップ",
	"WIZARD_FINISH" => "完了",
	"WIZARD_NEXT" => "次へ",
	"WIZARD_BACK" => "戻る",
	# Messages
	"MSG_FINISH_SETUP" => "セットアップが完了しました。",
	"MSG_FAIL_SETUP" => "セットアップが失敗しました。",
	"MSG_FINISH" => "完了しました。",
	"MSG_UNDO_FOLDER" => "フォルダを回収します",
	"MSG_ALL_FINISH" => <<EOS,

すべてのセットアップが完了しました。"
設定を変更する場合はCGIスクリプトの内容を編集してください。
EOS
	"MSG_MAKING_FOLDER" => "フォルダの作成中",
	"MSG_MAKING_STATIC" => "静的HTMLディレクトリの作成中",
	"MSG_MAKING_SCRIPT" => "CGIスクリプトの作成中",
	"MSG_MAKING_TMPDIR" => "作業ディレクトリの作成中",
	"MSG_SURE" => "これでいいですか？",
	"MSG_UCONV" => <<EOS,
Uconvモジュールが見つかりませんでした。
Uconvモジュールは各種コード変換をするために必要です。
Uconvモジュールについては http://www.yoshidam.net/Ruby_ja.html#uconv を参照してください。
EOS
	# Error
	"ERR_ALREADY_EXIST" => "ファイルが存在するため作成できません。",
	"ERR_FAIL_UNDO" => "回収に失敗しました。\n再度セットアップする前にフォルダを削除してください。",
	"ERR_INVALID_FUNCTION" => "不正な機能が指定されました。",
	"ERR_VIKIWIKI_NOT_FOUND" => "VikiWikiのディレクトリが見つかりません。ディレクトリの指定が誤っているかバイナリが格納していないことが考えられます。",
	"ERR_MISMATCH_PASSWORD" => "パスワードが一致していません。",
	# Configration Items
	"DESC_ENV" => "管理者の情報や設置するサーバの情報を入力します。",
	"AUTHOR" => "管理者の名前\n例）ほげっち",
	"ADMIN" => "管理者のログインアカウント\n例）hoge",
	"ADDRESS" => "管理者のメールアドレス\nメールアドレスが不要な場合は入力しなくてもかまいません。",
	"cgi_dir" => "Web公開用のパス\nプロバイダから指定されたCGIの公開ディレクトリです。\n例）/home/hoge/www, /home/hoge/public_html, /export/home2/hoge/html",
	"cgi_uri" => "Web公開用のパスに対応するURI\n多くの場合、/~名前 が割り当てられています。ドメイン取得した方は / となります。\n例）/~hoge, /",
	"SITENAME" => "サイトの名前\nWikiサイトの呼び名とも言うべきサイトの名前を入力します。\n例）ほげっちのお部屋",
	"folder" => "フォルダの名前\nCGIスクリプトのディレクトリ名に使用します。アルファベットと数字で入力してください。サイト全体を動的なWikiサイトにする方は何も入力しません。\n例）room, wiki, 何も入力しない",
	"DESC_COMMON" => "Wikiの共通設定です。",
	"SCRIPT_NAME" => "CGIスクリプトのURI",
	"local_file" => "CGIスクリプトの実際のパス",
	"TOPPAGE" => "トップページの名前\n他のWikiとのリンクを考えるとトップページにはWikiNameを使用した方がいいでしょう。\n例）FrontPage、TopPage、MyRoom、HogeHoge",
	"$VIKIWIKIRUBY" => "rubyのパス",
	"$VIKIWIKIBASE" => <<EOS,
VikiWikiプログラムの設置ディレクトリ
あらかじめVikiWikiのサイトからダウンロードしたバイナリ(vikiwiki.zip、vikiwiki2.zip)を#{Dir::pwd}に格納しておくことで指定したディレクトリに自動的に解凍します。
なお、VikiWiki2の場合はディレクトリ名にvikiwiki2を指定してください。
VikiWikiの場合の例） /home/hoge/vikiwiki
VikiWiki2の場合の例) /home/hoge/vikiwiki2
EOS
	"$VIKIWIKITMP" => "作業ディレクトリ",
	"use_for" => "Wikiの運用モード",
	"use_for OPTION" => [
		["Normal", "通常の動的なWikiの運用"],
		["CMS", "Wikiの仕組みを利用した静的HTMLでのサイト構築(CMS)"],
		["StaticWiki", "参照を静的HTMLにすることで負荷軽減をするWikiの運用"],
		["DirectEdit", "WindowsやSambaでの共有ディレクトリを利用してエディタで直接編集可能なWiki"],
	],
	"AUTHTYPE" => "認証方法",
	"AUTHTYPE OPTION" => [
		["form", "form認証"],
		["none", "認証なし"],
		["www", "www認証"],
		["vikiwiki", "VikiWiki Basic認証"],
	],
	"THEMECSS" => <<EOS,
テーマ名またはテーマへのURI
tDiaryのテーマを使用したい方は、テーマのバイナリをダウンロードし、
ここのディレクトリ(#{Dir::pwd})に格納してください。
tDiaryのテーマは http://www.tdiary.net/theme から入手することができます。
テーマ名.tar.gzファイルをそのまま格納してください。
ここには格納したテーマのテーマ名(tar.gzをつけない)を指定します。
EOS
	"THEMEBASE" => "サイドバー\nサイドバーのありなしと配置を選択します。テーマに含まれる場合はなしを選択してください。",
	"THEMEBASE OPTION" => [
		["", "サイドバーなし"],
		["sidebar-left", "左サイドバー"],
		["sidebar-right", "右サイドバー"],
	],
	"passwd1" => "管理者のパスワード",
	"passwd2" => "管理者のパスワード(確認用)",
	"DESC_STATIC" => "静的HTMLの設定です。",
	"STATICDIR" => "静的HTMLのディレクトリ",
	"STATICURI" => "静的HTMLのURI",
	"DESC_DIRECTEDIT" => "DirectEditの設定です。",
	"remote_file_path" => "クライアントから参照可能なfile:////でのCGIスクリプトのパス",
	"FILEEXT" => "保存するテイストファイルの拡張子",
	"DESC_CHECK" => "設定を確認してください。",
}
}
