import MySQLdb, sys, configparser, time, subprocess, os, codecs

from main_config import main_Config

def morpheme_to_mysql(project, basis_word_check, content_check):
#    config=configparser.ConfigParser()
#    config.read('main.ini')
#    mysql_id=config['settings']["id"]
#    mysql_pass=config['settings']["pass"]
#    using_os=config['settings']["os"]
    mysql_id, mysql_pass, projects, root_path, using_os = main_Config()
    time.sleep(0.1)

    path = os.getcwd()

    words = morpheme(project, mysql_id, mysql_pass, basis_word_check, path, using_os)   #分かち書きデータの作成とmysqlへの保存
    time.sleep(0.1)
    speech = part_of_speech(project, mysql_id, mysql_pass, basis_word_check, path, using_os)    #品詞データの作成とmysqlへの保存
    time.sleep(0.1)


    if using_os == "nt":# or using_os == "posix":
        speeches = content_word(project, mysql_id, mysql_pass, words, speech)

        if content_check > 0:
            content_mysql(project, mysql_id, mysql_pass)
            speech_mysql(project, mysql_id, mysql_pass, speeches)
            time.sleep(0.1)
        else:
            pass
    elif using_os == "posix":
        mecab_content_word(project, mysql_id, mysql_pass, path, basis_word_check, content_check)
        if content_check > 0:
            content_mysql(project, mysql_id, mysql_pass)
        else:
            pass

    else:
        print("error")

    path1=os.getcwd() + "/morpheme_temp.txt"
    path2=os.getcwd() + "/mor_temp.txt"
    os.remove(path1)
    time.sleep(0.1)
    os.remove(path2)
    time.sleep(0.1)
    res=mysql_contents_check(project, mysql_id, mysql_pass)

    return res

def mysql_contents_check(project, mysql_id, mysql_pass):
    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        time.sleep(0.1)

        sql="select count(original_sentence) from text_table"
        cursor.execute(sql)
        res=cursor.fetchall()

        res = str((res[0])[0])

        sql="select original_sentence, morpheme from text_table where sentence_id = " + res
        cursor.execute(sql)
        res=cursor.fetchall()
        res=res[0]

        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

        return res

    except Exception as e:
        print(e)

def mecab_content_word(project, mysql_id, mysql_pass, path, basis_word_check, content_check):
    g = open("mor_temp.txt","w")
    g.write("")
    g.close()

    column="content_word"

#mecab merosu.txt | grep -e "名詞" -e "動詞" -e "形容詞" | cut -f 7 -d "," | tr '\n' ' ' > hogehoge.txt
#'mecab -Owakati ' + path + '/morpheme_temp.txt -o ' + path + '/mor_temp.txt'

    if basis_word_check == 0:   #基本形
        if content_check == 0 or content_check == 1:
            cmd = "mecab " +path + "/morpheme_temp.txt | grep -v '助動詞'| grep -e '名詞' -e '動詞' -e '形容詞' -e 'EOS'| cut -f 7 -d ',' | tr '\n' ' ' > " + path  + '/mor_temp.txt'
        else:
            cmd = "mecab " +path + "/morpheme_temp.txt | grep -e '名詞' -e '動詞' -e '形容詞' -e 'EOS'| cut -f 7 -d ',' | tr '\n' ' ' > " + path  + '/mor_temp.txt'
    else:   #表層形
        if content_check == 0 or content_check == 1:
            cmd = "mecab " +path + "/morpheme_temp.txt | grep -v '助動詞'| grep -e '名詞' -e '動詞' -e '形容詞' -e 'EOS'| cut -f1 | tr '\n' ' ' > " + path  + '/mor_temp.txt'
        else:
            cmd = "mecab " +path + "/morpheme_temp.txt | grep -e '名詞' -e '動詞' -e '形容詞' -e 'EOS'| cut -f1 | tr '\n' ' ' > " + path  + '/mor_temp.txt'

    popen = subprocess.Popen(cmd, shell=True)
    popen.wait()

    time.sleep(0.2)

    g = codecs.open("mor_temp.txt", "r", "utf-8")
    #print("A")
    mor_temp=str(g.readlines())
    mor_temp = " " + mor_temp
    mor_temp=mor_temp.replace("'","").replace("[","").replace("]","")
    mor = mor_temp.split("EOS")

    content_words=[]

    for n in mor:
        if n == " ":
            pass
        else:
            #print(n)
            content_words.append(n)

    insert_mor_words = []
    for i,j in enumerate(content_words):
        num = i + 1
        insert = (j, num)
        #print(insert)
        insert_mor_words.append(insert)

    insert_mysql(project, mysql_id, mysql_pass, insert_mor_words, column)

def speech_mysql(project, mysql_id, mysql_pass, speeches):
    all_speeches=[]
    for c, d in enumerate(speeches):
        d=str(d)
        d=d.replace("', '", " ").replace("['"," ").replace("']", " ")
        c += 1
        for_insert=(d,c)
        all_speeches.append(for_insert)

    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        time.sleep(0.1)

        sql="update text_table set part_of_speech = %s where sentence_id = %s"
        cursor.executemany(sql, all_speeches)

        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

    except Exception as e:
        print(e)

def content_mysql(project, mysql_id, mysql_pass):
    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        time.sleep(0.1)

        sql="update text_table set morpheme = content_word"
        cursor.execute(sql)

        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

    except Exception as e:
        print(e)


def content_word(project, mysql_id, mysql_pass, words, speech):
    contents=[]
    speeches=[]
    for (n, j) in zip(words, speech):
        n=n[0]
        j=j[0]
        n=n.split(" ")
        j=j.split(" ")
        content_word=[]
        content_speech=[]
        for (a, b) in zip(n, j):
            if b == "":
                pass
            elif b == "名詞" or b == "動詞" or b == "形容詞" or b == a:
                content_word.append(a)
                content_speech.append(b)
            else:
                pass
        #print(content_word)
        contents.append(content_word)
        speeches.append(content_speech)
    #print(contents)
    insert_mor_words=[]
    for c, d in enumerate(contents):
        d=str(d)
        d=d.replace("', '", " ").replace("['"," ").replace("']", " ")
        c += 1
        for_insert=(d,c)
        insert_mor_words.append(for_insert)

    column="content_word"
    time.sleep(0.1)
    insert_mysql(project, mysql_id, mysql_pass, insert_mor_words, column)
    time.sleep(0.1)

    return speeches

def part_of_speech(project, mysql_id, mysql_pass, basis_word_check, path, using_os):
    #inflection_cmd='mecab ' + path + '/morpheme_temp.txt -F"%f[1] " -U"%m " -E"\n" -o ' + path + '/mor_temp.txt'   #活用
    if using_os == "nt":
        cmd = path + '/mecab/bin/mecab.exe ' + path + '/morpheme_temp.txt -r ' + path + '/mecab/bin/mecabrc -o ' + path + '/mor_temp.txt -F"%f[0] " -U"%m " -E"\\r\\n" '
    elif using_os == "posix":
        cmd='mecab ' + path + '/morpheme_temp.txt -F"%f[0] " -U"%m " -E"\n" -o ' + path + '/mor_temp.txt'   #品詞
    else:
        pass

    popen = subprocess.Popen(cmd, shell=True)
    popen.wait()

    time.sleep(0.2)

    column="part_of_speech"

    insert_mor_words = mor_tuple(using_os)
    #print(insert_mor_words)
    insert_mysql(project, mysql_id, mysql_pass, insert_mor_words, column)

    time.sleep(0.2)

    return insert_mor_words

def morpheme(project, mysql_id, mysql_pass, basis_word_check, path, using_os):
    g = open("mor_temp.txt","w")
    g.write("")
    g.close()

    if using_os == "nt":
        if basis_word_check == 0:
            cmd = path + '/mecab/bin/mecab.exe ' + path + '/morpheme_temp.txt -r ' + path + '/mecab/bin/mecabrc -o ' + path + '/mor_temp.txt -F"%f[6] " -U"%m " -E"\\r\\n" '
        else:
            cmd = path + '/mecab/bin/mecab.exe -Owakati ' + path + '/morpheme_temp.txt -r ' + path + '/mecab/bin/mecabrc -o ' + path + '/mor_temp.txt'
    elif using_os == "posix":
        if basis_word_check == 0:
            cmd='mecab ' + path + '/morpheme_temp.txt -F"%f[6] " -U"%m " -E"\n" -o ' + path + '/mor_temp.txt'   #基本形
        else:
            cmd='mecab -Owakati ' + path + '/morpheme_temp.txt -o ' + path + '/mor_temp.txt'   #表層形
    else:
        pass

    popen = subprocess.Popen(cmd, shell=True)
    popen.wait()

    time.sleep(0.2)

    column="morpheme"

    insert_mor_words = mor_tuple(using_os)
    insert_mysql(project, mysql_id, mysql_pass, insert_mor_words, column)

    return insert_mor_words

def mor_tuple(using_os):
    g = codecs.open("mor_temp.txt", "r", "utf-8")#, "ignore")
    mor_temp=g.readlines()

    insert_text = []
    if using_os == "nt":
        win_temp=[]
        for n in mor_temp:
            if n == "\r\n":
                pass
            else:
                win_temp.append(n)
        for i,j in enumerate(win_temp):
            i += 1
            j=" " + j
            j=j.replace("\n","").replace("'","").replace("\r","")
            k=(j,i)
            #print(k)
            insert_text.append(k)
        g.close()

    elif using_os == "posix":
        for i,j in enumerate(mor_temp):
            i += 1
            j=" " + j
            j=j.replace("\n","").replace("'","")
            k=(j,i)
            #print(k)
            insert_text.append(k)
        g.close()
    #print(insert_text)
    return insert_text

def insert_mysql(project, mysql_id, mysql_pass, insert_mor_words, column):
    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        #conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8")
        cursor=conn.cursor()

        time.sleep(0.1)

        sql="update text_table set " + column + "=%s where sentence_id = %s"
        cursor.executemany(sql, insert_mor_words)

        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

    except Exception as e:
        print(e)


#mecab merosu.txt | grep -e "名詞" -e "動詞" -e "形容詞" | cut -f 7 -d "," | tr '\n' ' ' > hogehoge.txt

if __name__=="__main__":
    project="test"
    basis=0
    content_check=1
    morpheme_to_mysql(project, basis, content_check)
