package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckFloat;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.FloatTest
 */
public class CheckFloatTest extends TestCase {

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloat1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloat2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloatMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Float(Float.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloatMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Float(Float.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloatMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Float(Float.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation.
	 */
	@Test
	public void testFloatMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Float(Float.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation failure.
	 */
	@Test
	public void testFloatFailure1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data());
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the float validation failure.
	 */
	@Test
	public void testFloatFailure2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class  Data implements ITestData {
		private static final long serialVersionUID = 1282969251009230946L;
		@CheckFloat
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class  DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -5038621233264842879L;
		@CheckFloat(verifyWhenNull = true)
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
