package jp.sourceforge.masasa.architecture.framework.validation;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckDouble;
import junit.framework.TestCase;

import org.apache.commons.validator.ValidatorException;
import org.junit.Test;

/**
 * @see org.apache.commons.validator.DoubleTest
 */
public class CheckDoubleTest extends TestCase {

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDouble1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDouble2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull("0"));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDoubleMin1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Double(Double.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDoubleMin2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Double(Double.MIN_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDoubleMax1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data(new Double(Double.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation.
	 */
	@Test
	public void testDoubleMax2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull(new Double(Double.MAX_VALUE).toString()));
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation failure.
	 */
	@Test
	public void testDoubleFailure1() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new Data());
		Validator validator = new Validator();
		validator.validate(list);
		assertTrue(validator.getErrors().isEmpty());
	}

	/**
	 * Tests the double validation failure.
	 */
	@Test
	public void testDoubleFailure2() throws ValidatorException {
		List<ITestData> list = new ArrayList<ITestData>();
		list.add(new DataVerifyWhenNull());
		Validator validator = new Validator();
		validator.validate(list);
		assertFalse(validator.getErrors().isEmpty());
	}

	public class  Data implements ITestData {
		private static final long serialVersionUID = 1282969251009230946L;
		@CheckDouble
		private String data;

		public Data() {
		}

		public Data(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}

	public class  DataVerifyWhenNull implements ITestData {
		private static final long serialVersionUID = -5038621233264842879L;
		@CheckDouble(verifyWhenNull = true)
		private String data;

		public DataVerifyWhenNull() {
		}

		public DataVerifyWhenNull(String data) {
			this.data = data;
		}

		public String getData() {
			return data;
		}

		public void setData(String data) {
			this.data = data;
		}
	}
}
