package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckMask;

import org.apache.commons.validator.GenericValidator;

/**
 * Checks if the field matches the regular expression in the field's mask attribute.
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateMask(Object, org.apache.commons.validator.ValidatorAction,
 *      org.apache.commons.validator.Field, org.apache.struts.action.ActionMessages,
 *      org.apache.commons.validator.Validator, javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateMask implements IValidator {

    /**
     * Checks if the field matches the regular expression in the field's mask attribute.
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckMask resolver = (CheckMask) anno;
        return (!resolver.verifyWhenNull() && targetValue == null) ? true : GenericValidator.matchRegexp(targetValue,
                resolver.mask());
    }

}
