package jp.sourceforge.masasa.architecture.framework.validation.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.sourceforge.masasa.architecture.framework.validation.enumeration.CheckRulesEnum;
import jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator;

/**
 * Float型チェックルール用アノテーション.
 * 
 * @author masasa.
 * @see CheckRulesEnum#FloatCheck
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@ValidateResolver(CheckRulesEnum.FloatCheck)
public @interface CheckFloat {
    /**
     * チェック対象の値がnullの場合にチェックするか否か.
     * <ul>
     * <li><code>true</code>:チェックする.</li>
     * <li><code>false</code>:チェックしない.バリデータ(
     * {@link IValidator#validate(java.lang.annotation.Annotation, String, Object)} )はエラーなし(<code>true</code>)を返却する.</li>
     * </ul>
     */
    boolean verifyWhenNull() default false;
}
