package net.osdn.util.jersey;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import net.osdn.util.jersey.aspect.AspectHandler;

public class InvocationHandler implements java.lang.reflect.InvocationHandler {

	private static final NullObject NULL = new NullObject();
	
	private AspectHandler aspectHandler;
	
	public InvocationHandler(AspectHandler aspectHandler) {
		this.aspectHandler = aspectHandler;
	}
	
	@Override
	public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
		try {
			if(aspectHandler != null) {
				try { aspectHandler.onBeforeExecution(obj, method, args); } catch(Throwable ta) {}
			}
			Object result = method.invoke(obj, args);
			if(aspectHandler != null) {
				try { aspectHandler.onAfterReturning(obj, method, args, result); } catch(Throwable ta) {}
				try { aspectHandler.onAfterExecution(obj, method, args); } catch(Throwable ta) {}
			}
			if(result == null) {
				try {
					if(isProduceMediaTypeJson(method)) {
						result = NULL;
					}
				} catch(Exception e) {
					// ignore
				}
			}
			return result;
		} catch(InvocationTargetException t) {
			if(aspectHandler != null) {
				Throwable e = t.getTargetException();
				if(e != null && !(e instanceof WebApplicationException) && !(e instanceof AspectHandler.Ignore)) {
					try { aspectHandler.onAfterThrowing(obj, method, args, e); } catch(Throwable ta) {}
					try { aspectHandler.onAfterExecution(obj, method, args); } catch(Throwable ta) {}
				}
			}
			throw t;
		}
	}
	
	private static boolean isProduceMediaTypeJson(Method method) {
		Annotation[] annotations = method.getAnnotations();
		if(annotations != null) {
			for(int i = 0; i < annotations.length; i++) {
				Annotation annotation = annotations[i];
				if(annotation instanceof Produces) {
					Produces produces = (Produces)annotation;
					for(String s : produces.value()) {
						if(MediaType.APPLICATION_JSON.equals(s)) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	
	@JsonSerialize(using=NullObjectSerializer.class)
	public static class NullObject {
	}
	
	public static class NullObjectSerializer extends JsonSerializer<NullObject> {
		@Override
		public void serialize(NullObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
			gen.writeNull();
		}
	}
}
