/*
 * Polygon_RayTrace
 * Copylight (C) 2013 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */

#ifndef PHISICAL_PROPERTIES_H_
#define PHISICAL_PROPERTIES_H_

#include "opennurbs.h"
#include "rapidjson/rapidjson.h"
#include "rapidjson/document.h"

namespace rj = rapidjson;
struct LightSources{
	struct Impl;
	friend struct Impl;
	Impl *pimpl;
	LightSources(rj::Value &lsv);
	~LightSources();
	int LSCount() const;               ///< ̐
	int64_t RayCount() const;          ///< S̍v
	int64_t RayCount(int lsidx) const; ///< ě
	bool Get(int64_t idx, int &blockseed, int &lsidx, int64_t &rayidx, ON_3dRay &ray, double &flux, double &wavelength) const;
};

struct Materials{
	struct Impl;
	friend struct Impl;
	Impl *pimpl;
	Materials(rj::Value &mtv, rj::Value &shv, ON_SimpleArray<int> &shape2matidx);
	~Materials();
	int Count() const; ///< `ꂽގ̐
	bool GetParams(int midx, double wavelength, double &refl_rate, double &refr_index, double &transmittance, double &absorpt_coef) const;
	bool CalcBSDF(const ON_3dVector &emitray, bool transmitted, int &seed, ON_3dVector &scattered_dir) const;
};

#endif // PHISICAL_PROPERTIES_H_
