/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1.script2.tnode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mirrg.compile.bromine.v1_8.syntaxes.TagString;
import mirrg.compile.lithiumbromide.v1_2.ITNode;
import mirrg.compile.lithiumbromide.v1_2.nodes.NodeOperation;
import mirrg.compile.lithiumbromide.v1_2.util.TNodeBase;
import mirrg.complex.hydrogen.v1_0.StructureComplex;
import mirrg.game.math.wulfenite.v0_1.script2.ArgumentsInvoke;
import mirrg.game.math.wulfenite.v0_1.script2.ArgumentsValidate;
import mirrg.game.math.wulfenite.v0_1.script2.Type;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ITNodeExpression;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ITNodeRoutine;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.TNodeRootExpression;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.TNodeRootRoutine;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ToolsFunction;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ToolsVariable;
import org.eclipse.jdt.annotation.Nullable;

public class TNodes {
    public static String getSource() throws IOException {
        return new BufferedReader(new InputStreamReader(TNodes.class.getResource("test.libr").openStream())).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static Hashtable<String, Supplier<ITNode>> getTableCreator() {
        Hashtable<String, Supplier<ITNode>> hash = new Hashtable<String, Supplier<ITNode>>();
        try {
            for (Class<?> clazz : TNodes.class.getClasses()) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || !ITNode.class.isAssignableFrom(clazz)) continue;
                Class<?> clazz2 = clazz;
                Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
                hash.put(clazz2.getSimpleName(), () -> {
                    try {
                        return (ITNode)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        hash.put("RootRoutine", TNodeRootRoutine::new);
        hash.put("RootExpression", TNodeRootExpression::new);
        return hash;
    }

    public static class ExpressionRoutined
    extends TNodeBase
    implements ITNodeExpression {
        public Routines routines;
        public ITNodeExpression expression;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            if (!this.routines.validate(argumentsValidate)) {
                return false;
            }
            return this.expression.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.routines.invoke(argumentsInvoke);
            this.expression.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.expression.getType(argumentsValidate);
        }
    }

    public static class Routines
    extends TNodeBase
    implements ITNodeRoutine {
        public ArrayList<ITNodeRoutine> routines;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            for (ITNodeRoutine routine : this.routines) {
                if (routine.validate(argumentsValidate)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            for (ITNodeRoutine routine : this.routines) {
                routine.invoke(argumentsInvoke);
            }
        }
    }

    public static class RoutineIf
    extends TNodeBase
    implements ITNodeRoutine {
        public ITNodeExpression expression;
        public ITNodeRoutine onTrue;
        public @Nullable ITNodeRoutine onFalse;
        public int indexRegister;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.indexRegister = argumentsValidate.frameSpec.define(Type.StructureBoolean.class);
            if (!this.expression.validate(argumentsValidate)) {
                return false;
            }
            if (!Type.isAssignable(this.expression.getType(argumentsValidate), Type.StructureBoolean.class)) {
                argumentsValidate.addMessage(ToolsVariable.getTokenFirst(this.nodes), "\u578b\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
                return false;
            }
            argumentsValidate.frameSpec.undefine(this.indexRegister);
            if (!this.onTrue.validate(argumentsValidate)) {
                return false;
            }
            return this.onFalse == null || this.onFalse.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            Type.StructureBoolean buffer = (Type.StructureBoolean)argumentsInvoke.vm.stack.getFrameCurrent().buffers[this.indexRegister];
            this.expression.calculate(argumentsInvoke, buffer);
            if (buffer.value) {
                this.onTrue.invoke(argumentsInvoke);
            } else if (this.onFalse != null) {
                this.onFalse.invoke(argumentsInvoke);
            }
        }
    }

    public static class RoutineWhile
    extends TNodeBase
    implements ITNodeRoutine {
        public ITNodeExpression expression;
        public ITNodeRoutine routine;
        public int indexRegister;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.indexRegister = argumentsValidate.frameSpec.define(Type.StructureBoolean.class);
            if (!this.expression.validate(argumentsValidate)) {
                return false;
            }
            if (!Type.isAssignable(this.expression.getType(argumentsValidate), Type.StructureBoolean.class)) {
                argumentsValidate.addMessage(ToolsVariable.getTokenFirst(this.nodes), "\u578b\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
                return false;
            }
            argumentsValidate.frameSpec.undefine(this.indexRegister);
            return this.routine.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            int t = 0;
            while (true) {
                Type.StructureBoolean buffer = (Type.StructureBoolean)argumentsInvoke.vm.stack.getFrameCurrent().buffers[this.indexRegister];
                this.expression.calculate(argumentsInvoke, buffer);
                if (!buffer.value) break;
                this.routine.invoke(argumentsInvoke);
                if (++t != 10000) continue;
                t = 0;
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class RoutineBracket
    extends TNodeBase
    implements ITNodeRoutine {
        public Routines routines;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            boolean flag = true;
            argumentsValidate.frameSpec.managerVariable.push();
            if (!this.routines.validate(argumentsValidate)) {
                flag = false;
            }
            argumentsValidate.frameSpec.managerVariable.pop();
            return flag;
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            this.routines.invoke(argumentsInvoke);
        }
    }

    public static class RoutineDefinitionAndAssignmentVariable
    extends TNodeBase
    implements ITNodeRoutine {
        public TokenIdentifier type;
        public TokenIdentifier identifier;
        public ITNodeExpression expression;
        public ToolsVariable.DefinitionFromName definition;
        public ToolsVariable.Assignment assignment;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.definition = new ToolsVariable.DefinitionFromName(this.type.node.string.string, this.type, this.identifier.node.string.string, this.identifier);
            this.assignment = new ToolsVariable.Assignment(this.identifier.node.string.string, this.identifier, this.expression);
            if (!this.definition.validate(argumentsValidate)) {
                return false;
            }
            return this.assignment.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            this.assignment.invoke(argumentsInvoke);
        }
    }

    public static class RoutineDefinitionVariable
    extends TNodeBase
    implements ITNodeRoutine {
        public TokenIdentifier type;
        public TokenIdentifier identifier;
        public ToolsVariable.DefinitionFromName definition;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.definition = new ToolsVariable.DefinitionFromName(this.type.node.string.string, this.type, this.identifier.node.string.string, this.identifier);
            return this.definition.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
        }
    }

    public static class RoutineAssignment
    extends TNodeBase
    implements ITNodeRoutine {
        public TokenIdentifier identifier;
        public ITNodeExpression expression;
        public ToolsVariable.Assignment assignment;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.assignment = new ToolsVariable.Assignment(this.identifier.node.string.string, this.identifier, this.expression);
            return this.assignment.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            this.assignment.invoke(argumentsInvoke);
        }
    }

    public static class RoutineExpression
    extends TNodeBase
    implements ITNodeRoutine {
        public ITNodeExpression expression;
        public ToolsVariable.Assignment assignment;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.assignment = new ToolsVariable.Assignment("_", this, this.expression);
            return this.assignment.validate(argumentsValidate);
        }

        @Override
        public void invoke(ArgumentsInvoke argumentsInvoke) {
            this.assignment.invoke(argumentsInvoke);
        }
    }

    public static class ExpressionIif
    extends TNodeBase
    implements ITNodeExpression {
        public ITNodeExpression condition;
        public TagString operator1;
        public ITNodeExpression onTrue;
        public TagString operator2;
        public ITNodeExpression onFalse;
        public ITNodeExpression call;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.call = new ToolsFunction.Call(this.nodes, this.operator1.string + this.operator2.string, this.condition, this.onTrue, this.onFalse);
            return this.call.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.call.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.call.getType(argumentsValidate);
        }
    }

    public static class OperationsRight
    extends Operations {
        public OperationsRight() {
            super(true);
        }
    }

    public static class Operations
    extends TNodeBase
    implements ITNodeExpression {
        public NodeOperation.Operation operations;
        public boolean isRight;
        public ITNodeExpression call;

        public Operations() {
            this(false);
        }

        public Operations(boolean isRight) {
            this.isRight = isRight;
        }

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            if (this.isRight) {
                this.call = (ITNodeExpression)this.operations.operands.get(this.operations.operators.size());
                for (int i = this.operations.operators.size() - 1; i >= 0; --i) {
                    Operator operator = (Operator)this.operations.operators.get(i);
                    ITNodeExpression expression = (ITNodeExpression)this.operations.operands.get(i);
                    this.call = new ToolsFunction.Call(operator.nodes, operator.string.string, expression, this.call);
                }
                if (!this.call.validate(argumentsValidate)) {
                    return false;
                }
            } else {
                this.call = (ITNodeExpression)this.operations.operands.get(0);
                for (int i = 0; i < this.operations.operators.size(); ++i) {
                    Operator operator = (Operator)this.operations.operators.get(i);
                    ITNodeExpression expression = (ITNodeExpression)this.operations.operands.get(i + 1);
                    this.call = new ToolsFunction.Call(operator.nodes, operator.string.string, this.call, expression);
                }
                if (!this.call.validate(argumentsValidate)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.call.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.call.getType(argumentsValidate);
        }
    }

    public static class ExpressionMethods
    extends TNodeBase
    implements ITNodeExpression {
        public ITNodeExpression expression;
        public ArrayList<TokenCallMethod> operators;
        public ITNodeExpression call;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.call = this.expression;
            for (int i = 0; i < this.operators.size(); ++i) {
                TokenCallMethod operator = this.operators.get(i);
                this.call = new ToolsFunction.Call(operator.nodes, operator.token.identifier.node.string.string, this.getExpressions(this.call, operator.token.getExpressions()));
            }
            return this.call.validate(argumentsValidate);
        }

        protected ITNodeExpression[] getExpressions(ITNodeExpression self, ITNodeExpression[] arguments) {
            ITNodeExpression[] arguments2 = new ITNodeExpression[arguments.length + 1];
            arguments2[0] = self;
            System.arraycopy(arguments, 0, arguments2, 1, arguments.length);
            return arguments2;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.call.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.call.getType(argumentsValidate);
        }
    }

    public static class TokenCallMethod
    extends TNodeBase {
        public TokenCallFunction token;
    }

    public static class ExpressionSingle
    extends TNodeBase
    implements ITNodeExpression {
        public ArrayList<?> operators;
        public ITNodeExpression expression;
        public ITNodeExpression call;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.call = this.expression;
            for (int i = this.operators.size() - 1; i >= 0; --i) {
                TNodeBase operator2;
                Object operator = this.operators.get(i);
                if (operator instanceof Operator) {
                    operator2 = (Operator)operator;
                    this.call = new ToolsFunction.Call(operator2.nodes, operator2.string.string, this.call);
                    continue;
                }
                if (!(operator instanceof Cast)) continue;
                operator2 = (Cast)operator;
                Class<?> type = Type.getType(((Cast)operator2).type.node.string.string);
                if (type == null) {
                    ToolsVariable.addMessage(argumentsValidate, "\u672a\u77e5\u306e\u578b\u540d\u3067\u3059", operator2, ((Cast)operator2).type.node.string.string);
                    return false;
                }
                this.call = new Caster(((Cast)operator2).nodes, type, this.call);
            }
            return this.call.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.call.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.call.getType(argumentsValidate);
        }
    }

    public static class Caster
    implements ITNodeExpression {
        public ArrayList<?> nodes;
        public Class<?> type;
        public ITNodeExpression expression;
        public int indexRegisterResponse;

        public Caster(ArrayList<?> nodes, Class<?> type, ITNodeExpression expression) {
            this.nodes = nodes;
            this.type = type;
            this.expression = expression;
        }

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            if (!this.expression.validate(argumentsValidate)) {
                return false;
            }
            Class<?> typeArgument = this.expression.getType(argumentsValidate);
            if (!Type.isAssignable(typeArgument, this.type)) {
                argumentsValidate.addMessage(ToolsVariable.getTokenFirst(this.nodes), "\u578b\u5909\u63db\u304c\u51fa\u6765\u307e\u305b\u3093: " + this.type.getSimpleName() + " <= " + typeArgument.getSimpleName());
                return false;
            }
            this.indexRegisterResponse = argumentsValidate.frameSpec.define(this.type);
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            Object buffer2 = argumentsInvoke.vm.stack.getFrameCurrent().buffers[this.indexRegisterResponse];
            this.expression.calculate(argumentsInvoke, buffer2);
            Type.assign(buffer, buffer2);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.type;
        }
    }

    public static class Cast
    extends TNodeBase {
        public TokenIdentifier type;
    }

    public static class Operator
    extends TNodeBase {
        public TagString string;
    }

    public static class Do
    extends TNodeBase
    implements ITNodeExpression {
        public ExpressionRoutined expression;
        public Class<?> type;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            boolean flag = true;
            argumentsValidate.frameSpec.managerVariable.push();
            if (!this.expression.validate(argumentsValidate)) {
                flag = false;
            }
            if (flag) {
                this.type = this.expression.getType(argumentsValidate);
            }
            argumentsValidate.frameSpec.managerVariable.pop();
            return flag;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.expression.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.type;
        }
    }

    public static class Bracket
    extends TNodeBase
    implements ITNodeExpression {
        public ITNodeExpression expression;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            return this.expression.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.expression.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.expression.getType(argumentsValidate);
        }
    }

    public static class LiteralNumeric
    extends TNodeBase
    implements ITNodeExpression {
        public ITNodeExpression token;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            return this.token.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.token.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.token.getType(argumentsValidate);
        }
    }

    public static class Function
    extends TNodeBase
    implements ITNodeExpression {
        public TokenCallFunction token;
        public ITNodeExpression call;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            ITNodeExpression[] expressions = this.token.getExpressions();
            this.call = new ToolsFunction.Call(this.token.identifier.nodes, this.token.identifier.node.string.string, expressions);
            return this.call.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.call.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.call.getType(argumentsValidate);
        }
    }

    public static class TokenCallFunction
    extends TNodeBase {
        public TokenIdentifier identifier;
        public NodeOperation.Operation arguments;

        public ITNodeExpression[] getExpressions() {
            ITNodeExpression[] expressions;
            if (this.arguments == null) {
                expressions = new ITNodeExpression[]{};
            } else {
                expressions = new ITNodeExpression[this.arguments.operands.size()];
                for (int i = 0; i < this.arguments.operands.size(); ++i) {
                    ITNodeExpression expression;
                    expressions[i] = expression = (ITNodeExpression)this.arguments.operands.get(i);
                }
            }
            return expressions;
        }
    }

    public static class Variable
    extends TNodeBase
    implements ITNodeExpression {
        public TokenIdentifier identifier;
        public ITNodeExpression expression;
        public ToolsVariable.Extraction extraction;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            this.extraction = new ToolsVariable.Extraction(this.identifier.node.string.string, this.identifier);
            return this.extraction.validate(argumentsValidate);
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            this.extraction.calculate(argumentsInvoke, buffer);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.extraction.getType(argumentsValidate);
        }
    }

    public static class TokenImaginary
    extends TNodeBase
    implements ITNodeExpression {
        public Imaginary node;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            Type.assign(buffer, new StructureComplex(0.0, this.node.real.get().value));
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return StructureComplex.class;
        }
    }

    public static class TokenReal
    extends TNodeBase
    implements ITNodeExpression {
        public Real node;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            Type.assign(buffer, this.node.get());
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return Type.StructureDouble.class;
        }
    }

    public static class TokenInteger
    extends TNodeBase
    implements ITNodeExpression {
        public IntegerUnsigned radix;
        public TagString string;
        public Type.StructureInteger value;

        public Type.StructureInteger get() {
            if (this.value == null) {
                this.value = new Type.StructureInteger(Integer.parseInt(this.string.string, this.radix.get().value == 0 ? 16 : this.radix.get().value));
            }
            return this.value;
        }

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            if (this.radix.get().value > 36) {
                argumentsValidate.addMessage(this.radix.string, "\u57fa\u6570\u306f0\uff5e36\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093: " + this.radix.get());
                return false;
            }
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            Type.assign(buffer, this.get());
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return Type.StructureInteger.class;
        }
    }

    public static class TokenDecimal
    extends TNodeBase
    implements ITNodeExpression {
        public IntegerSigned node;

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            Type.assign(buffer, this.node.get());
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return Type.StructureInteger.class;
        }
    }

    public static class TokenIdentifier
    extends TNodeBase {
        public Identifier node;
    }

    public static class Imaginary
    extends TNodeBase {
        public Real real;
    }

    public static class Real
    extends TNodeBase {
        public IntegerSigned significand;
        public @Nullable Fraction fraction;
        public @Nullable Exponent exponent;
        public Type.StructureDouble value;

        public Type.StructureDouble get() {
            if (this.value == null) {
                this.value = new Type.StructureDouble(Double.parseDouble(String.format("%s%s%s", this.significand.get().value, this.fraction == null ? "" : "." + this.fraction.string.string, this.exponent == null ? "" : "E" + this.exponent.integer.get().value)));
            }
            return this.value;
        }
    }

    public static class Exponent
    extends TNodeBase {
        public IntegerSigned integer;
    }

    public static class Fraction
    extends TNodeBase {
        public TagString string;
    }

    public static class IntegerSigned
    extends TNodeBase {
        public @Nullable Sign sign;
        public IntegerUnsigned integer;
        public Type.StructureInteger value;

        public Type.StructureInteger get() {
            if (this.value == null) {
                this.value = new Type.StructureInteger(this.sign != null && this.sign.string.string.equals("-") ? -this.integer.get().value : this.integer.get().value);
            }
            return this.value;
        }
    }

    public static class IntegerUnsigned
    extends TNodeBase {
        public TagString string;
        public Type.StructureInteger value;

        public Type.StructureInteger get() {
            if (this.value == null) {
                this.value = new Type.StructureInteger(Integer.parseInt(this.string.string, 10));
            }
            return this.value;
        }
    }

    public static class Sign
    extends TNodeBase {
        public TagString string;
    }

    public static class Identifier
    extends TNodeBase {
        public TagString string;
    }

    public static class Comments
    extends TNodeBase {
        public ArrayList<TagString> strings;
    }
}

