/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1;

import java.awt.CardLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mirrg.applet.mathematics.zinc.v1_0.core.ZincTransform;
import mirrg.game.math.wulfenite.v0_1.FrameBase;
import mirrg.game.math.wulfenite.v0_1.FrameFormula;
import mirrg.game.math.wulfenite.v0_1.PanelWulfenite;
import mirrg.game.math.wulfenite.v0_1.events.NitrogenEventWulfenite;
import mirrg.game.math.wulfenite.v0_1.events.NitrogenEventWulfeniteFrameFormula;
import mirrg.game.math.wulfenite.v0_1.script2.HWulfeniteScript2;

public class FrameWulfenite
extends FrameBase {
    private static final long serialVersionUID = 6223286656125135971L;
    protected boolean initialized = false;
    protected FrameFormula frameFormula;
    protected NitrogenEventWulfeniteFrameFormula.Success formula;
    private PanelWulfenite panelWulfenite;

    public static void main(String[] args) {
        FrameWulfenite.setLookAndFeel();
        FrameBase.init(new FrameWulfenite()).setVisible(true);
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public FrameWulfenite() {
        super("Wulfenite");
    }

    @Override
    protected void preInit() {
        this.frameFormula = FrameBase.init(new FrameFormula(this.getEventManager()));
    }

    @Override
    protected void initContents() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("\u65b0\u898f\u30a6\u30a3\u30f3\u30c9\u30a6(N)");
        menuItem.setMnemonic('N');
        menu.add(menuItem);
        menuItem = new JMenuItem("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f(P)...");
        menuItem.setMnemonic('P');
        menu.add(menuItem);
        JMenu menu2 = new JMenu("\u30b5\u30f3\u30d7\u30eb\u30d5\u30a1\u30a4\u30eb(A)");
        menu2.setMnemonic('A');
        menu.add(menu2);
        JMenuItem menuItem2 = new JMenuItem("Wulfenite \u30a2\u30a4\u30b3\u30f3(1)");
        menuItem2.setMnemonic('1');
        menu2.add(menuItem2);
        menu.addSeparator();
        menuItem = new JMenuItem("\u73fe\u5728\u4f4d\u7f6e\u3092\u4fdd\u5b58(S)...");
        menuItem.setMnemonic('S');
        menu.add(menuItem);
        menuItem = new JMenuItem("\u30a8\u30af\u30b9\u30dd\u30fc\u30c8(E)...");
        menuItem.setMnemonic('E');
        menu.add(menuItem);
        menu = new JMenu("\u8868\u793a(S)");
        menu.setMnemonic('S');
        menuBar.add(menu);
        menuItem = new JMenuItem("\u7e26\u6a2a\u6bd4\u3092\u521d\u671f\u5316(A)");
        menuItem.setMnemonic('A');
        menu.add(menuItem);
        menuItem.addActionListener(event -> this.resetAspect());
        menuItem = new JMenuItem("\u4f4d\u7f6e\u3092\u521d\u671f\u5316(P)");
        menuItem.setMnemonic('P');
        menu.add(menuItem);
        menuItem.addActionListener(event -> this.resetPosition());
        menuItem = new JMenuItem("\u62e1\u5927\u7387\u3092\u521d\u671f\u5316(Z)");
        menuItem.setMnemonic('Z');
        menu.add(menuItem);
        menuItem.addActionListener(event -> this.resetZoom());
        menu = new JMenu("\u8272(C)");
        menu.setMnemonic('C');
        menuBar.add(menu);
        menu = new JMenu("\u6570\u5f0f(M)");
        menu.setMnemonic('M');
        menuBar.add(menu);
        menuItem = new JMenuItem("\u6570\u5f0f(M)...");
        menuItem.setMnemonic('M');
        menu.add(menuItem);
        menuItem.addActionListener(event -> this.frameFormula.setVisible(true));
        menu = new JMenu("\u30c4\u30fc\u30eb(T)");
        menu.setMnemonic('T');
        menuBar.add(menu);
        menu = new JMenu("\u30c7\u30d0\u30c3\u30b0(D)");
        menu.setMnemonic('D');
        menuBar.add(menu);
        menuItem = new JMenuItem("\u30b3\u30f3\u30d1\u30a4\u30e9\u521d\u671f\u5316(C)...");
        menuItem.setMnemonic('C');
        menu.add(menuItem);
        menuItem.addActionListener(event -> HWulfeniteScript2.init());
        menuBar.add(Box.createHorizontalGlue());
        menu = new JMenu("\u30d8\u30eb\u30d7(H)");
        menu.setMnemonic('H');
        menuBar.add(menu);
        this.panelWulfenite = new PanelWulfenite(this.getEventManager());
        this.add(this.panelWulfenite);
        this.setLayout(new CardLayout());
    }

    public void resetAspect() {
        if (this.panelWulfenite != null) {
            ZincTransform t = this.panelWulfenite.applet.getTransform();
            double zoom = Math.min(Math.abs(t.pixelsPerX), Math.abs(t.pixelsPerY));
            t.pixelsPerX = zoom * Math.signum(t.pixelsPerX);
            t.pixelsPerY = zoom * Math.signum(t.pixelsPerY);
            this.dirty();
        }
    }

    public void resetPosition() {
        if (this.panelWulfenite != null) {
            ZincTransform t = this.panelWulfenite.applet.getTransform();
            t.centerCoordX = 0.0;
            t.centerCoordY = 0.0;
            this.dirty();
        }
    }

    public void resetZoom() {
        if (this.panelWulfenite != null) {
            ZincTransform t = this.panelWulfenite.applet.getTransform();
            t.pixelsPerX = 100.0 * Math.signum(t.pixelsPerX);
            t.pixelsPerY = 100.0 * Math.signum(t.pixelsPerY);
            this.dirty();
        }
    }

    @Override
    protected void initEvents() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (!FrameWulfenite.this.initialized) {
                    FrameWulfenite.this.initialized = true;
                    FrameWulfenite.this.getEventManager().post(new NitrogenEventWulfenite.Init());
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                FrameWulfenite.this.getEventManager().post(new NitrogenEventWulfenite.Destroy());
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.frameFormula.getEventManager().register(NitrogenEventWulfeniteFrameFormula.Success.class, event -> {
            this.formula = event;
            this.dirty();
        });
    }

    public void dirty() {
        this.getEventManager().post(new NitrogenEventWulfenite.Dirty(this.formula));
    }

    @Override
    protected void postInit() {
        this.setIconImage(new ImageIcon(FrameWulfenite.class.getResource("icon.png")).getImage());
        this.setSize(600, 600);
    }
}

