/*
 * Decompiled with CFR 0.152.
 */
package mirrg.complex.hydrogen.v1_0.functions;

import mirrg.complex.hydrogen.v1_0.StructureComplex;
import org.apache.commons.math3.util.FastMath;

public class Exponential {
    public static final double LOG_E_2 = Math.log(2.0);
    public static final double LOG_E_5 = Math.log(5.0);
    public static final double LOG_E_10 = Math.log(10.0);

    public static final void pow(StructureComplex z, StructureComplex a) {
        Exponential.log(z);
        z.mul(a);
        Exponential.exp(z);
    }

    public static final void pow(StructureComplex z, double r, double i) {
        Exponential.log(z);
        z.mul(r, i);
        Exponential.exp(z);
    }

    public static final void pow(StructureComplex z, double r) {
        Exponential.log(z);
        z.mul(r);
        Exponential.exp(z);
    }

    public static final void pow2(StructureComplex z) {
        z.set(FastMath.pow(z.re, 2) - FastMath.pow(z.im, 2), 2.0 * z.re * z.im);
    }

    public static final void exp(StructureComplex z, StructureComplex a) {
        z.mul(a.getLogAbstract(), a.getArgument());
        Exponential.exp(z);
    }

    public static final void exp(StructureComplex z, double r, double i) {
        z.mul(FastMath.log(FastMath.pow(r, 2) + FastMath.pow(i, 2)) / 2.0, FastMath.atan2(i, r));
        Exponential.exp(z);
    }

    public static final void exp(StructureComplex z, double r) {
        double expReal = FastMath.pow(r, z.re);
        double a = z.im * FastMath.log(r);
        z.set(expReal * FastMath.cos(a), expReal * FastMath.sin(a));
    }

    public static final void exp(StructureComplex z) {
        double expReal = FastMath.exp(z.re);
        z.set(expReal * FastMath.cos(z.im), expReal * FastMath.sin(z.im));
    }

    public static final void log(StructureComplex z, StructureComplex a) {
        Exponential.log(z);
        z.div(a.getLogAbstract(), a.getArgument());
    }

    public static final void log(StructureComplex z, double r, double i) {
        Exponential.log(z);
        z.div(FastMath.log(FastMath.pow(r, 2) + FastMath.pow(i, 2)) / 2.0, FastMath.atan2(i, r));
    }

    public static final void log(StructureComplex z, double r) {
        Exponential.log(z);
        z.div(FastMath.log(r));
    }

    public static final void log2(StructureComplex z) {
        Exponential.log(z);
        z.div(LOG_E_2);
    }

    public static final void log5(StructureComplex z) {
        Exponential.log(z);
        z.div(LOG_E_5);
    }

    public static final void log10(StructureComplex z) {
        Exponential.log(z);
        z.div(LOG_E_10);
    }

    public static final void log(StructureComplex z) {
        z.set(z.getLogAbstract(), z.getArgument());
    }

    public static final void ln(StructureComplex z) {
        Exponential.log(z);
    }
}

