/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.lithiumbromide.v1_2.nodes;

import java.util.ArrayList;
import java.util.stream.Collectors;
import mirrg.compile.bromine.v1_8.Syntax;
import mirrg.compile.bromine.v1_8.syntaxes.connection.SyntaxSerial;
import mirrg.compile.bromine.v1_8.util.HBromine;
import mirrg.compile.lithiumbromide.v1_2.HLithiumBromide;
import mirrg.compile.lithiumbromide.v1_2.node.ArgumentsCreateCompiler;
import mirrg.compile.lithiumbromide.v1_2.node.INodeLithiumBromide;
import mirrg.compile.lithiumbromide.v1_2.nodes.NodeElement;

public class NodeSerial
extends NodeElement {
    public ArrayList<NodeElement> nodes;

    public String toString() {
        return this.nodes.stream().map(node -> node.toString()).collect(Collectors.joining(" "));
    }

    public NodeSerial clone() {
        NodeSerial node = new NodeSerial();
        node.nodes = this.nodes;
        return node;
    }

    @Override
    public Syntax<Object> getSyntax(ArgumentsCreateCompiler arguments) {
        if (this.nodes.size() != 1) {
            SyntaxSerial<ArrayList> serial = HBromine.serial(list -> HLithiumBromide.clone(list), tag -> new ArrayList());
            this.nodes.forEach((? super E node) -> serial.and(node.getSyntax(arguments), (node2, index, child) -> node2.add(child), (node2, index) -> node2.remove(node2.size() - 1)));
            return HBromine.wrapper(serial);
        }
        return this.nodes.get(0).getSyntax(arguments);
    }

    @Override
    public void forEach(INodeLithiumBromide.Consumer consumer) throws Exception {
        for (NodeElement node : this.nodes) {
            consumer.accept(node);
        }
    }
}

