/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.bromine.v1_8.syntaxes;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mirrg.compile.bromine.v1_8.ArgumentsParse;
import mirrg.compile.bromine.v1_8.ResponseParse;
import mirrg.compile.bromine.v1_8.Syntax;
import mirrg.compile.bromine.v1_8.syntaxes.TagRegex;
import mirrg.util.NonnullIterable;

public class SyntaxRegex<N>
extends Syntax<N> {
    public final String regex;
    public final Pattern pattern;
    public final Function<TagRegex, N> functionNode;

    public SyntaxRegex(String regex, Function<TagRegex, N> functionNode) {
        this.regex = regex;
        this.pattern = Pattern.compile("\\A" + regex);
        this.functionNode = functionNode;
    }

    @Override
    protected NonnullIterable<ResponseParse<N>> parseImpl(ArgumentsParse arguments, int index) {
        Matcher matcher = this.pattern.matcher(arguments.source.subSequence(index, arguments.source.length()));
        if (matcher.find()) {
            String string = matcher.group();
            return NonnullIterable.of(new ResponseParse<N>(this.functionNode.apply(new TagRegex(index, string.length(), string, matcher, this.pattern)), string.length(), arguments));
        }
        arguments.report(index, "\"" + this.regex + "\"");
        return NonnullIterable.empty();
    }
}

