/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.v1_5.modules.rendering;

import java.awt.Image;
import mirrg.applet.nitrogen.v1_5.AppletNitrogen;
import mirrg.applet.nitrogen.v1_5.Module;
import mirrg.applet.nitrogen.v1_5.ModuleComponentEvent;
import mirrg.applet.nitrogen.v1_5.NitrogenEventApplet;
import mirrg.applet.nitrogen.v1_5.modules.rendering.BackBuffer;
import mirrg.applet.nitrogen.v1_5.modules.threading.ModuleGameThread;
import mirrg.event.nitrogen.api.v1_0.INitrogenEventManager;

public class ModuleTripleBuffer
extends Module {
    private BackBuffer safety = new BackBuffer(1);
    private BackBuffer dirty = new BackBuffer(1);

    public ModuleTripleBuffer(AppletNitrogen applet, ModuleComponentEvent moduleComponentEvent, ModuleGameThread moduleGameThread) {
        super(applet);
        applet.getEventManager().register(NitrogenEventApplet.Paint.Pre.class, event -> {
            event.cancelled = true;
        });
        this.subscribeEvent(applet.getEventManager());
    }

    public void rebuffer(int width, int height) {
        this.safety.rebuffer(width, height);
        this.dirty.rebuffer(width, height);
    }

    public synchronized BackBuffer getBufferSafety() {
        return this.safety;
    }

    public synchronized BackBuffer getBufferDirty() {
        return this.dirty;
    }

    public synchronized int getWidth() {
        return this.dirty.getWidth();
    }

    public synchronized int getHeight() {
        return this.dirty.getHeight();
    }

    public synchronized void flip() {
        this.dirty.flip(this.safety);
    }

    public void copy() {
        this.safety.getGraphics().drawImage((Image)this.dirty.getBuffer(), 0, 0, null);
    }

    public void rollback() {
        this.rollback(0, 0);
    }

    public void rollback(int x, int y) {
        this.rollback(x, y, this.getWidth(), this.getHeight());
    }

    public void rollback(int x, int y, int width, int height) {
        this.dirty.getGraphics().drawImage(this.safety.getBuffer(), x, y, width, height, null);
    }

    public void subscribeEvent(INitrogenEventManager eventManager) {
        this.dirty.subscribeEvent(eventManager);
        this.safety.subscribeEvent(eventManager);
    }
}

