/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.mathematics.zinc.v1_0.gadgets;

import java.awt.Color;
import java.awt.Font;
import mirrg.applet.mathematics.zinc.v1_0.core.IZincCanvas;
import mirrg.applet.mathematics.zinc.v1_0.gadgets.ZincGadget;
import mirrg.util.hydrogen.v1_0.HAwt;
import mirrg.util.hydrogen.v1_0.HMath;
import mirrg.util.hydrogen.v1_0.HString;

public class ZincGadgetGrid
extends ZincGadget {
    private static final Font font = new Font("MS Gothic", 1, 14);
    public boolean enabledGrid = true;
    public boolean enabledCursor = true;
    public IFunction function;

    public ZincGadgetGrid(IZincCanvas zincCanvas) {
        super(zincCanvas);
    }

    @Override
    public void renderOverlay() {
        int dy;
        double mgridy;
        int dx;
        double mgridx;
        double tmp;
        if (!this.enabledGrid && !this.enabledCursor) {
            return;
        }
        double mx1 = this.zincCanvas.getTransform().getCoordX(0.0);
        double my1 = this.zincCanvas.getTransform().getCoordY(0.0);
        double mx2 = this.zincCanvas.getTransform().getCoordX(this.zincCanvas.getWidth());
        double my2 = this.zincCanvas.getTransform().getCoordY(this.zincCanvas.getHeight());
        if (mx1 > mx2) {
            tmp = mx1;
            mx1 = mx2;
            mx2 = tmp;
        }
        if (my1 > my2) {
            tmp = my1;
            my1 = my2;
            my2 = tmp;
        }
        double mwidth = mx2 - mx1;
        double mheight = my2 - my1;
        double gridSpaceW = HMath.nice(mwidth * 0.3);
        double gridSpaceH = HMath.nice(mheight * 0.3);
        int effectiveDigitW = (int)(-Math.log10(gridSpaceW) + 0.9);
        int effectiveDigitH = (int)(-Math.log10(gridSpaceH) + 0.9);
        double mgridstartx = Math.ceil(mx1 / gridSpaceW) * gridSpaceW;
        double mgridstarty = Math.ceil(my1 / gridSpaceH) * gridSpaceH;
        double gridSpaceDispW = this.zincCanvas.getTransform().getScreenX(mx1 + gridSpaceW);
        double mgridendx = mx2;
        double mgridendy = my2;
        if (this.enabledGrid) {
            this.zincCanvas.getBufferDirty().getGraphics().setColor(Color.black);
            for (mgridx = mgridstartx; mgridx < mgridendx; mgridx += gridSpaceW) {
                dx = (int)this.zincCanvas.getTransform().getScreenX(mgridx);
                this.zincCanvas.getBufferDirty().getGraphics().drawLine(dx, 0, dx, this.zincCanvas.getHeight());
            }
            for (mgridy = mgridstarty; mgridy < mgridendy; mgridy += gridSpaceH) {
                dy = (int)this.zincCanvas.getTransform().getScreenY(mgridy);
                this.zincCanvas.getBufferDirty().getGraphics().drawLine(0, dy, this.zincCanvas.getWidth(), dy);
            }
        }
        if (this.enabledCursor) {
            this.zincCanvas.getBufferDirty().getGraphics().setColor(Color.blue);
            mgridx = this.zincCanvas.getTransform().getCoordX(this.zincCanvas.getInputStatus().getMouseX());
            dx = (int)this.zincCanvas.getTransform().getScreenX(mgridx);
            this.zincCanvas.getBufferDirty().getGraphics().drawLine(dx, 0, dx, this.zincCanvas.getHeight());
            mgridy = this.zincCanvas.getTransform().getCoordY(this.zincCanvas.getInputStatus().getMouseY());
            dy = (int)this.zincCanvas.getTransform().getScreenY(mgridy);
            this.zincCanvas.getBufferDirty().getGraphics().drawLine(0, dy, this.zincCanvas.getWidth(), dy);
        }
        if (this.enabledGrid) {
            String str;
            int drawY = 0;
            for (double mgridx2 = mgridstartx; mgridx2 < mgridendx; mgridx2 += gridSpaceW) {
                int dx2 = (int)this.zincCanvas.getTransform().getScreenX(mgridx2);
                str = HString.getEffectiveExpression(mgridx2, effectiveDigitW);
                this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
                HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, dx2, (1 + drawY) * this.zincCanvas.getBufferDirty().getGraphics().getFont().getSize(), Color.white, Color.black);
                int textLength = this.zincCanvas.getBufferDirty().getGraphics().getFontMetrics().stringWidth(str);
                drawY = (drawY + 1) % (1 + (int)((double)textLength / gridSpaceDispW));
            }
            for (double mgridy2 = mgridstarty; mgridy2 < mgridendy; mgridy2 += gridSpaceH) {
                int dy2 = (int)this.zincCanvas.getTransform().getScreenY(mgridy2);
                str = HString.getEffectiveExpression(mgridy2, effectiveDigitH);
                this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
                HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, 0, dy2 + this.zincCanvas.getBufferDirty().getGraphics().getFont().getSize(), Color.white, Color.black);
            }
        }
        if (this.enabledCursor) {
            if (this.function != null) {
                double[] value = this.function.getValue(this.zincCanvas.getTransform().getCoordX(this.zincCanvas.getInputStatus().getMouseX()), this.zincCanvas.getTransform().getCoordY(this.zincCanvas.getInputStatus().getMouseY()));
                String str = "Re: " + value[0];
                this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
                HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, this.zincCanvas.getInputStatus().getMouseX() + 2, this.zincCanvas.getInputStatus().getMouseY() - 2 - this.zincCanvas.getBufferDirty().getGraphics().getFont().getSize() * 3, Color.white, Color.black);
                str = "Im: " + value[1];
                this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
                HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, this.zincCanvas.getInputStatus().getMouseX() + 2, this.zincCanvas.getInputStatus().getMouseY() - 2 - this.zincCanvas.getBufferDirty().getGraphics().getFont().getSize() * 2, Color.white, Color.black);
            }
            double mgridx3 = this.zincCanvas.getTransform().getCoordX(this.zincCanvas.getInputStatus().getMouseX());
            String str = "X: " + HString.getEffectiveExpression(mgridx3, effectiveDigitW + 4);
            this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
            HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, this.zincCanvas.getInputStatus().getMouseX() + 2, this.zincCanvas.getInputStatus().getMouseY() - 2 - this.zincCanvas.getBufferDirty().getGraphics().getFont().getSize(), Color.white, Color.black);
            double mgridy3 = this.zincCanvas.getTransform().getCoordY(this.zincCanvas.getInputStatus().getMouseY());
            str = "Y: " + HString.getEffectiveExpression(mgridy3, effectiveDigitH + 4);
            this.zincCanvas.getBufferDirty().getGraphics().setFont(this.getFont());
            HAwt.drawBoldString(this.zincCanvas.getBufferDirty().getGraphics(), str, this.zincCanvas.getInputStatus().getMouseX() + 2, this.zincCanvas.getInputStatus().getMouseY() - 2, Color.white, Color.black);
        }
    }

    @Override
    public void doInput() {
        if (this.zincCanvas.getInputStatus().getKeyBoard().getState(71) == 1) {
            if (this.zincCanvas.getInputStatus().getKeyBoard().getState(17) <= 0) {
                boolean bl = this.enabledGrid = !this.enabledGrid;
            }
            if (this.zincCanvas.getInputStatus().getKeyBoard().getState(16) <= 0) {
                this.enabledCursor = !this.enabledCursor;
            }
        }
    }

    protected Font getFont() {
        return font;
    }

    public static interface IFunction {
        public double[] getValue(double var1, double var3);
    }
}

