/* 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef RSXADVANCED_H
#define RSXADVANCED_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "PropPage.h"
#include "WinUtil.h"

#include "resource.h"
#include "../client/RawManager.h"

class RSXAdvanced : public CPropertyPage<IDD_RSXADVANCED>, public PropPage, protected RawSelector
{
public:

	RSXAdvanced(SettingsManager *s) : PropPage(s) {
		title = _tcsdup((TSTRING(SETTINGS_FAKEDETECT) + _T('\\') + TSTRING(SETTINGS_ADVANCEDD)).c_str());
		SetTitle(title);
		m_psp.dwFlags |= PSP_RTLREADING;
	}
	~RSXAdvanced() {
		free(title);
	};

	BEGIN_MSG_MAP(RSXAdvanced)
		MESSAGE_HANDLER(WM_INITDIALOG, onInitDialog)
		REFLECT_NOTIFICATIONS()
	END_MSG_MAP()

	LRESULT onInitDialog(UINT, WPARAM, LPARAM, BOOL&);

	// Common PropPage interface
	PROPSHEETPAGE *getPSP() { return (PROPSHEETPAGE *)*this; }
	void write();

private:
	TCHAR* title;

	static Item items[];
	static TextItem texts[];
	static ListItem listItems[];
};

#endif //DCDMCOLOURSPAGE_H