/* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef FC_DLG_H
#define FC_DLG_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atlcrack.h>
#include "../client/Util.h"
#include "../client/CriticalSection.h"
#include "../client/RawManager.h"

namespace dcpp {

//class for basic fav hub info
class Favs {
public:
	typedef Favs* Ptr;
	typedef vector<Ptr> List;
	typedef List::const_iterator Iter;

	Favs() : userdesc(""), 
		headerOrder(SETTING(HUBFRAME_ORDER)),
		headerWidths(SETTING(HUBFRAME_WIDTHS)),
		headerVisible(SETTING(HUBFRAME_VISIBLE)),
		connect(false), 
		windowposx(0), 
		windowposy(0), 
		windowsizex(0), 
		windowsizey(0), 
		windowtype(0), 
		chatusersplit(0), 
		stealth(false),
		userliststate(true), 
		encoding(Text::systemCharset),
		checkOnConnect(false), 
		checkClients(true),
		checkFilelists(true), 
		checkMyInfo(true), 
		hideShare(false), 
		checkFakeShare(false),
		useFilter(false),
		autosearch(false),
		useHL(false),
		mode(0)
	{ };

	Favs(const string& aUserDesc,
		const string& aNick,
		const string& aName,
		const string& aServer,
		const string& aDesc,
		const string& aPasswd,
		const string& aHO,
		const string& aHW,
		const string& aHV,
		bool aConnect,
		const string& aEncoding,
		int aWinPosX,
		int aWinPosY,
		int aWinSizeX,
		int aWinSizeY,
		int aWinType,
		int aChatUserSplit,
		bool aStealth,
		bool aUserlistState,
		const string& aFavEmail,
		const string& aFavAway,
		const string& aProtected,
		bool aCOC,
		bool aCC,
		bool aCF,
		bool aCMI,
		bool aHideShare,
		bool aCFS,
		bool aFilter,
		bool aAS,
		bool aHL,
		int aMode,
		const string& aIp
		) throw() : 
	
		userdesc(aUserDesc), 
		name(aName), 
		server(aServer), 
		desc(aDesc), 
		password(aPasswd),
		headerOrder(aHO),
		headerWidths(aHW),
		headerVisible(aHV),
		connect(aConnect), 
		nick(aNick), 
		windowposx(aWinPosX), 
		windowposy(aWinPosY), 
		windowsizex(aWinSizeX), 
		windowsizey(aWinSizeY), 
		windowtype(aWinType), 
		chatusersplit(aChatUserSplit), 
		stealth(aStealth),
		userliststate(aUserlistState), 
		encoding(aEncoding),
		favEmail(aFavEmail), 
		awayMsg(aFavAway), 
		userProtected(aProtected) , 
		checkOnConnect(aCOC), 
		checkClients(aCC),
		checkFilelists(aCF), 
		checkMyInfo(aCMI), 
		hideShare(aHideShare), 
		checkFakeShare(aCFS), 
		useFilter(aFilter),
		autosearch(aAS),
		useHL(aHL),
		mode(aMode), 
		ip(aIp)
		{ }	

	GETSET(string, userdesc, UserDesc);
	GETSET(string, name, Name);
	GETSET(string, server, Server);
	GETSET(string, desc, Desc);
	GETSET(string, password, Password);
	GETSET(string, headerOrder, HeaderOrder);
	GETSET(string, headerWidths, HeaderWidths);
	GETSET(string, headerVisible, HeaderVisible);
	GETSET(bool, connect, Connect);
	GETSET(string, encoding, Encoding);
	GETSET(int, windowposx, WindowPosX);
	GETSET(int, windowposy, WindowPosY);
	GETSET(int, windowsizex, WindowSizeX);
	GETSET(int, windowsizey, WindowSizeY);
	GETSET(int, windowtype, WindowType);
	GETSET(int, chatusersplit, ChatUserSplit);
	GETSET(bool, stealth, Stealth);
	GETSET(bool, userliststate, UserListState);	
	GETSET(string, favEmail, FavEmail);
	GETSET(string, awayMsg, AwayMsg);
	GETSET(string, userProtected, UserProtected);
	GETSET(bool, checkOnConnect, CheckOnConnect);
	GETSET(bool, checkClients, CheckClients);
	GETSET(bool, checkFilelists, CheckFilelists);
	GETSET(bool, checkMyInfo, CheckMyInfo);
	GETSET(bool, hideShare, HideShare);
	GETSET(bool, checkFakeShare, CheckFakeShare);
	GETSET(bool, useFilter, UseFilter);
	GETSET(bool, autosearch, Autosearch);
	GETSET(bool, useHL, UseHL);
	GETSET(int, mode, Mode); // 0 = default, 1 = active, 2 = passive
	GETSET(string, ip, IP);

	const string& getNick(bool useDefault = true) const { 
		return (!nick.empty() || !useDefault) ? nick : SETTING(NICK);
	}
	void setNick(const string& aNick) { nick = aNick; }

private:
	string nick;
};
class SimpleXML;

class FileConverterDlg : public CDialogImpl<FileConverterDlg> {
	CEdit cInput;
	CEdit cOutput;
	CButton cUseFilter, cUseEmu, cUseHL, cDecode;

public:
	FileConverterDlg() { };
	~FileConverterDlg();

	tstring input, output;

	enum { IDD = IDD_FILE_CONVERTER_DLG };

	BEGIN_MSG_MAP_EX(CommandDlg)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_SETFOCUS, onFocus)
		COMMAND_ID_HANDLER(IDOK, OnCloseCmd)
		COMMAND_ID_HANDLER(IDC_CONVERT, OnConvert)
		COMMAND_ID_HANDLER(IDC_FILE_BROWSE, OnBrowse);
		COMMAND_ID_HANDLER(IDC_FILE_BROWSE_O, OnBrowseO);
	END_MSG_MAP()

	LRESULT onFocus(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
		cInput.SetFocus();
		return FALSE;
	}

	LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnBrowse(UINT /*uMsg*/, WPARAM /*wParam*/, HWND /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnBrowseO(UINT /*uMsg*/, WPARAM /*wParam*/, HWND /*lParam*/, BOOL& /*bHandled*/);
	LRESULT OnConvert(UINT /*uMsg*/, WPARAM /*wParam*/, HWND /*lParam*/, BOOL& /*bHandled*/) {
		TCHAR buf[MAX_PATH];
		GetDlgItemText(IDC_FC_OUTPUT, buf, MAX_PATH);
		tstring tmp = buf;

		if(input.empty()) {
			MessageBox(_T("No File choosen!"));
			return 0;
		} else if(tmp.empty()) {
			MessageBox(_T("No Directory choosen!"));
			return 0;
		}
		convertFile(Text::fromT(input));
		return 0;
	}

	LRESULT OnCloseCmd(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
		if(wID == IDOK) {
			TCHAR buf[256];

			#define GET_TEXT(id, var) \
			GetDlgItemText(id, buf, 256); \
			var = buf;
			GET_TEXT(IDC_FC_INPUT, input);
		}
		EndDialog(wID);
		return 0;
	}

private:
	CriticalSection cs;
	Favs::List favoriteHubs;

	void convertFile(const string& path);
	void loadFile(SimpleXML& aXml);
	void saveFile();
	bool dontSave;
};

} // namespace dcpp

#endif