/* 
 * Copyright (C) 2001-2006 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "../client/DCPlusPlus.h"
#include "../client/SettingsManager.h"
#include "../client/FavoriteManager.h"

#include "Resource.h"
#include "AdvancedPage.h"
#include "CommandDlg.h"
#include "../client/versiontemplate.h"
#include "WinUtil.h"

PropPage::TextItem AdvancedPage::texts[] = {
	{ IDC_CZDC_WINAMP, ResourceManager::SETCZDC_WINAMP },
//	{ IDC_SKIPLIST_GP, ResourceManager::SETTINGS_SKIPLIST_SHARE },
	{ 0, ResourceManager::SETTINGS_AUTO_AWAY }
};
PropPage::Item AdvancedPage::items[] = { { 0, 0, PropPage::T_END } };

AdvancedPage::ListItem AdvancedPage::listItems[] = {
	{ SettingsManager::AUTO_START, ResourceManager::SETTINGS_AUTO_START },
	{ SettingsManager::MINIMIZE_ON_STARTUP, ResourceManager::SETTINGS_MINIMIZE_ON_STARTUP },
	{ SettingsManager::DONT_ANNOUNCE_NEW_VERSIONS, ResourceManager::SETTINGS_DISPLAY_DC_UPDATE },
	{ SettingsManager::URL_HANDLER, ResourceManager::SETTINGS_URL_HANDLER },
	{ SettingsManager::MAGNET_REGISTER, ResourceManager::SETCZDC_MAGNET_URI_HANDLER },
    { SettingsManager::EXTERNAL_PREVIEW, ResourceManager::EXTERNAL_PREVIEW },
	{ SettingsManager::SETTINGS_STATE, ResourceManager::SETTINGS_STATE },
	{ SettingsManager::USE_CTRL_FOR_LINE_HISTORY, ResourceManager::SETTINGS_USE_CTRL_FOR_LINE_HISTORY },
	{ SettingsManager::AUTO_KICK, ResourceManager::SETTINGS_AUTO_KICK },
	{ SettingsManager::AUTO_KICK_NO_FAVS, ResourceManager::SETTINGS_AUTO_KICK_NO_FAVS },
	{ SettingsManager::AUTO_AWAY, ResourceManager::SETTINGS_AUTO_AWAY },
	{ SettingsManager::AUTO_FOLLOW, ResourceManager::SETTINGS_AUTO_FOLLOW },
	{ SettingsManager::FILTER_ENTER, ResourceManager::SETTINGS_FILTER_ENTER },
	{ SettingsManager::ADD_FINISHED_INSTANTLY, ResourceManager::ADD_FINISHED_INSTANTLY },
	{ SettingsManager::REMOVE_FORBIDDEN, ResourceManager::SETCZDC_REMOVE_FORBIDDEN },
	{ SettingsManager::KEEP_LISTS, ResourceManager::SETTINGS_KEEP_LISTS },
	{ SettingsManager::CLEAR_SEARCH, ResourceManager::SETTINGS_CLEAR_SEARCH },
	{ SettingsManager::USE_EXTENSION_DOWNTO, ResourceManager::SETTINGS_USE_EXTENSION_DOWNTO },
	{ SettingsManager::ADLS_BREAK_ON_FIRST, ResourceManager::SETTINGS_ADLS_BREAK_ON_FIRST },
	{ SettingsManager::COMPRESS_TRANSFERS, ResourceManager::SETTINGS_COMPRESS_TRANSFERS },
	{ SettingsManager::HUB_USER_COMMANDS, ResourceManager::SETTINGS_HUB_USER_COMMANDS },
	{ SettingsManager::SEND_UNKNOWN_COMMANDS, ResourceManager::SETTINGS_SEND_UNKNOWN_COMMANDS },
	{ SettingsManager::SEARCH_PASSIVE, ResourceManager::SETCZDC_PASSIVE_SEARCH },
	{ SettingsManager::WEBSERVER, ResourceManager::SETTINGS_WEBSERVER }, 
	{ SettingsManager::NO_AWAYMSG_TO_BOTS, ResourceManager::SETTINGS_NO_AWAYMSG_TO_BOTS },
	{ SettingsManager::DEBUG_COMMANDS, ResourceManager::SETTINGS_DEBUG_COMMANDS },
	{ SettingsManager::MAGNET_ASK, ResourceManager::MAGNET_ASK },
	{ SettingsManager::CORAL, ResourceManager::CORAL },
	{ SettingsManager::SHOW_SHELL_MENU, ResourceManager::SETTINGS_SHOW_SHELL_MENU },
	{ 0, ResourceManager::SETTINGS_AUTO_AWAY }
};

LRESULT AdvancedPage::onInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
	PropPage::read((HWND)*this, items, listItems, GetDlgItem(IDC_ADVANCED_BOOLEANS));

	CurSel = SETTING(MEDIA_PLAYER);
	WMPlayerStr = Text::toT(SETTING(WMP_FORMAT));
	MPCStr = Text::toT(SETTING(MPLAYERC_FORMAT));
	WinampStr = Text::toT(SETTING(WINAMP_FORMAT));
	iTunesStr = Text::toT(SETTING(ITUNES_FORMAT));	

	ctrlPlayer.Attach(GetDlgItem(IDC_PLAYER_COMBO));
	ctrlPlayer.AddString(_T("Windows Media Player"));
	ctrlPlayer.AddString(_T("Media Player Classic"));
	ctrlPlayer.AddString(_T("Winamp"));	
	ctrlPlayer.AddString(_T("iTunes"));
	
	ctrlPlayer.SetCurSel(CurSel);

	if(CurSel == 0) {
		SetDlgItemText(IDC_WINAMP, WMPlayerStr.c_str());
	} else if(CurSel == 1) {
		SetDlgItemText(IDC_WINAMP, MPCStr.c_str());
	} else if(CurSel == 2) {
		SetDlgItemText(IDC_WINAMP, WinampStr.c_str());
	} else if(CurSel == 3) {
		SetDlgItemText(IDC_WINAMP, iTunesStr.c_str());
	} else {
		SetDlgItemText(IDC_WINAMP, CTSTRING(NO_MEDIA_SPAM));		
		::EnableWindow(GetDlgItem(IDC_WINAMP), false);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), false);
	}

	// Do specialized reading here
	return TRUE;
}

void AdvancedPage::write() {
	PropPage::write((HWND)*this, items, listItems, GetDlgItem(IDC_ADVANCED_BOOLEANS));

	ctrlFormat.Attach(GetDlgItem(IDC_WINAMP));
	if(CurSel == 0) {
		WMPlayerStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		WMPlayerStr.resize(GetDlgItemText(IDC_WINAMP, &WMPlayerStr[0], WMPlayerStr.size()));
	} else if(CurSel == 1) {
		MPCStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		MPCStr.resize(GetDlgItemText(IDC_WINAMP, &MPCStr[0], MPCStr.size()));
	} else if(CurSel == 2) {
		WinampStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		WinampStr.resize(GetDlgItemText(IDC_WINAMP, &WinampStr[0], WinampStr.size()));
	} else if(CurSel == 3) {
		iTunesStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		iTunesStr.resize(GetDlgItemText(IDC_WINAMP, &iTunesStr[0], iTunesStr.size()));
	}
	ctrlFormat.Detach();

	SettingsManager::getInstance()->set(SettingsManager::MEDIA_PLAYER, ctrlPlayer.GetCurSel());
	SettingsManager::getInstance()->set(SettingsManager::WMP_FORMAT, Text::fromT(WMPlayerStr).c_str());
	SettingsManager::getInstance()->set(SettingsManager::MPLAYERC_FORMAT, Text::fromT(MPCStr).c_str());
	SettingsManager::getInstance()->set(SettingsManager::WINAMP_FORMAT, Text::fromT(WinampStr).c_str());	
	SettingsManager::getInstance()->set(SettingsManager::ITUNES_FORMAT, Text::fromT(iTunesStr).c_str());	

	HKEY hk;
	tstring app = _T("\"") + Text::toT(WinUtil::getAppName()) + _T("\"");

	if(::RegOpenKeyEx(HKEY_CURRENT_USER, _T("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run"), 0, KEY_WRITE | KEY_READ, &hk) == ERROR_SUCCESS) {
		if(BOOLSETTING(AUTO_START)) {
			::RegCreateKey(HKEY_CURRENT_USER, _T("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run"), &hk);
			::RegSetValueEx(hk, _T(APPNAME), 0, REG_SZ, (LPBYTE)app.c_str(), sizeof(TCHAR) * (app.length() + 1));
		} else {
			::RegDeleteValue(hk, _T(APPNAME));
		}
		::RegCloseKey(hk);
	}
}

LRESULT AdvancedPage::onClickedWinampHelp(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	if(CurSel == 0) {
		//MessageBox(CTSTRING(WINAMP_HELP), CTSTRING(WINAMP_HELP_DESC), MB_OK | MB_ICONINFORMATION);
		MessageBox(CTSTRING(WMP_HELP), CTSTRING(WMP_HELP_DESC), MB_OK | MB_ICONINFORMATION);
	} else if(CurSel == 1) {
		//MessageBox(CTSTRING(WMP_HELP), CTSTRING(WMP_HELP_DESC), MB_OK | MB_ICONINFORMATION);
		MessageBox(CTSTRING(MPC_HELP), CTSTRING(MPC_HELP_DESC), MB_OK | MB_ICONINFORMATION);
	} else if(CurSel == 2) {
		//MessageBox(CTSTRING(ITUNES_HELP), CTSTRING(ITUNES_HELP_DESC), MB_OK | MB_ICONINFORMATION);
		MessageBox(CTSTRING(WINAMP_HELP), CTSTRING(WINAMP_HELP_DESC), MB_OK | MB_ICONINFORMATION);
	} else if(CurSel == 3) {
		//MessageBox(CTSTRING(MPC_HELP), CTSTRING(MPC_HELP_DESC), MB_OK | MB_ICONINFORMATION);
		MessageBox(CTSTRING(ITUNES_HELP), CTSTRING(ITUNES_HELP_DESC), MB_OK | MB_ICONINFORMATION);
	}
	return S_OK;
}

LRESULT AdvancedPage::onSelChange(WORD /* wNotifyCode */, WORD /*wID*/, HWND /* hWndCtl */, BOOL& /* bHandled */) {
	ctrlFormat.Attach(GetDlgItem(IDC_WINAMP));
	if(CurSel == 0) {
		WMPlayerStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		WMPlayerStr.resize(GetDlgItemText(IDC_WINAMP, &WMPlayerStr[0], WMPlayerStr.size()));
	} else if(CurSel == 1) {
		MPCStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		MPCStr.resize(GetDlgItemText(IDC_WINAMP, &MPCStr[0], MPCStr.size()));
	} else if(CurSel == 2) {
		WinampStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		WinampStr.resize(GetDlgItemText(IDC_WINAMP, &WinampStr[0], WinampStr.size()));
	} else if(CurSel == 3) {
		iTunesStr.resize(ctrlFormat.GetWindowTextLength() + 1);
		iTunesStr.resize(GetDlgItemText(IDC_WINAMP, &iTunesStr[0], iTunesStr.size()));
	}
	ctrlFormat.Detach();

	CurSel = ctrlPlayer.GetCurSel();

	if(CurSel == 0) {
		SetDlgItemText(IDC_WINAMP, WMPlayerStr.c_str());
		::EnableWindow(GetDlgItem(IDC_WINAMP), true);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), true);
	} else if(CurSel == 1) {
		SetDlgItemText(IDC_WINAMP, MPCStr.c_str());
		::EnableWindow(GetDlgItem(IDC_WINAMP), true);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), true);
	} else if(CurSel == 2) {
		SetDlgItemText(IDC_WINAMP, WinampStr.c_str());
		::EnableWindow(GetDlgItem(IDC_WINAMP), true);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), true);
	} else if(CurSel == 3) {
		SetDlgItemText(IDC_WINAMP, iTunesStr.c_str());
		::EnableWindow(GetDlgItem(IDC_WINAMP), true);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), true);
	} else {
		SetDlgItemText(IDC_WINAMP, CTSTRING(NO_MEDIA_SPAM));
		::EnableWindow(GetDlgItem(IDC_WINAMP), false);
		::EnableWindow(GetDlgItem(IDC_WINAMP_HELP), false);
	}
	return 0;
}

/**
 * @file
 * $Id: AdvancedPage.cpp 404 2008-07-13 17:08:09Z BigMuscle $
 */
