typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned int __u32;
typedef __u16 __le16;
typedef __u32 __le32;
struct msdos_dir_entry {
  __u8    name[8],ext[3]; /* name and extension */
  __u8    attr;           /* attribute bits */
  __le32  size;           /* file size (in bytes) */
};
/* Up to 13 characters of the name */
struct msdos_dir_slot {
  __u8    id;             /* sequence number for slot */
  __u8    name0_4[10];    /* first 5 characters in name */
  __u8    attr;           /* attribute byte */
  __u8    reserved;       /* always 0 */
  __u8    name5_10[12];   /* 6 more characters in name */
  __u8    name11_12[4];   /* last 2 characters in name */
};

#define ATTR_RO         1       /* read-only */
#define ATTR_HIDDEN     2       /* hidden */
#define ATTR_SYS        4       /* system */
#define ATTR_VOLUME     8       /* volume label */
#define ATTR_DIR        16      /* directory */
#define ATTR_ARCH       32      /* archived */
/* bits that are used by the Windows 95/Windows NT extended FAT */
#define ATTR_EXT        (ATTR_RO | ATTR_HIDDEN | ATTR_SYS | ATTR_VOLUME)
